/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.channel;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnlnmService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ChannelAccountList
extends HRDataBaseList {
    private String parentFormId = "";

    public void beforeBindData(EventObject obj) {
        super.beforeBindData(obj);
        IFormView view = this.getView().getParentView();
        if (view == null) {
            return;
        }
        IFormView parentView = view.getParentView();
        if (parentView instanceof ListView) {
            this.parentFormId = ((ListView)parentView).getBillFormId();
        }
        if (this.parentFormId.equals("tsrbd_recruchnlnm")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrefresh", "tblclose", "cardview"});
            IFormView parentView2 = parentView.getParentView();
            this.setCheck(parentView2);
            this.setOperationByPermissions();
        }
    }

    public void setCheck(IFormView parentView2) {
        String billFormId;
        if (parentView2 != null && ("tstpm_addcandidate".equals(billFormId = parentView2.getFormShowParameter().getFormId()) || "tstpm_srrsm".equals(billFormId))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new_check", "delete_check", "listoperationcolumnap"});
        }
    }

    public void setOperationByPermissions() {
        if (!RecruchnlnmService.checkOpPermission((String)"tsrbd_channelaccount", (String)"47156aff000000ac")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new_check"});
        }
        if (!RecruchnlnmService.checkOpPermission((String)"tsrbd_channelaccount", (String)"4715a0df000000ac")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listoperationcolumnap"});
        }
        if (!RecruchnlnmService.checkOpPermission((String)"tsrbd_channelaccount", (String)"4715e1f1000000ac")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete_check"});
        }
    }

    public void registerListener(EventObject obj) {
        super.registerListener(obj);
        this.addItemClickListeners(new String[]{"tblnew"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "new_check".equals(operateKey)) {
            this.checkAddNew();
        }
    }

    private void checkAddNew() {
        if (this.parentFormId.equals("tsrbd_recruchnlnm")) {
            this.showChannelAccountEditPage();
        } else {
            this.getView().invokeOperation("new");
        }
    }

    private void showChannelAccountEditPage() {
        BaseShowParameter accountShowParameter = new BaseShowParameter();
        accountShowParameter.setFormId("tsrbd_channelaccount");
        accountShowParameter.setStatus(OperationStatus.ADDNEW);
        accountShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)accountShowParameter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if ("tsrbd_recruchnlnm".equals(this.parentFormId)) {
            List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            this.setDefault(filterColumns);
        }
    }

    public void setDefault(List<FilterColumn> filterColumns) {
        for (FilterColumn filterColumn : filterColumns) {
            if (!"createorg.number".equals(filterColumn.getFieldName())) continue;
            filterColumn.setDefaultValue("");
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        this.setPermissionsFilter(event);
        this.setRecChannelFilter(event);
        event.setOrderBy("createtime desc,recruchnlnm desc");
    }

    public void setPermissionsFilter(SetFilterEvent event) {
        QFilter qFilter = new QFilter("ispublic", "=", (Object)Character.valueOf('0'));
        QFilter qFilter2 = new QFilter("ispublic", "=", (Object)Character.valueOf('1')).and(new QFilter("creator", "=", (Object)TSCRequestContext.getUserId()));
        event.getQFilters().add(qFilter.or(qFilter2));
    }

    public void setRecChannelFilter(SetFilterEvent event) {
        QFilter qFilter = new QFilter("recruchnlnm", "in", ChannelAccountList.getAllRecChannelId());
        event.getQFilters().add(qFilter);
    }

    public static List<Long> getAllRecChannelId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_recruchnlnm");
        String selectProperties = "id,name,enable";
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        List<DynamicObject> recList = Arrays.asList(result);
        return recList.stream().map(object -> object.getLong("id")).collect(Collectors.toList());
    }
}

