/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.channel;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.fieldtip.DeleteRule;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnPermHelper;

public class ChannelContactPlugin
extends AbstractBillPlugIn {
    public static final String TELEPHONE = "telephone";

    public void afterBindData(EventObject obj) {
        super.afterBindData(obj);
        String noPermFlag = (String)this.getView().getFormShowParameter().getCustomParam("no_perm_flag");
        if (HRStringUtils.isNotEmpty((String)noPermFlag) && noPermFlag.equals("1")) {
            this.getView().showTipNotification(RecruchnPermHelper.getInstance().getChannelContactEditTip());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String email;
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        if (propertyName.equals(TELEPHONE)) {
            String telephone = this.getModel().getDataEntity().getString(TELEPHONE);
            boolean phoneNumberValid = StringUtils.isPhoneNumberValid((String)telephone);
            if (!phoneNumberValid) {
                this.getView().showFieldTip(ChannelContactPlugin.createFieldTip(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ChannelContactPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), TELEPHONE));
            }
        } else if (propertyName.equals("email") && (email = this.getModel().getDataEntity().getString("email")).length() > 100) {
            this.getView().showFieldTip(ChannelContactPlugin.createFieldTip(ResManager.loadKDString((String)"\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26\u3002", (String)"ChannelContactPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), "email"));
        }
    }

    public static FieldTip createFieldTip(String tips, String fieldKey) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, fieldKey, tips);
        fieldTip.setDeleteRule(ChannelContactPlugin.createDeleteRule(fieldKey));
        return fieldTip;
    }

    public void beforeBindData(EventObject obj) {
        super.beforeBindData(obj);
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
    }

    public static DeleteRule createDeleteRule(String ... fieldKey) {
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Arrays.asList(fieldKey));
        return deleteRule;
    }
}

