/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.channel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnPermHelper;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnlnmService;
import org.apache.commons.collections.CollectionUtils;

public class RecruchnlnmDetailEdit
extends HRDataBaseEdit
implements TabSelectListener {
    private static final String KEY_EDIT = "lblmodify";
    public static final String LAB_ADVERTISEMENT = "labadvertisement";
    public static final String LAB_MULTIFUNCTIONAL = "labmultifunctional";
    public static final String LAB_COUNTRY = "lblcountry";
    public static final String LAB_RECJOBLEVEL = "lblrecjoblevel";
    public static final String LAB_RECORG = "lblrecorg";
    public static final String TAB_CHNACCOUNT = "tabchnaccount";
    public static final String TAB_CHNCONTRACT = "tabchncontract";
    public static final String TAB_CHNCONTACT = "tabchncontact";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{KEY_EDIT});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BaseShowParameter formShowParameter = (BaseShowParameter)args.getFormShowParameter();
        Long pkId = (Long)formShowParameter.getPkId();
        DynamicObject channelById = RecruchnlnmService.getChannelById((Long)pkId);
        String chnName = channelById.getString("name");
        args.getFormShowParameter().setCaption(chnName);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)KEY_EDIT)) {
            boolean isEditPerm = RecruchnPermHelper.getInstance().verifyChannelPerm("edit");
            if (!isEditPerm) {
                String verifyTip = RecruchnPermHelper.getInstance().getRecruitChnEditTip();
                this.getView().showTipNotification(verifyTip);
                return;
            }
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("tsrbd_recruchnlnm_add");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setPkId((Object)this.getModel().getDataEntity().getLong("id"));
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsrbd_recruchnlnm_add"));
            showParameter.setCustomParam("tsrbd_recruchnlnmdetail", (Object)"tsrbd_recruchnlnmdetail");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getBoolean("issyspreset")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_EDIT});
        }
        String advPubType = dataEntity.getString("advertisement");
        String advComboVal = this.getComboItemValue("advertisement", Lists.newArrayList((Object[])new String[]{advPubType}));
        Label lblAdvPugType = (Label)this.getView().getControl(LAB_ADVERTISEMENT);
        lblAdvPugType.setText(advComboVal);
        String multiFun = dataEntity.getString("multifunctional");
        String[] split = multiFun.split(",");
        String lblMultiFunComboValue = this.getComboItemValue("multifunctional", Arrays.asList(split));
        Label lblMultiFun = (Label)this.getView().getControl(LAB_MULTIFUNCTIONAL);
        lblMultiFun.setText(lblMultiFunComboValue);
        String cityNameJoin = this.getDynamicColName(dataEntity, "country");
        Label lblCountry = (Label)this.getView().getControl(LAB_COUNTRY);
        lblCountry.setText(cityNameJoin);
        String recorgNameJoin = this.getDynamicColName(dataEntity, "recorg");
        Label lblRecorg = (Label)this.getView().getControl(LAB_RECORG);
        lblRecorg.setText(recorgNameJoin);
        String recJobLevelJoin = this.getDynamicColName(dataEntity, "recjoblevel");
        Label lblRecJobLevel = (Label)this.getView().getControl(LAB_RECJOBLEVEL);
        lblRecJobLevel.setText(recJobLevelJoin);
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(TAB_CHNACCOUNT);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.refreshTabView();
    }

    private void refreshTabView() {
        String openTab = this.getView().getPageCache().get("tsrbd_recruchnlnmdetail");
        if (HRStringUtils.isNotEmpty((String)openTab)) {
            IFormView subView = this.getView().getView(openTab);
            subView.invokeOperation("refresh");
            this.getView().sendFormAction(subView);
        }
    }

    private String getComboItemValue(String fieldKey, List<String> keys) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(fieldKey);
        IDataEntityProperty property = comboEdit.getProperty();
        ArrayList<String> resList = new ArrayList<String>(10);
        for (String key : keys) {
            List comboItems = ((ComboProp)property).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(key)) continue;
                String comboName = comboItem.getName().toString();
                resList.add(comboName);
            }
        }
        return CollectionUtils.isEmpty(resList) ? "" : String.join((CharSequence)",", resList);
    }

    public String getDynamicColName(DynamicObject dataEntity, String key) {
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection(key);
        return col.stream().filter(ob -> !HRObjectUtils.isEmpty((Object)ob.getDynamicObject("fbasedataid"))).map(obj -> obj.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(","));
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey = event.getTabKey();
        long chnId = this.getModel().getDataEntity().getLong("id");
        ListFilterParameter listFilterParam = new ListFilterParameter();
        listFilterParam.setFilter(new QFilter("recruchnlnm", "=", (Object)chnId));
        switch (subTabKey) {
            case "tabchnaccount": {
                boolean hasViewAccount = RecruchnPermHelper.getInstance().verifyChannelAccountPerm("view");
                if (!hasViewAccount) {
                    String verifyTip = RecruchnPermHelper.getInstance().getChannelAccountViewTip();
                    this.getView().showTipNotification(verifyTip);
                    break;
                }
                this.openListFormInTab("tsrbd_channelaccount_view", TAB_CHNACCOUNT, listFilterParam);
                break;
            }
            case "tabchncontract": {
                boolean hasViewContract = RecruchnPermHelper.getInstance().verifyChannelContractPerm("view");
                if (!hasViewContract) {
                    String verifyTip = RecruchnPermHelper.getInstance().getChannelContractViewTip();
                    this.getView().showTipNotification(verifyTip);
                    break;
                }
                this.openListFormInTab("tsrbd_chncontractcardview", TAB_CHNCONTRACT, listFilterParam);
                break;
            }
            case "tabchncontact": {
                boolean hasViewContact = RecruchnPermHelper.getInstance().verifyChannelContactPerm("view");
                if (!hasViewContact) {
                    String verifyTip = RecruchnPermHelper.getInstance().getChannelContactViewTip();
                    this.getView().showTipNotification(verifyTip);
                    break;
                }
                this.openListFormInTab("tsrbd_channelcontact_list", TAB_CHNCONTACT, listFilterParam);
                break;
            }
        }
    }

    private void openListFormInTab(String listFormId, String targetKey, ListFilterParameter listFilterParameter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(listFormId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setCustomParam("is_channel_tab", (Object)"1");
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, listFormId));
        showParameter.setFormId("tsrbd_listwite");
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().getPageCache().put("tsrbd_recruchnlnmdetail", showParameter.getPageId());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
        this.refreshTabView();
    }
}

