/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.channel;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnlnmService;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class RecruchnlnmList
extends HRDataBaseList {
    private static String parentPormId = "";
    public static final String COPY_PERM = "4730fc9f000020ae";
    private static final String F7 = "bos_listf7";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        if (this.getView() instanceof ListView) {
            parentPormId = ((ListView)this.getView()).getBillFormId();
        }
    }

    public void afterBindData(EventObject event) {
        HashMap customStyleMap = Maps.newHashMapWithExpectedSize((int)1);
        customStyleMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiW2NvbC1pZD0nbXVsdGlmdW5jdGlvbmFsJ10gaW1ne1xuIG1hcmdpbi1yaWdodDo4cHghaW1wb3J0YW50OyBcbn0ifQ==");
        this.getView().updateControlMetadata("flexpanelap1", (Map)customStyleMap);
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        String key = ((AbstractColumnDesc)event.getSource()).getKey();
        if ("rectime".equals(key)) {
            Date expTime = event.getRowData().getDate("expiretime");
            Date effTime = event.getRowData().getDate("efftime");
            if (expTime != null) {
                event.setFormatValue((Object)(DateUtils.formatDate((Date)effTime, (String)"yyyy-MM-dd") + "-" + DateUtils.formatDate((Date)expTime, (String)"yyyy-MM-dd")));
            }
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{"tblnew"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblnew".equals(key)) {
            if (!RecruchnlnmService.checkOpPermission((String)"tsrbd_recruchnlnm", (String)"47156aff000000ac")) {
                this.getView().showErrorNotification(RecruchnlnmService.getAddFailPermissionError());
                return;
            }
            this.showAddPage();
        } else if ("tblcopy".equals(key)) {
            this.showCopyPage();
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
        Long pkId = (Long)((BillListHyperLinkClickEvent)evt.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tsrbd_recruchnlnm_add");
        if (RecruchnlnmService.checkOpPermission((String)"tsrbd_recruchnlnm_add", (String)"4715a0df000000ac")) {
            baseShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            baseShowParameter.setStatus(OperationStatus.VIEW);
        }
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showInfoPage() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow currentListSelectedRow = listView.getCurrentSelectedRowInfo();
        BaseShowParameter channelShowParameter = new BaseShowParameter();
        channelShowParameter.setPageId(this.getView().getPageId() + currentListSelectedRow.getPrimaryKeyValue());
        channelShowParameter.setFormId("tsrbd_recruchnlnmdetail");
        channelShowParameter.setPkId(currentListSelectedRow.getPrimaryKeyValue());
        channelShowParameter.setStatus(OperationStatus.VIEW);
        channelShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        channelShowParameter.setCustomParam("name", (Object)currentListSelectedRow.getName());
        this.getView().showForm((FormShowParameter)channelShowParameter);
    }

    private void showAddPage() {
        BaseShowParameter accountShowParameter = new BaseShowParameter();
        accountShowParameter.setFormId("tsrbd_recruchnlnm_add");
        accountShowParameter.setStatus(OperationStatus.ADDNEW);
        accountShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)accountShowParameter);
    }

    private void showCopyPage() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u6570\u636e");
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification("\u6682\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u64cd\u4f5c\uff0c\u8bf7\u5355\u6761\u590d\u5236");
            return;
        }
        long selectedRow = Long.parseLong(selectedRows.get(0).getPrimaryKeyValue().toString());
        BaseShowParameter accountShowParameter = new BaseShowParameter();
        accountShowParameter.setFormId("tsrbd_recruchnlnm_add");
        accountShowParameter.setStatus(OperationStatus.ADDNEW);
        accountShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        accountShowParameter.setCustomParam("selectrow", (Object)selectedRow);
        this.getView().showForm((FormShowParameter)accountShowParameter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        commonFilterColumns.add(3, RecruchnlnmService.getCommonBaseDataFilterColumn());
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        RecruchnlnmService.setFilter((String)parentPormId, (SetFilterEvent)event);
        if (F7.equals(this.getView().getEntityId())) {
            QFilter qFilter = new QFilter("id", "!=", (Object)1180L);
            event.getQFilters().add(qFilter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }
}

