/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interview;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;
import kd.tsc.tsrbd.business.domain.interview.service.InterviewQualifyService;

public class InterviewQualifyBillList
extends HRCoreBaseBillList {
    public void registerListener(EventObject event) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("delay")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        String key = ((AbstractColumnDesc)event.getSource()).getKey();
        long nowDatetimes = System.currentTimeMillis();
        if ("eff".equals(key)) {
            Date pubTime = event.getRowData().getDate("expiretime");
            Date curDate = DateUtils.addMonths((Date)new Date(), (int)1);
            if (curDate.getTime() > pubTime.getTime() && pubTime.getTime() > nowDatetimes) {
                event.setFormatValue((Object)1);
            } else if (pubTime.getTime() < nowDatetimes) {
                event.setFormatValue((Object)3);
            } else {
                event.setFormatValue((Object)2);
            }
        } else if ("iseff".equals(key)) {
            Date pubTime = event.getRowData().getDate("expiretime");
            long pubDateTimes = pubTime.getTime();
            if (nowDatetimes < pubDateTimes) {
                event.setFormatValue((Object)ResManager.loadKDString((String)"\u751f\u6548\u4e2d", (String)"IntverFileentryPlugin_1", (String)"tsc-tsivm-formplugin", (Object[])new Object[0]));
            } else {
                event.setFormatValue((Object)ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"IntverFileentryPlugin_2", (String)"tsc-tsivm-formplugin", (Object[])new Object[0]));
            }
        } else if ("expiretime".equals(key)) {
            Date pubTime = event.getRowData().getDate("expiretime");
            if (nowDatetimes > pubTime.getTime()) {
                event.setFormatValue((Object)ResManager.loadKDString((String)"\u5df2\u8fc7\u671f", (String)"IntverFileentryPlugin_3", (String)"tsc-tsivm-formplugin", (Object[])new Object[0]));
            }
        } else if ("company".equals(key) || "department".equals(key) || "position".equals(key)) {
            Long personid = (Long)event.getRowData().getDynamicObject("personid").getPkValue();
            Map person = HRUserService.getPersonInfo((Long)personid);
            if ("company".equals(key)) {
                event.setFormatValue((Object)HRUserService.getCompany((Map)person));
            } else if ("department".equals(key)) {
                event.setFormatValue((Object)HRUserService.getAdminorg((Map)person));
            } else if ("position".equals(key)) {
                event.setFormatValue((Object)HRUserService.getPosition((Map)person));
            }
        }
    }

    public void afterBindData(EventObject obj) {
        super.afterBindData(obj);
        this.getView().setVisible(Boolean.FALSE, new String[]{"eff"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
        ListSelectedRow listSelectedRow = this.getCurrentListAllRowCollection().get(rowIndex);
        long pkId = Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString());
        if ("applynumber".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject entity = InterviewQualifyService.queryOne((Object)pkId);
            long applyid = entity.getLong("applyid");
            InterviewQualifyBillList.openIntverapplyPage(this.getView(), applyid);
        } else if ("number".equals(fieldName)) {
            args.setCancel(true);
            InterviewQualifyBillList.openIntverDetailPage(this.getView(), pkId);
        }
    }

    public static void openIntverapplyPage(IFormView view, long pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsivm_interviewmyapply");
        DynamicObject intervieApply = serviceHelper.queryOne((Object)pkId);
        DynamicObject bosUser = intervieApply.getDynamicObject("applyuser");
        String userName = bosUser.getString("name");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsivm_interviewmyapply");
        showParameter.setCaption(userName + ResManager.loadKDString((String)"\u7684\u9762\u8bd5\u5b98\u7533\u8bf7", (String)"InterviewerHelper_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setPkId((Object)pkId);
        showParameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void openIntverDetailPage(IFormView view, long pkId) {
        DynamicObject entity = InterviewQualifyService.queryOne((Object)pkId);
        String type = entity.getDynamicObject("intvertypeid").getString("name");
        DynamicObject person = entity.getDynamicObject("personid");
        long personId = person.getLong("id");
        String personName = person.getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsivm_interviewqualiview");
        showParameter.setCaption(type + personName);
        showParameter.setCustomParam("personid", (Object)personId);
        showParameter.setCustomParam("entryid", (Object)pkId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        view.showForm(showParameter);
    }

    public void afterExportFile(ExportFileEvent event) {
        super.afterExportFile(event);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qfilter = null;
        for (int i = 0; i < qFilters.size(); ++i) {
            QFilter qf = (QFilter)qFilters.get(i);
            if (!qf.getProperty().equals("qualifystatus")) continue;
            String value = (String)qf.getValue();
            if ("I".equals(value)) {
                qfilter = new QFilter("expiretime", "<", (Object)new Date());
            } else if ("A".equals(value)) {
                qfilter = new QFilter("expiretime", ">", (Object)new Date());
            }
            qFilters.remove(i--);
        }
        if (qfilter != null) {
            List filters = e.getQFilters();
            filters.add(qfilter);
            e.setQFilters(filters);
        }
    }
}

