/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interview;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class InterviewQualifyTreePlugin
extends AbstractTreeListPlugin {
    public void refreshNode(RefreshNodeEvent event) {
        super.refreshNode(event);
        if (HRStringUtils.equals((String)this.getTreeModel().getRoot().getId(), (String)event.getNodeId().toString())) {
            event.setChildNodes(this.initNode());
        }
    }

    private List<TreeNode> initNode() {
        DBRoute dbRoute = new DBRoute("tsc");
        String sql = "select fintvertypeid as nodeId from t_tsrbd_intverqualify group by fintvertypeid";
        Set res = (Set)HRDBUtil.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)rs.getFetchSize());
                while (rs.next()) {
                    ids.add(rs.getLong("nodeId"));
                }
                return ids;
            }
        });
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsrbd_interviewtype");
        DynamicObject[] dyns = helper.query(new QFilter[]{new QFilter("id", "in", (Object)res)});
        this.getTreeModel().setRootVisable(true);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        ArrayList nodeList = Lists.newArrayListWithCapacity((int)dyns.length);
        for (DynamicObject dyn : dyns) {
            nodeList.add(new TreeNode(root.getId(), dyn.getPkValue().toString(), dyn.getString("name")));
        }
        return nodeList;
    }

    public void initTreeToolbar(EventObject eventObject) {
        super.initTreeToolbar(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        super.buildTreeListFilter(event);
        ITreeModel treeModel = this.getTreeModel();
        if (!event.getNodeId().equals(treeModel.getRoot().getId())) {
            event.addQFilter(new QFilter("intvertypeid", "=", (Object)Long.parseLong(event.getNodeId().toString())));
        }
    }
}

