/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviewer;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerFamilyScmHelper;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerQueryHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class InterviewerLevelPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String ADDINTVRANGE = "addintvrange";
    public static final String ADD_INTV_RANGE = "addIntvRange";
    public static final String[] UN_CHANGED_PROPS = new String[]{"joblevelscm", "rankrange"};
    public static final String SAVEANDNEW = "saveandnew";
    public static final String INTV_TYPE_ID = "intvTypeId";
    public static final String IS_BACK = "isBack";
    public static final String IS_SWITCH_TYPE = "isSwitchType";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        Toolbar addintvrange = (Toolbar)this.getView().getControl("intvrangetoolbarap");
        addintvrange.addItemClickListener((ItemClickListener)this);
        BasedataEdit lowJobLevel = (BasedataEdit)this.getControl("lowjoblevel");
        lowJobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit highJobLevel = (BasedataEdit)this.getControl("highjoblevel");
        highJobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String unChangedProp : UN_CHANGED_PROPS) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("bar_saveandnew") || itemKey.equals("bar_save")) {
            DynamicObjectCollection rankrangeentry;
            DynamicObject intvType = this.getModel().getDataEntity().getDynamicObject("interviewertype");
            Boolean isContains = this.MECheck(intvType, rankrangeentry = this.getModel().getEntryEntity("rankrangeentry"));
            if (!isContains.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"InterviewerLevelPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (itemKey.equals("bar_saveandnew")) {
                this.getView().getPageCache().put(SAVEANDNEW, this.getModel().getDataEntity().getDynamicObject("interviewertype").getString("id"));
                this.getView().invokeOperation(SAVEANDNEW);
            } else {
                OperationResult operationResult = this.getView().invokeOperation("save");
                if (operationResult.isSuccess()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"interviewertype"});
                }
            }
        }
        if (itemKey.equals(ADDINTVRANGE)) {
            QFilter filter;
            int f7Style = 0;
            DynamicObject interviewertype = this.getModel().getDataEntity().getDynamicObject("interviewertype");
            if (interviewertype != null) {
                DynamicObjectCollection jobclasshrentry = interviewertype.getDynamicObjectCollection("jobclasshrentry");
                if (jobclasshrentry.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u9762\u8bd5\u5b98\u7c7b\u578b\u4e2d\u914d\u7f6e\u53ef\u9762\u8bd5\u804c\u4f4d\u7c7b\u3002", (String)"InterviewerLevelPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                }
                ArrayList jobClasshrIds = new ArrayList(10);
                for (DynamicObject jobclasshr : jobclasshrentry) {
                    long jobClasshrId = jobclasshr.getLong("jobclasshr.id");
                    jobClasshrIds.add(jobClasshrId);
                }
                filter = new QFilter("id", "in", (Object)jobClasshrIds);
            } else {
                filter = new QFilter("id", "=", null);
            }
            DynamicObjectCollection rankRangeEntry = this.getModel().getEntryEntity("rankrangeentry");
            if (rankRangeEntry != null) {
                for (DynamicObject rankRange : rankRangeEntry) {
                    filter.and(new QFilter("id", "!=", (Object)rankRange.getLong("jobclasshr.id")));
                }
            }
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hbjm_jobclasshr", (boolean)true, (int)f7Style);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_INTV_RANGE));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.nonNull(returnData) && closedCallBackEvent.getActionId().equals(ADD_INTV_RANGE) && returnData instanceof ListSelectedRowCollection) {
            int size = ((ListSelectedRowCollection)returnData).size();
            this.getModel().batchCreateNewEntryRow("rankrangeentry", size);
            int start = 0;
            DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity().getDynamicObjectCollection("rankrangeentry");
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                start = dynamicObjects.size();
            }
            for (ListSelectedRow listSelectedRow : (ListSelectedRowCollection)returnData) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"hbjm_jobclasshr", (String)String.join((CharSequence)",", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue())});
                this.getModel().setValue("jobclasshr", (Object)obj, start);
                DynamicObject jobScm = this.getModel().getDataEntity().getDynamicObject("jobscmhr");
                DynamicObject jobFamily = InterviewerFamilyScmHelper.getJobFamilyByJobClass((DynamicObject)obj);
                DynamicObject jobLevel = InterviewerFamilyScmHelper.getJobLevel((DynamicObject)jobScm, (DynamicObject)jobFamily);
                if (jobLevel != null) {
                    this.getModel().setValue("joblevelscm", (Object)jobLevel.getString("name"), start);
                    Map jobLevelHR = InterviewerFamilyScmHelper.getJobLevelHR((DynamicObject)jobLevel);
                    Map jobLevelHRId = InterviewerFamilyScmHelper.getjobLevelRangeId((Map)jobLevelHR);
                    this.getModel().setValue("lowjoblevel", jobLevelHRId.get("lowjoblevel"), start);
                    this.getModel().setValue("highjoblevel", jobLevelHRId.get("highjoblevel"), start);
                }
                Map jobLevelRange = InterviewerFamilyScmHelper.getJobLevelRange((DynamicObject)jobScm, (DynamicObject)obj);
                DynamicObject lowjoblevel = (DynamicObject)jobLevelRange.get("lowjoblevel");
                DynamicObject highjoblevel = (DynamicObject)jobLevelRange.get("highjoblevel");
                if (lowjoblevel != null && highjoblevel != null) {
                    this.getModel().setValue("rankrange", (Object)(lowjoblevel.getString("name") + "-" + highjoblevel.getString("name")), start);
                    this.getModel().setValue("lowjoblevel", (Object)lowjoblevel, start);
                    this.getModel().setValue("highjoblevel", (Object)highjoblevel, start);
                }
                ++start;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("interviewertype")) {
            long interviewerTypeId = this.getModel().getDataEntity().getLong("interviewertype.id");
            if (interviewerTypeId != 0L) {
                this.init(interviewerTypeId);
            }
            DynamicObjectCollection rankRange = this.getModel().getEntryEntity("rankrangeentry");
            String isBack = this.getView().getPageCache().get(IS_BACK);
            if (rankRange.size() > 0 && !"Yes".equals(isBack)) {
                HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
                String msg = ResManager.loadKDString((String)"\u5207\u6362\u9762\u8bd5\u5b98\u7c7b\u578b\uff0c\u53ef\u9762\u804c\u7ea7\u8303\u56f4\u5c06\u4f1a\u6e05\u7a7a\uff0c\u786e\u8ba4\u5207\u6362\u5417\uff1f", (String)"InterviewerLevelPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                this.PWindow(IS_SWITCH_TYPE, btnNameMaps, msg);
            } else {
                DynamicObject intvType = this.getModel().getDataEntity().getDynamicObject("interviewertype");
                if (intvType == null) {
                    this.getView().getPageCache().put(INTV_TYPE_ID, "");
                } else {
                    this.getView().getPageCache().put(INTV_TYPE_ID, intvType.getString("id"));
                }
            }
            if ("Yes".equals(isBack)) {
                this.getView().getPageCache().put(IS_BACK, "Cancel");
            }
        } else if (name.equals("intverlevel")) {
            this.getModel().setValue("name", (Object)this.getModel().getDataEntity().getString("intverlevel"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String resultValue = messageBoxClosedEvent.getResultValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"Cancel", (CharSequence)resultValue) && StringUtils.equals((CharSequence)IS_SWITCH_TYPE, (CharSequence)callBackId)) {
            this.getView().getPageCache().put(IS_BACK, "Yes");
            String intvTypeId = this.getView().getPageCache().get(INTV_TYPE_ID);
            this.getModel().setValue("interviewertype", (Object)Long.valueOf(intvTypeId));
        } else {
            DynamicObjectCollection rankRangeEntry = this.getModel().getEntryEntity("rankrangeentry");
            for (int num = rankRangeEntry.size() - 1; num >= 0; --num) {
                this.getModel().deleteEntryRow("rankrangeentry", num);
            }
            DynamicObject intvType = this.getModel().getDataEntity().getDynamicObject("interviewertype");
            if (intvType == null) {
                this.getView().getPageCache().put(INTV_TYPE_ID, "");
            } else {
                this.getView().getPageCache().put(INTV_TYPE_ID, intvType.getString("id"));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObject intvType;
        DynamicObject dataEntity;
        long intvLevelId;
        DynamicObject intvLevel;
        String saveandnew;
        super.beforeBindData(e);
        Long interviewerTypeId = (Long)this.getView().getFormShowParameter().getCustomParam("interviewerTypeId");
        if (interviewerTypeId != null) {
            this.init(interviewerTypeId);
        }
        if ((saveandnew = this.getView().getPageCache().get(SAVEANDNEW)) != null) {
            Long interviewerTypeId2 = Long.valueOf(saveandnew);
            this.init(interviewerTypeId2);
            this.getView().setEnable(Boolean.TRUE, new String[]{"interviewertype"});
        }
        if ((intvLevel = InterviewerQueryHelper.getIntvLevelById((Long)(intvLevelId = (dataEntity = this.getModel().getDataEntity()).getLong("id")))) != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"interviewertype"});
            this.fillRankRange();
        }
        if ((intvType = this.getModel().getDataEntity().getDynamicObject("interviewertype")) == null) {
            this.getView().getPageCache().put(INTV_TYPE_ID, "");
        } else {
            this.getView().getPageCache().put(INTV_TYPE_ID, intvType.getString("id"));
        }
    }

    public void init(Long interviewerTypeId) {
        DynamicObject interviewerType = InterviewerQueryHelper.getInterviewerTypeById((Long)interviewerTypeId);
        this.getModel().setValue("interviewertype", (Object)interviewerType);
        this.getModel().setValue("jobscmhr", interviewerType.get("jobscmhr"));
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscmhr");
        int rankrangeentryIndex = this.getModel().getEntryCurrentRowIndex("rankrangeentry");
        DynamicObjectCollection rankrangeentry = this.getModel().getEntryEntity("rankrangeentry");
        DynamicObject jobClass = ((DynamicObject)rankrangeentry.get(rankrangeentryIndex)).getDynamicObject("jobclasshr");
        DynamicObject jobFamily = InterviewerFamilyScmHelper.getJobFamilyByJobClass((DynamicObject)jobClass);
        DynamicObject highJobLevel = ((DynamicObject)rankrangeentry.get(rankrangeentryIndex)).getDynamicObject("highjoblevel");
        DynamicObject lowJobLevel = ((DynamicObject)rankrangeentry.get(rankrangeentryIndex)).getDynamicObject("lowjoblevel");
        if ("lowjoblevel".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(js -> {
                QFilter filter = InterviewerFamilyScmHelper.getLowJobLevelFilter((DynamicObject)jobScm, (DynamicObject)jobFamily, (DynamicObject)jobClass, (DynamicObject)highJobLevel);
                event.addCustomQFilter(filter);
            });
        }
        if ("highjoblevel".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(js -> {
                QFilter filter = InterviewerFamilyScmHelper.getHighJobLevelFilter((DynamicObject)jobScm, (DynamicObject)jobFamily, (DynamicObject)jobClass, (DynamicObject)lowJobLevel);
                event.addCustomQFilter(filter);
            });
        }
    }

    public void fillRankRange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject intvType = dataEntity.getDynamicObject("interviewertype");
        DynamicObjectCollection rankRanges = this.getModel().getEntryEntity("rankrangeentry");
        for (int num = 0; num < rankRanges.size(); ++num) {
            Map jobLevelRange = InterviewerFamilyScmHelper.getJobLevelRange((DynamicObject)intvType.getDynamicObject("jobscmhr"), (DynamicObject)((DynamicObject)rankRanges.get(num)).getDynamicObject("jobclasshr"));
            DynamicObject lowjoblevel = (DynamicObject)jobLevelRange.get("lowjoblevel");
            DynamicObject highjoblevel = (DynamicObject)jobLevelRange.get("highjoblevel");
            if (lowjoblevel != null && highjoblevel != null) {
                this.getModel().setValue("rankrange", (Object)(lowjoblevel.getString("name") + "-" + highjoblevel.getString("name")), num);
            }
            DynamicObject jobFamily = InterviewerFamilyScmHelper.getJobFamilyByJobClass((DynamicObject)((DynamicObject)rankRanges.get(num)).getDynamicObject("jobclasshr"));
            DynamicObject jobLevel = InterviewerFamilyScmHelper.getJobLevel((DynamicObject)intvType.getDynamicObject("jobscmhr"), (DynamicObject)jobFamily);
            if (jobLevel == null) continue;
            this.getModel().setValue("joblevelscm", (Object)jobLevel.getString("name"), num);
        }
    }

    public Boolean MECheck(DynamicObject intvType, DynamicObjectCollection rankrangeentry) {
        DynamicObjectCollection jobclasshrentry = intvType.getDynamicObjectCollection("jobclasshrentry");
        ArrayList<Long> jobclasshrList = new ArrayList<Long>();
        for (DynamicObject jobclasshr : jobclasshrentry) {
            jobclasshrList.add(jobclasshr.getDynamicObject("jobclasshr").getLong("id"));
        }
        for (DynamicObject rankrange : rankrangeentry) {
            if (jobclasshrList.contains(rankrange.getDynamicObject("jobclasshr").getLong("id"))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void PWindow(String callBackStr, Map<Integer, String> btnNameMaps, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackStr, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }
}

