/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviewer;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerPermHelper;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerQueryHelper;
import kd.tsc.tsrbd.formplugin.web.interviewer.InterviewerLevelPlugin;
import org.apache.commons.lang3.StringUtils;

public class IntverLevelDetailsPlugin
extends AbstractBillPlugIn {
    public static final String INTVERLEVELLABELAP = "intverlevellabelap";
    public static final String BTN_EDIT = "btn_edit";
    public static final String BTN_DETELE = "btn_detele";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_CANCEL = "btn_cancel";
    public static final String ENTITY_ID = "entityId";
    public static final String DYNAMIC_OBJECT = "dynamicObject";
    public static final String NUMBER_KEY = "numberKey";
    public static final String PLEASE_CONFIGURE_RULES_ON_THE_PLATFORM = "please configure rules on the platform";
    public static final String BTN_CANCEL_CALLBACK = "btnCancel";
    public static final String SAVELEVEL = "savelevel";
    public static final String[] UN_CHANGED_PROPS = new String[]{"name", "number", "interviewertype", "jobscmhr", "creator", "modifier", "createtime", "modifytime", "disabledate", "disabler", "creator_id", "modifier_id", "disabler_id"};
    public static final String OPENORCLOSE = "openorclose";
    public static final String OPEN = "open";
    public static final String ISNEWPAGE = "isnewpage";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EDIT, BTN_DETELE, BTN_SAVE, BTN_CANCEL});
        this.addClickListeners(new String[]{"openap", "closeap"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String unChangedProp : UN_CHANGED_PROPS) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        boolean delete;
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String intverLevel = dataEntity.getString("intverlevel");
        if (!intverLevel.equals("")) {
            Label label = (Label)this.getView().getControl(INTVERLEVELLABELAP);
            label.setText(intverLevel);
            this.setPageStatus(Boolean.FALSE);
        } else {
            DynamicObject intvLevel = InterviewerQueryHelper.levelServiceHelper.generateEmptyDynamicObject();
            this.generateOneCodeRule("number", "tsrbd_intverlevel", intvLevel);
            Long interviewerTypeId = (Long)this.getView().getFormShowParameter().getCustomParam("interviewerTypeId");
            DynamicObject interviewerType = InterviewerQueryHelper.getInterviewerTypeById((Long)interviewerTypeId);
            this.getModel().setValue("number", intvLevel.get("number"));
            this.getModel().setValue("interviewertype", (Object)interviewerType);
            this.getModel().setValue("jobscmhr", interviewerType.get("jobscmhr"));
            this.setPageStatus(Boolean.TRUE);
            this.getView().getPageCache().put(ISNEWPAGE, "new");
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        boolean modify = InterviewerPermHelper.getInstance().verifyHasIntvLevelPerm("modify");
        if (!modify) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT});
        }
        if (!(delete = InterviewerPermHelper.getInstance().verifyHasIntvLevelPerm("delete"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DETELE});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"closeap"});
    }

    public void setPageStatus(Boolean isEditable) {
        this.getView().setEnable(isEditable, new String[]{"intverlevel", "bizdescription"});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("rankrangeentry");
        for (int num = 0; num < entryEntity.size(); ++num) {
            this.getView().setEnable(isEditable, num, new String[]{"lowjoblevel", "highjoblevel"});
        }
        this.getView().setVisible(Boolean.valueOf(isEditable == false), new String[]{BTN_EDIT, BTN_DETELE});
        this.getView().setVisible(isEditable, new String[]{BTN_SAVE, BTN_CANCEL});
        this.getView().setVisible(isEditable, new String[]{"intvrangetoolbarap"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_edit": {
                String intvLevelNum = this.getModel().getDataEntity().getString("number");
                DynamicObject intvLevel = InterviewerQueryHelper.getIntvLevelByNum((String)intvLevelNum);
                if (intvLevel == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5", (String)"IntverLevelDetailsPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setPageStatus(Boolean.TRUE);
                break;
            }
            case "btn_cancel": {
                if (this.getModel().getDataChanged()) {
                    String number = this.getModel().getValue("number").toString();
                    DynamicObject interviewerLevel = InterviewerQueryHelper.getIntvLevelByNum((String)number);
                    if (interviewerLevel != null) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CANCEL_CALLBACK, (IFormPlugin)this);
                        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
                        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
                        MessageBoxOptions options = MessageBoxOptions.OKCancel;
                        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
                        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                        this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
                        break;
                    }
                    this.getView().close();
                    break;
                }
                this.setPageStatus(Boolean.FALSE);
                String interviewerLevel = this.getModel().getValue("intverlevel").toString();
                if (!"".equals(interviewerLevel)) break;
                this.getView().close();
                break;
            }
            case "btn_save": {
                this.btnSave();
                break;
            }
            case "openap": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"openap", "basicinfoflex", "otherinfoflex", "rankrangeconfiguration"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"closeap"});
                this.getView().getPageCache().put(OPENORCLOSE, "close");
                break;
            }
            case "closeap": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"openap", "basicinfoflex", "otherinfoflex", "rankrangeconfiguration"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"closeap"});
                this.getView().getPageCache().put(OPENORCLOSE, OPEN);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String resultValue = messageBoxClosedEvent.getResultValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"Yes", (CharSequence)resultValue) && StringUtils.equals((CharSequence)BTN_CANCEL_CALLBACK, (CharSequence)callBackId)) {
            this.getView().invokeOperation("refresh");
            this.setPageStatus(Boolean.FALSE);
        }
    }

    public void generateOneCodeRule(String numberKey, String entityId, DynamicObject dynamicObject) {
        if (HRStringUtils.isEmpty((String)entityId)) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)numberKey)) {
            return;
        }
        String number = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)entityId), null);
        if (HRStringUtils.isEmpty((String)number)) {
            return;
        }
        dynamicObject.set(numberKey, (Object)number);
    }

    private void btnSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String intvLevelNum = dataEntity.getString("number");
        DynamicObject intverLevel = InterviewerQueryHelper.getIntvLevelByNum((String)intvLevelNum);
        String isnewpage = this.getView().getPageCache().get(ISNEWPAGE);
        if (intverLevel == null && isnewpage == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5", (String)"IntverLevelDetailsPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject intvLevel = InterviewerQueryHelper.getIntvLevelByTypeAndLevel((DynamicObject)dataEntity.getDynamicObject("interviewertype"), (String)dataEntity.getString("intverlevel"));
        this.getModel().setValue("status", (Object)"C");
        if (intvLevel == null || dataEntity.getLong("id") == intvLevel.getLong("id")) {
            DynamicObjectCollection rankrangeentry;
            DynamicObject intvType = dataEntity.getDynamicObject("interviewertype");
            Boolean isContains = new InterviewerLevelPlugin().MECheck(intvType, rankrangeentry = this.getModel().getEntryEntity("rankrangeentry"));
            if (!isContains.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"InterviewerLevelPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation(SAVELEVEL);
            this.setPageStatus(Boolean.FALSE);
            this.getView().invokeOperation("refresh");
            String openorclose = this.getView().getPageCache().get(OPENORCLOSE);
            if (openorclose != null && openorclose.equals("close")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"closeap"});
            }
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \uff1a\u201c %s \u201d\u5df2\u5b58\u5728", (String)"IntverLevelDetailsPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), dataEntity.getString("number"), dataEntity.getString("intverlevel")));
        }
        this.getView().getPageCache().remove(ISNEWPAGE);
    }
}

