/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviewer;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerFamilyScmHelper;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerPermHelper;
import kd.tsc.tsrbd.business.domain.interviewer.service.InterviewerQueryHelper;
import org.apache.commons.lang3.StringUtils;

public class IntverTypeDetailsPlugin
extends AbstractBillPlugIn {
    public static final String INTVLEVELFLEX = "intvlevelflex";
    public static final String ADDINTVLEVEL = "addintvlevel";
    public static final String TYPE_EDIT = "type_edit";
    public static final String TYPE_SAVE = "type_save";
    public static final String TYPE_CANCEL = "type_cancel";
    public static final String TYPE_CANCEL_CALLBACK = "typeCancel";
    public static final String CLOSE_PAGE = "close_page";
    public static int clickCounts = 0;
    public static final String[] UN_CHANGED_PROPS = new String[]{"joblevelscm", "rankrange"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDINTVLEVEL});
        Toolbar typeButton = (Toolbar)this.getView().getControl("typetoolbarap");
        typeButton.addItemClickListener((ItemClickListener)this);
        Toolbar familyButton = (Toolbar)this.getView().getControl("familytoolbarap");
        Toolbar classButton = (Toolbar)this.getView().getControl("classtoolbarap");
        familyButton.addItemClickListener((ItemClickListener)this);
        classButton.addItemClickListener((ItemClickListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String unChangedProp : UN_CHANGED_PROPS) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "type_edit": {
                this.setPageStatus(Boolean.TRUE);
                break;
            }
            case "type_save": {
                OperationResult operationResult = this.getView().invokeOperation("save");
                if (!operationResult.isSuccess()) break;
                this.setPageStatus(Boolean.FALSE);
                DynamicObject intvType = InterviewerQueryHelper.typeServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getLong("id"));
                this.executeOperate(intvType);
                String close_page = this.getView().getPageCache().get(CLOSE_PAGE);
                if (close_page != null) {
                    this.CloseIntvLevel(close_page);
                }
                this.getView().getPageCache().remove(CLOSE_PAGE);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "type_cancel": {
                if (this.getModel().getDataChanged()) {
                    HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
                    this.PWindow(TYPE_CANCEL_CALLBACK, btnNameMaps, msg);
                    break;
                }
                this.setPageStatus(Boolean.FALSE);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        List<DynamicObject> intvLevelsList = this.getAllIntvLevel();
        Container intvlevelflex = (Container)this.getControl(INTVLEVELFLEX);
        BillShowParameter intvLevelBillShowParameter = IntverTypeDetailsPlugin.setFlexBillShow(intvlevelflex, intvlevelflex.getKey().concat(String.valueOf(intvLevelsList.size() + clickCounts)), "tsrbd_intverlevel_details");
        ++clickCounts;
        intvLevelBillShowParameter.setCustomParam("interviewerTypeId", (Object)this.getModel().getDataEntity().getLong("id"));
        this.getView().showForm((FormShowParameter)intvLevelBillShowParameter);
        String close_page = this.getView().getPageCache().get(CLOSE_PAGE);
        close_page = close_page == null ? intvLevelBillShowParameter.getPageId() : close_page + "," + intvLevelBillShowParameter.getPageId();
        this.getView().getPageCache().put(CLOSE_PAGE, close_page);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String resultValue = messageBoxClosedEvent.getResultValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"Yes", (CharSequence)resultValue) && StringUtils.equals((CharSequence)TYPE_CANCEL_CALLBACK, (CharSequence)callBackId)) {
            this.getView().invokeOperation("refresh");
            this.setPageStatus(Boolean.FALSE);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscmhr");
        List<DynamicObject> intvLevelsList = this.getAllIntvLevel();
        this.setIntvLevelInfoForm(intvLevelsList, jobScm);
        this.fillJobFamilyAndClass();
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        this.setPageStatus(Boolean.FALSE);
        boolean modify = InterviewerPermHelper.getInstance().verifyHasIntvTypePerm("modify");
        if (!modify) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TYPE_EDIT});
        }
    }

    public List<DynamicObject> getAllIntvLevel() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long interviewertypeId = dataEntity.getLong("id");
        DynamicObject[] intvLevels = InterviewerQueryHelper.getAllIntvLevelByIntvTypeId((Long)interviewertypeId);
        return Arrays.asList(intvLevels);
    }

    public void setIntvLevelInfoForm(List<DynamicObject> intvLevelsList, DynamicObject jobScm) {
        Container intvlevelflex = (Container)this.getControl(INTVLEVELFLEX);
        for (int num = 0; num < intvLevelsList.size(); ++num) {
            BillShowParameter intvLevelBillShowParameter = IntverTypeDetailsPlugin.setFlexBillShow(intvlevelflex, intvlevelflex.getKey().concat(String.valueOf(num)), "tsrbd_intverlevel_details");
            intvLevelBillShowParameter.setCustomParam("jobscmhr", (Object)jobScm);
            intvLevelBillShowParameter.setPkId((Object)intvLevelsList.get(num).getLong("id"));
            this.getView().showForm((FormShowParameter)intvLevelBillShowParameter);
        }
    }

    public static BillShowParameter setFlexBillShow(Container flexPanel, String flexKey, String formId) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.getOpenStyle().setTargetKey(flex.getKey());
        return billShowParameter;
    }

    public void fillJobFamilyAndClass() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscmhr");
        Long intvtypeId = dataEntity.getLong("id");
        DynamicObject intvType = InterviewerQueryHelper.getInterviewerTypeById((Long)intvtypeId);
        DynamicObjectCollection jobFamilies = intvType.getDynamicObjectCollection("jobfamilyhrentry");
        for (int num = 0; num < jobFamilies.size(); ++num) {
            DynamicObject jobLevel = InterviewerFamilyScmHelper.getJobLevel((DynamicObject)jobScm, (DynamicObject)((DynamicObject)jobFamilies.get(num)).getDynamicObject("jobfamilyhr"));
            if (jobLevel == null) continue;
            this.getModel().setValue("joblevelscm", (Object)jobLevel.getString("name"), num);
        }
        DynamicObjectCollection jobClasses = intvType.getDynamicObjectCollection("jobclasshrentry");
        for (int num = 0; num < jobClasses.size(); ++num) {
            Map jobLevelRange = InterviewerFamilyScmHelper.getJobLevelRange((DynamicObject)jobScm, (DynamicObject)((DynamicObject)jobClasses.get(num)).getDynamicObject("jobclasshr"));
            DynamicObject lowjoblevel = (DynamicObject)jobLevelRange.get("lowjoblevel");
            DynamicObject highjoblevel = (DynamicObject)jobLevelRange.get("highjoblevel");
            if (lowjoblevel == null || highjoblevel == null) continue;
            this.getModel().setValue("rankrange", (Object)(lowjoblevel.getString("name") + "-" + highjoblevel.getString("name")), num);
        }
    }

    public void setPageStatus(Boolean isEditable) {
        this.getView().setEnable(isEditable, new String[]{"bizname", "bizdescription", "applyqual", "jobscmhr"});
        this.getView().setVisible(isEditable, new String[]{"familytoolbarap", "classtoolbarap"});
        this.getView().setVisible(isEditable, new String[]{TYPE_SAVE, TYPE_CANCEL});
        this.getView().setVisible(Boolean.valueOf(isEditable == false), new String[]{TYPE_EDIT});
    }

    public void CloseIntvLevel(String close_page) {
        String[] close_pages;
        for (String closePage : close_pages = close_page.split(",")) {
            IFormView subView;
            if (!StringUtils.isNotBlank((CharSequence)closePage) || (subView = this.getView().getView(closePage)) == null) continue;
            this.getView().getView(closePage).close();
            this.getView().sendFormAction(subView);
        }
    }

    public void PWindow(String callBackStr, Map<Integer, String> btnNameMaps, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackStr, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void executeOperate(DynamicObject intvType) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreValidation", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"save", (String)"tsrbd_intvertype", (DynamicObject[])new DynamicObject[]{intvType}, (OperateOption)options);
    }
}

