/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviews;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.home.HomePageService;
import kd.tsc.tsrbd.business.domain.interviewer.calendar.AbleInterviewTimeService;
import kd.tsc.tsrbd.common.enums.InterviewTimeWayEnum;
import kd.tsc.tsrbd.common.enums.RecruitType;

public class IntvTaskCaleCardPlugin
extends AbstractFormPlugin {
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final HomePageService homePageService = HomePageService.Singleton.INSTANCE.getInstance();
    public static final Log log = LogFactory.getLog(IntvTaskCaleCardPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (eventName.contains("get")) {
            this.getIntvTaskDataToCustom(eventArgs, eventName);
        } else if (HRStringUtils.equals((String)"turnToTaskList", (String)eventName)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("intv_task_id", Long.valueOf(eventArgs));
            this.openTsrbsIntvEvalTaskView(param);
        }
    }

    private void openTsrbsIntvEvalTaskView(Map<String, Object> intvEvalCustomParamMap) {
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("tsrbd_intvevlbilllist");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setCustomParams(intvEvalCustomParamMap);
        this.getView().showForm(baseShowParameter);
    }

    private HashMap<String, Long> transJsonToMap(String args) {
        try {
            return (HashMap)HRJSONUtils.cast((String)args, HashMap.class, (Class[])new Class[]{String.class, Long.class});
        }
        catch (IOException e) {
            log.error("parse IntvTaskCaleCardPlugin json error ", (Throwable)e);
            return null;
        }
    }

    private void getIntvTaskDataToCustom(String eventArgs, String eventName) {
        HashMap<String, Long> customParam = this.transJsonToMap(eventArgs);
        if (customParam == null) {
            return;
        }
        switch (eventName) {
            case "getDayData": {
                List taskList = homePageService.getIntvCalendarLists(new Date(customParam.get(START_TIME)), new Date(customParam.get(END_TIME)), RecruitType.INNER_RECRUIT);
                this.setCustomData("setDayData", this.transObjectToJson(taskList));
                break;
            }
            case "getWeekData": {
                List taskList = homePageService.getIntvCalendarLists(new Date(customParam.get(START_TIME)), new Date(customParam.get(END_TIME)), RecruitType.INNER_RECRUIT);
                this.setCustomData("setWeekData", this.transObjectToJson(taskList));
                break;
            }
            case "getMonthData": {
                List taskList = homePageService.getIntvCalendarLists(new Date(customParam.get(START_TIME)), new Date(customParam.get(END_TIME)), RecruitType.INNER_RECRUIT);
                this.setCustomData("setMonthData", this.transObjectToJson(taskList));
                break;
            }
        }
    }

    private String transObjectToJson(Object obj) {
        try {
            return HRJSONUtils.toString((Object)obj);
        }
        catch (IOException e) {
            log.error("parse IntvTaskCaleCardPlugin json error ", (Throwable)e);
            return "";
        }
    }

    private void setCustomData(String key, String value) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)1);
        customParam.put(key, HRStringUtils.isEmpty((String)value) ? "[]" : value);
        customParam.put("refresh", String.valueOf(new SecureRandom().nextInt()));
        customcontrol.setData((Object)customParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_settime"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (HRStringUtils.equals((String)key, (String)"btn_settime")) {
            AbleInterviewTimeService.openSetInterviewTimePage((IFormView)this.getView(), (String)"tsirm_intvcalendar", (InterviewTimeWayEnum)InterviewTimeWayEnum.ENTRANCE_HOMPAGE, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callback_setIntvTime"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("callback_setIntvTime".equals(closedCallBackEvent.getActionId()) && "success".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9762\u8bd5\u65f6\u95f4\u6210\u529f", (String)"IntvTaskCaleCardPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        }
    }
}

