/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviews;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.home.HomePageService;
import kd.tsc.tsrbd.common.enums.RecruitType;

public class OverviewDataPlugin
extends AbstractFormPlugin {
    private static final String WAITRESUMEFILTERNUM = "waitresumefilternum";
    private static final String WAITINTERVIEWNUM = "waitinterviewnum";
    private static final String WAITEVALUATENUM = "waitevaluatenum";
    HomePageService homePageService = HomePageService.Singleton.INSTANCE.getInstance();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{WAITRESUMEFILTERNUM, WAITINTERVIEWNUM, WAITEVALUATENUM, "refresh"});
    }

    public void afterCreateNewData(EventObject evt) {
        this.setPageDateValue();
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.equals((String)"refreshFromGridContainer", (String)evt.getKey())) {
            this.setPageDateValue();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        String pageKey = null;
        switch (key) {
            case "waitresumefilternum": {
                pageKey = "tsrbd_resumefilterlist";
                paramMap.put("isHomeFlag", Boolean.TRUE);
                break;
            }
            case "waitinterviewnum": {
                pageKey = "tsrbd_intvevlbilllist";
                paramMap.put("is_homepage", Boolean.TRUE);
                paramMap.put("intv_date_code", "108");
                break;
            }
            case "waitevaluatenum": {
                pageKey = "tsrbd_intvevlbilllist";
                paramMap.put("is_homepage", Boolean.TRUE);
                break;
            }
            case "refresh": {
                this.setPageDateValue();
                break;
            }
        }
        this.showFormDataList(pageKey, paramMap);
    }

    public void setPageDateValue() {
        Map resumeFilterDataCount = this.homePageService.getResumeFilterDataCount(RecruitType.INNER_RECRUIT);
        Long pendingProcessing = (Long)resumeFilterDataCount.get("pendingProcessing");
        OverviewDataPlugin.setHomeLabelValue(this.getView(), WAITRESUMEFILTERNUM, pendingProcessing == null ? 0L : pendingProcessing);
        Map intverviewMap = this.homePageService.getIntverviewMap(RecruitType.INNER_RECRUIT);
        Long tobeinterviewed = (Long)intverviewMap.get("tobeinterviewed");
        OverviewDataPlugin.setHomeLabelValue(this.getView(), WAITINTERVIEWNUM, tobeinterviewed == null ? 0L : tobeinterviewed);
        Long tobeadvanced = (Long)intverviewMap.get("tobeadvanced");
        OverviewDataPlugin.setHomeLabelValue(this.getView(), WAITEVALUATENUM, tobeadvanced == null ? 0L : tobeadvanced);
    }

    public static void setHomeLabelValue(IFormView view, String labelName, long num) {
        Label label = (Label)view.getControl(labelName);
        label.setText(String.valueOf(num));
        HashMap<String, String> map = new HashMap<String, String>(3);
        if (num == 0L) {
            map.put("fc", "#BBB");
        } else {
            map.put("fc", "#5582F3");
        }
        view.updateControlMetadata(labelName, map);
    }

    private void showFormDataList(String pageKey, Map<String, Object> params) {
        if (StringUtils.isEmpty((String)pageKey)) {
            return;
        }
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId(pageKey);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (params != null && params.size() > 0) {
            baseShowParameter.setCustomParams(params);
        }
        this.getView().showForm(baseShowParameter);
    }
}

