/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviews;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.home.HomePageService;
import kd.tsc.tsrbd.business.domain.workaddress.service.HbssAddressDetailDataHelper;
import kd.tsc.tsrbd.common.constants.intv.model.IntvArTimeBean;
import kd.tsc.tsrbd.common.enums.RecruitType;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class TodayIntvCardPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(TodayIntvCardPlugin.class);
    private static final String DAYDATEENTRY = "entryentity";
    private static final Map<String, String> statusMap = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<String, String> resultMap = Maps.newHashMapWithExpectedSize((int)3);
    public static final String HANDLE_STATUS_PENDING = "A";
    public static final String HANDLE_STATUS_FINISH = "B";
    private static final HomePageService homePageService = HomePageService.Singleton.INSTANCE.getInstance();
    private static final String KEY_INTV_TASK_EVL_NUM_LABEL = "labelap2";
    private static final String KEY_INTV_EVL_CARD_ENTRY = "cardentryflexpanelap5";
    private static final String KEY_ENTRY_CURRENT_ROW_INDEX = "entryentity";
    private static final String PAGE_CACHE_KEY_INTVEVALCUSTOMPARAMMAPS = "intvEvalCustomParamMaps";
    public static final String KEY_CANDIDATENAME = "candidatename";
    private static final Map<String, Consumer> clickEventMap;

    public TodayIntvCardPlugin() {
        clickEventMap.put(KEY_INTV_TASK_EVL_NUM_LABEL, evt -> this.openTsrbsIntvTaskListView());
        clickEventMap.put(KEY_INTV_EVL_CARD_ENTRY, evt -> this.openTsrbsIntvEvalTaskView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container flexIntv = (Container)this.getControl(KEY_INTV_EVL_CARD_ENTRY);
        flexIntv.addClickListener((ClickListener)this);
        Label label = (Label)this.getView().getControl(KEY_INTV_TASK_EVL_NUM_LABEL);
        label.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getTodayIntvData();
    }

    private void getTodayIntvData() {
        DynamicObject[] dynamicObjects = homePageService.listTodayInterviewEvl(RecruitType.INNER_RECRUIT);
        ArrayList<IntvArTimeBean> arTimeBeans = new ArrayList<IntvArTimeBean>(dynamicObjects.length);
        ArrayList<HashMap> intvEvalCustomParamMaps = new ArrayList<HashMap>(dynamicObjects.length);
        for (DynamicObject evaluate : dynamicObjects) {
            String interviewStatus = evaluate.getString("interviewstatus");
            String handleStatus = evaluate.getString("handlestatus");
            String intvevlrslt = evaluate.getString("intvevlrslt");
            String candidateName = "";
            String position = "";
            Long applicationId = null;
            Long resumeId = null;
            String methodName = evaluate.getString("round.interviewmethod.name");
            DynamicObject group = evaluate.getDynamicObject("intvgroup");
            int startTime = group.getInt("intvstarttime");
            DynamicObject addressDetail = group.getDynamicObject("addressdetail");
            String room = group.getString("interviewroom");
            String intverveIoAddress = group.getString("intvervedioaddress");
            DynamicObject application = evaluate.getDynamicObject("application");
            if (null != application) {
                position = application.getString("position.name");
                applicationId = application.getLong("id");
                candidateName = application.getString("name");
                resumeId = application.getLong("appres.id");
            }
            DynamicObject argintvObj = evaluate.getDynamicObject("argintv");
            IntvArTimeBean intvArTimeBean = new IntvArTimeBean();
            intvArTimeBean.setIntvTime(DateUtils.secondToTime((int)startTime).substring(0, 5));
            intvArTimeBean.setIntvEvlRslt(intvevlrslt);
            intvArTimeBean.setEvaluateStatus(interviewStatus);
            intvArTimeBean.setHandlestatus(handleStatus);
            if (!Objects.isNull(addressDetail)) {
                if (!(addressDetail.containsProperty("country") && addressDetail.containsProperty("city") && addressDetail.containsProperty("detailaddr"))) {
                    addressDetail = HbssAddressDetailDataHelper.getInstance().loadSingle((Object)addressDetail.getLong("id"));
                }
                String country = addressDetail.getString("country.name");
                String city = addressDetail.getString("city.name");
                String detailaddr = addressDetail.getString("detailaddr.name");
                intvArTimeBean.setLocation(country + city + detailaddr);
            }
            intvArTimeBean.setRoom(room);
            intvArTimeBean.setCandidateName(candidateName);
            intvArTimeBean.setPosition(position);
            intvArTimeBean.setIntvMethod(methodName);
            intvArTimeBean.setIntverveIoAddress(intverveIoAddress);
            arTimeBeans.add(intvArTimeBean);
            DynamicObject intvtaskObj = evaluate.getDynamicObject("intvtask");
            HashMap intvEvalCustomParamMap = Maps.newHashMapWithExpectedSize((int)2);
            intvEvalCustomParamMap.put("resume_id", resumeId);
            intvEvalCustomParamMap.put("app_id", applicationId);
            intvEvalCustomParamMap.put(KEY_CANDIDATENAME, candidateName);
            intvEvalCustomParamMap.put("key_argintv_id", argintvObj.getPkValue());
            intvEvalCustomParamMap.put("intvTaskId", intvtaskObj.getPkValue());
            intvEvalCustomParamMap.put("interviewers", intvtaskObj.get("interviewer_id"));
            intvEvalCustomParamMaps.add(intvEvalCustomParamMap);
        }
        this.getPageCache().put(PAGE_CACHE_KEY_INTVEVALCUSTOMPARAMMAPS, JSON.toJSONString(intvEvalCustomParamMaps));
        this.setDateForEntry(arTimeBeans);
    }

    private void setDateForEntry(List<IntvArTimeBean> entryDates) {
        this.getModel().deleteEntryData("entryentity");
        int count = entryDates.size();
        if (count > 0) {
            Label label = (Label)this.getView().getControl(KEY_INTV_TASK_EVL_NUM_LABEL);
            label.setText(String.valueOf(count));
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", count);
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            for (int i = 0; i < count; ++i) {
                String[] region;
                String location = entryDates.get(i).getLocation();
                if (!StringUtils.isEmpty((String)entryDates.get(i).getRoom())) {
                    location = location + "(" + entryDates.get(i).getRoom() + ")";
                }
                this.getModel().setValue("textfield", (Object)entryDates.get(i).getIntvTime(), rowIndex[i]);
                this.getModel().setValue("intvplace", (Object)location, rowIndex[i]);
                this.getModel().setValue("textfield2", (Object)entryDates.get(i).getCandidateName(), rowIndex[i]);
                this.getModel().setValue("textfield3", (Object)entryDates.get(i).getPosition(), rowIndex[i]);
                this.getModel().setValue("intvmethod", (Object)entryDates.get(i).getIntvMethod(), rowIndex[i]);
                if ((HRStringUtils.equals((String)entryDates.get(i).getEvaluateStatus(), (String)HANDLE_STATUS_FINISH) || HRStringUtils.equals((String)entryDates.get(i).getEvaluateStatus(), (String)"C")) && HRStringUtils.equals((String)entryDates.get(i).getHandlestatus(), (String)HANDLE_STATUS_FINISH)) {
                    String intvResult = resultMap.get(entryDates.get(i).getIntvEvlRslt());
                    if (HRStringUtils.isBlank((CharSequence)intvResult)) {
                        intvResult = statusMap.get(entryDates.get(i).getEvaluateStatus());
                    }
                    region = HRStringUtils.isNotEmpty((String)intvResult) ? intvResult.split("-") : new String[]{};
                    cardEntry.setChildVisible(false, rowIndex[i], new String[]{"cardentryflexpanelap9"});
                } else {
                    region = statusMap.get(entryDates.get(i).getEvaluateStatus()).split("-");
                    cardEntry.setChildVisible(false, rowIndex[i], new String[]{"vectorap1"});
                }
                if (region.length > 0) {
                    this.getModel().setValue("textfield5", (Object)region[0], rowIndex[i]);
                }
                if (i != count - 1) continue;
                cardEntry.setChildVisible(false, rowIndex[i], new String[]{"labelap1"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        Consumer consumer = clickEventMap.get(source.getKey());
        if (null == consumer) {
            return;
        }
        consumer.accept(evt);
    }

    private void openTsrbsIntvTaskListView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_intvevlbilllist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(10);
        customParamMap.put("is_homepage", Boolean.TRUE);
        customParamMap.put("intv_date_code", "13");
        ArrayList<String> handleStatus = new ArrayList<String>();
        handleStatus.add(HANDLE_STATUS_PENDING);
        handleStatus.add(HANDLE_STATUS_FINISH);
        customParamMap.put("handle_status", handleStatus);
        LOG.info("TodayIntvCardPlugin.openTsrbsIntvTaskListView customParamMap : {}", customParamMap);
        showParameter.setCustomParams(customParamMap);
        this.getView().showForm(showParameter);
    }

    private void openTsrbsIntvEvalTaskView() {
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String intvEvalCustomParamMaps = this.getPageCache().get(PAGE_CACHE_KEY_INTVEVALCUSTOMPARAMMAPS);
        List intvEvalCustomParamMapList = (List)JSON.parse((String)intvEvalCustomParamMaps);
        Map evalCustomParamMap = (Map)intvEvalCustomParamMapList.get(currentIndex);
        LOG.info("TodayIntvCardPlugin.openTsrbsIntvEvalTaskView evalCustomParamMap : {}", (Object)evalCustomParamMap);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_intvevaltaskir");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(evalCustomParamMap);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7-%s", (String)"TodayIntvCardPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), (String)evalCustomParamMap.get(KEY_CANDIDATENAME)));
        this.getView().showForm(showParameter);
    }

    static {
        statusMap.put(HANDLE_STATUS_PENDING, "\u672a\u8bc4\u4ef7-#F5A623");
        statusMap.put(HANDLE_STATUS_FINISH, "\u5df2\u8bc4\u4ef7-#999999");
        statusMap.put("C", "\u5df2\u4ee3\u8bc4-#999999");
        statusMap.put("D", "\u5df2\u53d6\u6d88-#666666");
        resultMap.put(HANDLE_STATUS_PENDING, "\u901a\u8fc7-#26B175");
        resultMap.put(HANDLE_STATUS_FINISH, "\u4e0d\u901a\u8fc7-#FD6C6A");
        resultMap.put("C", "\u5f85\u5b9a-#666666");
        clickEventMap = new HashMap<String, Consumer>();
    }
}

