/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.interviews;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.home.HomePageService;
import kd.tsc.tsrbd.common.enums.RecruitType;

public class TsivpHomePagePlugin
extends GridContainerPlugin {
    private static final Log LOGGER = LogFactory.getLog(TsivpHomePagePlugin.class);
    HomePageService homePageService = HomePageService.Singleton.INSTANCE.getInstance();
    private static final Long HAS_INTERVIEWER_USERID = 33333333333333L;
    private static final Long NO_INTERVIEWER_USERID = 33333333333333L;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long schemeId = this.homePageService.getInterviewCheckCondition(RecruitType.INNER_RECRUIT) ? HAS_INTERVIEWER_USERID : NO_INTERVIEWER_USERID;
        LOGGER.info("TsivpHomePagePlugin.afterBindData schemeId : {}", (Object)schemeId);
        this.getView().getPageCache().put("mainpage_schemeId", String.valueOf(schemeId));
        DynamicObject schemeObj = this.getCurUserSuitableScheme(schemeId);
        LOGGER.info("TsivpHomePagePlugin.afterBindData schemeObj : {}", (Object)schemeObj);
        this.refreshGridContainer(schemeObj);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object retDataObj = e.getReturnData();
        String actionId = e.getActionId();
        if (actionId.equals("CallBack_showAddCardForm")) {
            if (retDataObj == null) {
                return;
            }
            List<Map<String, Object>> list = new ArrayList<Map<String, Object>>(20);
            if (retDataObj instanceof Map) {
                Object rtnCardIndex = ((Map)retDataObj).get("event_rtn_addcard");
                if (rtnCardIndex != null) {
                    String cardTypeIndex = (String)rtnCardIndex;
                    this.showNewCardTypeForm(cardTypeIndex);
                    return;
                }
                Object cardTypeObj = ((Map)retDataObj).get("cardType");
                if ("bos_card_custom_config".equals(cardTypeObj)) {
                    ((Map)retDataObj).put("cardType", "tsrbd_card_custom_config");
                }
                list.add((Map)retDataObj);
            } else if (retDataObj instanceof List) {
                list = (List)retDataObj;
            }
            this.showNewAddCardForm(list);
        } else if (actionId.equals("CallBack_getScheme") && retDataObj instanceof ListSelectedRowCollection) {
            Long schemeId = Long.parseLong(((ListSelectedRowCollection)retDataObj).getPrimaryKeyValues()[0].toString());
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme");
            this.refreshGridContainer(schemeObj);
        }
    }

    private void showNewAddCardForm(List<Map<String, Object>> pListReturnMap) {
        ArrayList fspList = new ArrayList();
        ArrayList cardInfoMaps = new ArrayList();
        HashMap newCardIdPageIdMap = new HashMap(16);
        pListReturnMap.forEach(map -> this.showNewAddCardForm(fspList, (Map<String, Object>)map, cardInfoMaps, newCardIdPageIdMap));
        this.updateCardPageMap(newCardIdPageIdMap);
        GridContainer gc = (GridContainer)this.getView().getControl("gridcontainerap");
        gc.addCards(cardInfoMaps);
        fspList.forEach(fsp -> this.getView().showForm(fsp));
    }

    private void showNewAddCardForm(List<FormShowParameter> fspList, Map<String, Object> pReturnMap, List<Map<String, Object>> cardInfoMaps, Map<String, String> newCardIdPageIdMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (!StringUtils.isEmpty((String)cardType)) {
            FormShowParameter fsp = new FormShowParameter();
            this.setFormId(fsp, pReturnMap);
            String cardId = this.setShowType(fsp, cardType, null, true);
            this.setCustomParam(fsp, cardType, pReturnMap);
            if (StringUtils.isNotEmpty((String)cardId)) {
                Map allCardConfigMap = this.getAllCardConfigMap();
                allCardConfigMap.put(cardId, SerializationUtils.toJsonString(pReturnMap));
                this.setAllCardConfigCache(allCardConfigMap);
                HashMap config = new HashMap(16);
                if (this.getPageCache().get("layout") != null) {
                    String layout = this.getPageCache().get("layout");
                    int cols = this.getGridCols();
                    config = CardUtils.getLayoutForNewCard((String)layout, (int)4, (int)1, (int)cols);
                    JSONArray jsonArr = JSONArray.parseArray((String)layout);
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("w", config.get("w"));
                    jsonObj.put("h", config.get("h"));
                    jsonObj.put("x", config.get("x"));
                    jsonObj.put("y", config.get("y"));
                    jsonObj.put("i", (Object)cardId);
                    jsonObj.put("moved", (Object)Boolean.FALSE);
                    jsonObj.put("static", (Object)Boolean.FALSE);
                    jsonArr.add((Object)jsonObj);
                    String newLayout = jsonArr.toJSONString();
                    this.getPageCache().put("layout", newLayout);
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("formId", "");
                dataMap.put("cardId", cardId);
                dataMap.put("config", config);
                cardInfoMaps.add(dataMap);
                newCardIdPageIdMap.put(cardId, fsp.getPageId());
            }
            fspList.add(fsp);
        }
    }

    private void setCustomParam(FormShowParameter fsp, String cardType, Map<String, Object> pReturnMap) {
        Object isFreshClick = this.getView().getFormShowParameter().getCustomParam("isFreshClick");
        boolean isFreshClickFlag = false;
        if (isFreshClick != null && Boolean.parseBoolean(isFreshClick.toString())) {
            isFreshClickFlag = true;
        }
        switch (cardType) {
            case "bos_card_quicklaunch": {
                fsp.getOpenStyle().getCustParam().put("cardRefresh", "false");
                break;
            }
            case "bos_card_billstats": {
                fsp.setCustomParam("isFreshClick", (Object)isFreshClickFlag);
                break;
            }
            case "bos_card_billstats_list": {
                fsp.setCustomParam("isFreshClick", (Object)isFreshClickFlag);
            }
        }
    }

    private void setAllCardConfigCache(Map<String, String> allCardConfigMap) {
        String jsonStr = SerializationUtils.toJsonString(allCardConfigMap);
        this.getPageCache().put("cache_allCardConfig", jsonStr);
    }

    private int getGridCols() {
        String defaultGridCols = "12";
        String formId = this.getView().getFormShowParameter().getFormId();
        String cols = this.getPageCache().get(formId + "_gridcontainerap_cols");
        if (StringUtils.isEmpty((String)cols)) {
            try {
                MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
                String meta = metadataService.loadClientFormMeta(formId);
                Map<String, Object> data = this.getGridRuntimeMeta("gridcontainerap", (Map)SerializationUtils.fromJsonString((String)meta, Map.class));
                cols = data != null ? data.get("cols").toString() : defaultGridCols;
            }
            catch (Exception var7) {
                cols = defaultGridCols;
            }
            this.getPageCache().put(formId + "_gridcontainerap_cols", cols);
        }
        return Integer.parseInt(cols);
    }

    private Map<String, Object> getGridRuntimeMeta(String gridId, Map<String, Object> meta) {
        List items;
        if (meta != null && meta.containsKey("items") && meta.get("items") instanceof List && (items = (List)meta.get("items")) != null && !items.isEmpty()) {
            for (Map item : items) {
                if (item.containsKey("id") && item.containsKey("cols") && Objects.equals(gridId, item.get("id"))) {
                    return item;
                }
                Map<String, Object> metadata = this.getGridRuntimeMeta(gridId, item);
                if (metadata == null) continue;
                return metadata;
            }
        }
        return null;
    }

    private void setFormId(FormShowParameter fsp, Map<String, Object> pReturnMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (cardType.equals("bos_card_custom")) {
            String formNum = (String)pReturnMap.get("cardformnum");
            fsp.setFormId(formNum);
        } else {
            fsp.setFormId(cardType);
        }
    }

    private String setShowType(FormShowParameter fsp, String cardType, String pNewCardIndex, boolean ifDesignMode) {
        HashMap custParam = fsp.getOpenStyle().getCustParam();
        if (custParam == null) {
            custParam = new HashMap(16);
            fsp.getOpenStyle().setCustParam(custParam);
        }
        String strNewCardIndex = pNewCardIndex;
        switch (cardType) {
            case "bos_card_billstatsconfig": 
            case "bos_card_workflowconfig": 
            case "bos_card_qingconfig": 
            case "tsrbd_card_custom_config": 
            case "bos_card_yzjconifg": {
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "CallBack_showAddCardForm"));
                break;
            }
            case "bos_card_usercenterconfig": {
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "CallBack_showAddCardForm"));
                break;
            }
            case "bos_card_custom": 
            case "bos_card_quicklaunch": 
            case "bos_card_billstats": 
            case "bos_card_billstats_list": 
            case "bos_card_workflow": 
            case "bos_card_msgcenter": 
            case "bos_card_qing": 
            case "bos_card_yzj_subscribe": 
            case "bos_card_usercenter": {
                fsp.getOpenStyle().setShowType(ShowType.InContainer);
                if (pNewCardIndex == null) {
                    strNewCardIndex = this.getNewCardIndex();
                }
                fsp.getOpenStyle().setTargetKey("gridcontainerap");
                fsp.getOpenStyle().getCustParam().put("cardId", strNewCardIndex);
                String strIfDesignMode = null;
                strIfDesignMode = ifDesignMode ? "1" : "0";
                fsp.getOpenStyle().getCustParam().put("ifDesignMode", strIfDesignMode);
            }
        }
        return strNewCardIndex;
    }

    private String getNewCardIndex() {
        long lNewCardId = ORM.create().genLongId("bos_mainpagecardconfig");
        String newCardId = String.valueOf(lNewCardId);
        return newCardId;
    }

    public void tabSelected(TabSelectEvent event) {
        if (event.getTabKey().equals("appmiantab")) {
            Long schemeId = this.homePageService.getInterviewCheckCondition(RecruitType.INNER_RECRUIT) ? HAS_INTERVIEWER_USERID : NO_INTERVIEWER_USERID;
            LOGGER.info("TsivpHomePagePlugin.tabSelected schemeId : {}", (Object)schemeId);
            String cacheId = this.getView().getPageCache().get("mainpage_schemeId");
            if (!HRStringUtils.equals((String)String.valueOf(schemeId), (String)cacheId)) {
                DynamicObject schemeObj = this.getScheme(schemeId);
                this.refreshGridContainer(schemeObj);
            }
        }
    }

    public DynamicObject getCurUserSuitableScheme(Long userId) {
        DynamicObject schemeObj = null;
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage((IFormView)this.getView());
        this.getPageCache().put("IS_MainPage_Type", Boolean.toString(isMainPage));
        String strSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((String)strSchemeId) && CardUtils.isHaveSchemeRecord((String)strSchemeId)) {
            return BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(strSchemeId), (String)"portal_scheme", (String)selFields);
        }
        String bizAppId = CardUtils.getAppIdFromView((IFormView)this.getView());
        String entityId = this.getView().getEntityId();
        String pageType = CardUtils.getPageType((IFormView)this.getView());
        Long defaultSchemeId = CardUtils.getDefaultSchemeId((String)pageType, (String)bizAppId, (String)entityId);
        if (defaultSchemeId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)defaultSchemeId, (String)"portal_scheme", (String)selFields);
        }
        boolean isMultiOrgMode = CardUtils.isMultiOrgMode();
        List<QFilter> isMultiOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
        List<QFilter> isSingleOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"0"));
        schemeObj = isMultiOrgMode ? CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isMultiOrgFilter, (boolean)isMainPage, (IFormView)this.getView()) : CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isSingleOrgFilter, (boolean)isMainPage, (IFormView)this.getView());
        return schemeObj;
    }

    public DynamicObject getScheme(Long userId) {
        DynamicObject schemeObj = null;
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage((IFormView)this.getView());
        boolean isMultiOrgMode = CardUtils.isMultiOrgMode();
        List<QFilter> isMultiOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
        List<QFilter> isSingleOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"0"));
        schemeObj = isMultiOrgMode ? CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isMultiOrgFilter, (boolean)isMainPage, (IFormView)this.getView()) : CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isSingleOrgFilter, (boolean)isMainPage, (IFormView)this.getView());
        return schemeObj;
    }
}

