/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.intv.questionnaire;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.hr.hbp.business.servicehelper.HRPermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.common.constants.intv.model.DimensionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionnaireCacheModel;
import kd.tsc.tsrbd.common.constants.intv.questionnaire.QuestionnaireConstants;

public abstract class AbstractIntvEvalQuestionnaire
extends HRCoreBaseBillEdit {
    private static final String CACHE_KEY_HEAD_BOX_ID = "headBoxId";
    private static final String CACHE_KEY_TAIL_BOX_ID = "tailBoxId";
    private static final String CTRL_QUESTION_FLEX = "questionflex";
    private static final String CTRL_ALL_INFO_FLEX = "allquestionnaireinfoflex";
    private static final String CTRL_LIST_BOX_AP = "listboxap";
    private static final String CTRL_COMPREHENSIVE_FLEX = "comprehensiveflex";
    private static final String KEY_VIEW = "VIEW";
    private static final String KEY_INTVEVLQUNR = "INTVEVLQUNR";
    private static final String TREE_PARENT_ID = "tree_parent_id";
    private static final String DEFAULT_CONTROLSTRANGE = "5";
    private static Boolean checkOrg;

    public void refresh(Long questionnaireId) {
        QuestionnaireCacheModel model = this.loadQuestionnaireCache(questionnaireId);
        List ids = this.loadInspectDimensionCache(questionnaireId);
        this.loadQuestionCache(ids.toArray());
        this.initPage(model);
    }

    private QuestionnaireCacheModel loadQuestionnaireCache(Long questionnaireId) {
        DynamicObject questionnaire;
        QuestionnaireCacheModel model = QuestionnaireCache.getCacheData((IFormView)this.getView());
        if (model == null) {
            model = new QuestionnaireCacheModel();
            model.setId(questionnaireId);
        }
        if ((questionnaire = QuestionnaireHelper.findQuestionnaireById((Object)questionnaireId)) != null) {
            model.setCreateOrg(Long.valueOf(questionnaire.getDynamicObject("createorg").getLong("id")));
            model.setCtrlStrategy(questionnaire.getString("ctrlstrategy"));
            model.setGroup(Long.valueOf(questionnaire.getDynamicObject("group").getLong("id")));
            model.setDescription(QuestionnaireCache.processLocaleStringToCacheModel((Object)questionnaire.get("description"), null));
            model.setName(QuestionnaireCache.processLocaleStringToCacheModel((Object)questionnaire.get("name"), null));
            model.setEvltype(questionnaire.getString("evltype"));
        }
        QuestionnaireCache.putCache((IFormView)this.getView(), (QuestionnaireCacheModel)model);
        return model;
    }

    private List loadInspectDimensionCache(Long questionnaireId) {
        ArrayList<Object> ids = new ArrayList<Object>();
        ArrayList<DimensionCacheModel> inspectDimension = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        if (inspectDimension != null) {
            return ids;
        }
        DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireOpById((Object)questionnaireId);
        if (questionnaire == null) {
            return ids;
        }
        DynamicObjectCollection inspects = questionnaire.getDynamicObjectCollection("inspectdimensionentry");
        if (inspects == null || inspects.isEmpty()) {
            return ids;
        }
        inspectDimension = new ArrayList<DimensionCacheModel>(inspects.size());
        for (DynamicObject inspect : inspects) {
            inspectDimension.add(QuestionnaireCache.processDyToInspectDimensionOpCacheModel((DynamicObject)inspect));
            ids.add(inspect.getPkValue());
        }
        QuestionnaireCache.putInspectDimension(inspectDimension, (IFormView)this.getView());
        return ids;
    }

    private void loadQuestionCache(Object[] pkArray) {
        DynamicObject[] inspectOps;
        for (DynamicObject inspect : inspectOps = QuestionnaireHelper.findInspectDimOpAllFieldByIds((Object[])pkArray)) {
            DynamicObjectCollection questions = inspect.getDynamicObjectCollection("questionentry");
            List models = QuestionCache.processDyToCacheModel((DynamicObjectCollection)questions);
            QuestionCache.putQuestionCache((List)models, (IFormView)this.getView(), (String)inspect.getString("id"));
        }
    }

    private boolean checkUsed(Long questionnaireId) {
        DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireById((Object)questionnaireId);
        if (Objects.isNull(questionnaire)) {
            return false;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.getCheckRefEntityIds().add("tsrbd_intvevlqunr");
        checker.setDraftValidReference(true);
        BaseDataCheckRefrenceResult baseDataCheckRefrenceResult = checker.checkRef((BasedataEntityType)questionnaire.getDataEntityType(), (Object)questionnaireId);
        return baseDataCheckRefrenceResult.isRefence();
    }

    private void initPage(QuestionnaireCacheModel model) {
        checkOrg = this.checkOrg(model);
        boolean isUsed = this.checkUsed(model.getId());
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (isUsed && !OperationStatus.VIEW.equals((Object)status)) {
            this.getView().showTipNotification("\u8be5\u9762\u8bd5\u8bc4\u4ef7\u8868\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
            checkOrg = Boolean.FALSE;
        }
        this.initBoxListData();
        this.setPropertyFields(model);
        this.initBoxListPageElement();
        if (((Boolean)this.getModel().getValue("issyspreset")).booleanValue() || !checkOrg.booleanValue()) {
            this.initPageBySystemPreferences();
        }
        this.initPageByModifyPermission();
    }

    private Boolean checkOrg(QuestionnaireCacheModel model) {
        boolean res = false;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (model.getCreateOrg() != null) {
            if (params.get("useorgId") != null && params.get("useorgId").equals(model.getCreateOrg().toString())) {
                res = true;
            }
        } else {
            res = true;
        }
        return res;
    }

    private void initPageByModifyPermission() {
        BillShowParameter bill = (BillShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.getValue() != bill.getStatus().getValue()) {
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean hasPermission = HRPermissionServiceHelper.hasPerm((long)userId, (String)"tsrbd_intvevlqunr", (String)"4715a0df000000ac");
        if (hasPermission) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{CTRL_ALL_INFO_FLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
    }

    private void setPropertyFields(QuestionnaireCacheModel model) {
        JSONObject json;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean isCopy = params.get("iscopy") != null && (Boolean)params.get("iscopy") != false;
        this.getModel().setValue("createorg", isCopy || model.getCreateOrg() == null ? params.get("useorgId") : model.getCreateOrg());
        Long group = model.getGroup();
        if (group == null && (json = (JSONObject)params.get(TREE_PARENT_ID)) != null) {
            group = json.getLong("value");
        }
        this.getModel().setValue("group", (Object)group);
        this.getModel().setValue("ctrlstrategy", (Object)(isCopy || model.getCtrlStrategy() == null ? DEFAULT_CONTROLSTRANGE : model.getCtrlStrategy()));
        this.getModel().setValue("name", (Object)QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getName()));
        this.getModel().setValue("description", (Object)QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getDescription()));
        if (model.getRecruscene() != null) {
            Object[] recrusceneIds = new Object[model.getRecruscene().size()];
            for (int num = 0; num < model.getRecruscene().size(); ++num) {
                recrusceneIds[num] = model.getRecruscene().get(num);
            }
            this.getModel().setValue("recruscene", (Object)recrusceneIds);
        }
        this.getModel().setValue("evltype", (Object)model.getEvltype());
    }

    void initBoxListPageElement() {
        String existBoxId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
        boolean isDefaultId = HRStringUtils.isEmpty((String)existBoxId) || "-1".equals(existBoxId);
        this.getView().setVisible(Boolean.valueOf(!isDefaultId), new String[]{CTRL_QUESTION_FLEX});
        this.getView().setVisible(Boolean.valueOf(isDefaultId), new String[]{CTRL_COMPREHENSIVE_FLEX});
        if (isDefaultId) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"edit", "delete", "up", "down"});
            return;
        }
        String headBoxId = this.getView().getPageCache().get(CACHE_KEY_HEAD_BOX_ID);
        String tailBoxId = this.getView().getPageCache().get(CACHE_KEY_TAIL_BOX_ID);
        this.getView().setEnable(Boolean.TRUE, new String[]{"edit", "delete"});
        this.getView().setEnable(Boolean.valueOf(existBoxId.equals(headBoxId)), new String[]{"down"});
        this.getView().setEnable(Boolean.valueOf(existBoxId.equals(tailBoxId)), new String[]{"up"});
        if (!existBoxId.equals(tailBoxId) && !existBoxId.equals(headBoxId)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"up", "down"});
        }
        if (headBoxId.equals(tailBoxId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"up", "down"});
        }
        this.showFormDimensionPage(existBoxId);
    }

    private void initPageBySystemPreferences() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean isEdit = OperationStatus.EDIT.equals((Object)parameter.getStatus());
        if (isEdit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
        this.getView().setEnable(Boolean.valueOf(!isEdit), new String[]{"conentpanel", CTRL_QUESTION_FLEX, "flexpanelap1"});
        this.getModel().setValue("issyspreset", (Object)Boolean.FALSE);
        this.getModel().setValue("isdefault", (Object)Boolean.FALSE);
    }

    private void showFormDimensionPage(String inspectId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsrbd_inspectdimop");
        String status = this.getView().getFormShowParameter().getStatus().toString();
        if (KEY_VIEW.equals(status)) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCustomParam("inspectId", (Object)inspectId);
        showParameter.setCustomParam("isEditAuth", (Object)checkOrg);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(CTRL_QUESTION_FLEX);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initBoxListData() {
        String existBoxId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
        List inspectDimensions = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        ArrayList<ListboxItem> itemList = new ArrayList<ListboxItem>();
        if (inspectDimensions != null && !inspectDimensions.isEmpty()) {
            for (DimensionCacheModel inspect : inspectDimensions) {
                itemList.add(new ListboxItem(String.valueOf(inspect.getId()), QuestionnaireCache.parseCacheFieldToLocaleString((Object)inspect.getName()).getLocaleValue_zh_CN()));
            }
            String headId = String.valueOf(((DimensionCacheModel)inspectDimensions.get(0)).getId());
            this.getView().getPageCache().put(CACHE_KEY_HEAD_BOX_ID, headId);
            this.getView().getPageCache().put(CACHE_KEY_TAIL_BOX_ID, String.valueOf(((DimensionCacheModel)inspectDimensions.get(inspectDimensions.size() - 1)).getId()));
            if (HRStringUtils.isEmpty((String)existBoxId)) {
                existBoxId = headId;
                QuestionnaireCache.putActiveBoxIdToCache((IFormView)this.getView(), (String)existBoxId);
            }
        } else {
            existBoxId = "-1";
        }
        Listbox box = (Listbox)this.getView().getControl(CTRL_LIST_BOX_AP);
        box.activeItem(existBoxId);
        itemList.add(QuestionnaireConstants.EVALRETLISTBOXITEM);
        box.addItems(itemList);
    }
}

