/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.intv.questionnaire;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPermissionServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;

public class IntvEvalQuestionnaireBillPlugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(IntvEvalQuestionnaireBillPlugin.class);
    private static final String BTN_DEFAULT = "setdefault";
    private static final String CTRL_TREEBTN = "flexpanel_treebtn";
    private static final String CTRL_ISCONTAINLOWER = "iscontainlower";
    private static final String COLUMN_FILENAME_USEORG = "useorg.id";
    private static final String CACHE_KEY_USEORGIDS = "useOrgIds";
    private static final String CACHE_KEY_FILTERORG = "filterOrg";
    private static final String DEFAULT_ORG = "defaultorg";
    private static final String IS_DEFAULT = "isdefault";
    private static final String ITEM_SETDEFAULT = "1M0SJPZYPM94";
    private static List<String> ctrlStrategyValues = Arrays.asList("1", "2", "5", "6", "7");

    public void afterBindData(EventObject event) {
        HashMap<String, Boolean> control = new HashMap<String, Boolean>(1, 1.0f);
        control.put("vi", Boolean.FALSE);
        this.getView().updateControlMetadata(CTRL_TREEBTN, control);
        this.getView().updateControlMetadata(CTRL_ISCONTAINLOWER, control);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("orgpermchange".equals(evt.getItemKey())) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection rows = listView.getSelectedRows();
            if (rows == null) {
                return;
            }
            ListSelectedRow row = rows.get(0);
            DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireById((Object)row.getPrimaryKeyValue());
            if (questionnaire.getBoolean("issyspreset")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"orgpermchange"});
                return;
            }
        }
        if (BTN_DEFAULT.equals(evt.getItemKey())) {
            ListSelectedRow row = this.validateSelectedRowData();
            if (row == null) {
                return;
            }
            DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireById((Object)row.getPrimaryKeyValue());
            if (questionnaire == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\u6216\u4fee\u6539\u3002", (String)"IntvEvalQuestionnaire_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!questionnaire.getBoolean("enable")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u9ed8\u8ba4\u9762\u8bd5\u8bc4\u4ef7\u8868\u3002", (String)"IntvEvalQuestionnaire_17", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean hasPermission = HRPermissionServiceHelper.hasPerm((long)TSCRequestContext.getUserId(), (String)"tsrbd_intvevlqunr", (String)ITEM_SETDEFAULT);
            if (!hasPermission) {
                return;
            }
            DynamicObject group = questionnaire.getDynamicObject("group");
            String evltype = questionnaire.getString("evltype");
            if (group == null || StringUtils.isEmpty((CharSequence)evltype)) {
                logger.warn("questionnaire group or evltype is  null");
                return;
            }
            this.getView().getPageCache().put("reccategory", group.getString("id"));
            this.getView().getPageCache().put("intvevlqunr", questionnaire.getString("id"));
            this.getView().getPageCache().put("evltype", evltype);
            this.showBosOrgF7(this.getOrgIdsByCtrlStrategy(questionnaire), questionnaire.getPkValue());
        }
    }

    private Collection getOrgIdsByCtrlStrategy(DynamicObject questionnaire) {
        Set<Object> ctrlStrategyOrgIds = new HashSet<Long>();
        String strategy = questionnaire.getString("ctrlstrategy");
        String useOrgIdsStr = this.getView().getPageCache().get(CACHE_KEY_USEORGIDS);
        List useOrgIds = JSON.parseArray((String)useOrgIdsStr, Long.class);
        switch (ctrlStrategyValues.indexOf(strategy)) {
            case 0: {
                ctrlStrategyOrgIds = this.getCtrlStrategyUseOrg(questionnaire.getPkValue());
                break;
            }
            case 1: {
                ctrlStrategyOrgIds = this.getCtrlStrategyUseOrg(questionnaire.getPkValue());
                break;
            }
            case 2: {
                return useOrgIds;
            }
            case 3: {
                return useOrgIds;
            }
            case 4: {
                DynamicObject org = questionnaire.getDynamicObject("createorg");
                ctrlStrategyOrgIds.add(org.getLong("id"));
                break;
            }
            default: {
                ctrlStrategyOrgIds.add(-1L);
            }
        }
        return CollectionUtils.intersection((Collection)useOrgIds, ctrlStrategyOrgIds);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        boolean isSysReset = false;
        for (ListSelectedRow row : rows) {
            DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireById((Object)row.getPrimaryKeyValue());
            if (!questionnaire.getBoolean("issyspreset")) continue;
            isSysReset = true;
        }
        if (isSysReset) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"orgpermchange", "bdctrlchange"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"orgpermchange", "bdctrlchange"});
        }
    }

    private ListSelectedRow validateSelectedRowData() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        if (rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u8bbe\u7f6e\u9ed8\u8ba4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"IntvEvalQuestionnaire_9", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return null;
        }
        return rows.get(0);
    }

    private void showBosOrgF7(Collection collection, Object pk) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("bos_org");
        parameter.setFormId("tsrbd_orgtreelistf7");
        parameter.setPermissionItemId(ITEM_SETDEFAULT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setMultiSelect(true);
        parameter.setShowTitle(false);
        parameter.setLookUp(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_DEFAULT));
        parameter.setShowUsed(true);
        Object[] dys = QuestionnaireHelper.findDefaultQuestionnaireByQuestionnaire((Object)pk);
        List useOrg = Stream.of(dys).map(obj -> obj.getDynamicObject("useorg").getLong("id")).collect(Collectors.toList());
        if (!HRArrayUtils.isEmpty((Object[])dys)) {
            parameter.setSelectedRows(CollectionUtils.intersection((Collection)collection, useOrg).toArray());
        }
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        QFilter qFilter = new QFilter("id", "in", (Object)collection.toArray());
        parameter.getTreeFilterParameter().setQFilters(Collections.singletonList(qFilter));
        parameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (BTN_DEFAULT.equals(evt.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            String recruitment = this.getView().getPageCache().get("reccategory");
            if (HRStringUtils.isEmpty((String)recruitment)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u6570\u636e\u7684\u62db\u8058\u7c7b\u578b\u3002", (String)"IntvEvalQuestionnaire_10", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            Set orgIds = rows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toSet());
            String questionnaireIds = this.getView().getPageCache().get("intvevlqunr");
            String evltype = this.getView().getPageCache().get("evltype");
            QuestionnaireHelper.saveDefaultQuestionnaire((long)Long.parseLong(recruitment), orgIds, (long)Long.parseLong(questionnaireIds), (String)evltype);
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterColumn useOrg = null;
        for (FilterColumn column : args.getCommonFilterColumns()) {
            if (!COLUMN_FILENAME_USEORG.equals(column.getFieldName())) continue;
            useOrg = column;
            List defaultValues = column.getDefaultValues();
            if (!CollectionUtils.isNotEmpty((Collection)defaultValues)) continue;
            this.getView().getPageCache().put(CACHE_KEY_FILTERORG, String.valueOf(defaultValues.get(0)));
            break;
        }
        if (useOrg == null) {
            return;
        }
        List items = ((CommonFilterColumn)useOrg).getComboItems();
        Set ids = items.stream().map(ComboItem::getValue).collect(Collectors.toSet());
        this.getView().getPageCache().put(CACHE_KEY_USEORGIDS, JSON.toJSONString(ids));
    }

    private Set<Long> getCtrlStrategyUseOrg(Object id) {
        DynamicObject adminOrg;
        String entity = "tsrbd_intvevlqunr";
        String dataTableName = ORM.create().getDataEntityType(entity).getAlias();
        String dataTableUseName = dataTableName + "UseReg";
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)entity, (String)String.join((CharSequence)",", "id", "org", "createorg", "masterid"));
        Long adminOrgId = 0L;
        Long createOrg = 0L;
        if (data.get("createorg") instanceof DynamicObject) {
            adminOrg = data.getDynamicObject("createorg");
            createOrg = (Long)adminOrg.getPkValue();
        } else if (data.get("createorg") instanceof Long) {
            createOrg = (Long)data.get("createorg");
        }
        if (data.get("org") instanceof DynamicObject) {
            adminOrg = data.getDynamicObject("org");
            adminOrgId = (Long)adminOrg.getPkValue();
        } else if (data.get("org") instanceof Long) {
            adminOrgId = (Long)data.get("org");
        }
        String sql = "SELECT  fuseorgid  uoid  from %s where fdataid = %s  and fuseorgid <> %s and fuseorgid <> %s";
        sql = String.format(sql, dataTableUseName, id, adminOrgId, createOrg);
        String dbRouteKey = ORM.create().getDataEntityType(entity).getDBRouteKey();
        Set result = (Set)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> set = new HashSet<Long>(rs.getRow());
                while (rs.next()) {
                    set.add(rs.getLong("uoid"));
                }
                return set;
            }
        });
        return result;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List qFilters = args.getFilterParameter().getQFilters();
        for (QFilter qFilter : qFilters) {
            if (!COLUMN_FILENAME_USEORG.equals(qFilter.getProperty())) continue;
            this.getView().getPageCache().put(CACHE_KEY_FILTERORG, JSON.toJSONString((Object)qFilter.getValue()));
        }
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (DEFAULT_ORG.equals(fieldKey)) {
            event.setFormatValue((Object)this.structureDefaultOrg(event.getRowData().getPkValue()));
        }
        if (IS_DEFAULT.equals(fieldKey)) {
            event.setFormatValue((Object)this.hasDefaultOrg(event.getRowData()));
        }
    }

    private boolean hasDefaultOrg(DynamicObject rowData) {
        String filterOrg = this.getView().getPageCache().get(CACHE_KEY_FILTERORG);
        if (HRStringUtils.isEmpty((String)filterOrg)) {
            return false;
        }
        if (!rowData.getBoolean("enable")) {
            return false;
        }
        DynamicObject[] dys = QuestionnaireHelper.findDefaultQuestionnaireByQuestionnaire((Object)rowData.getPkValue());
        List ids = Arrays.stream(dys).map(obj -> obj.getDynamicObject("useorg").getString("id")).collect(Collectors.toList());
        return ids.contains(filterOrg);
    }

    private String structureDefaultOrg(Object pk) {
        Object[] dys = QuestionnaireHelper.findDefaultQuestionnaireByQuestionnaire((Object)pk);
        if (HRArrayUtils.isEmpty((Object[])dys)) {
            return null;
        }
        List allName = Arrays.stream(dys).map(obj -> obj.getDynamicObject("useorg").getString("name")).collect(Collectors.toList());
        return String.join((CharSequence)"\uff0c", allName);
    }
}

