/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.intv.questionnaire;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Vector;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.DimensionCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.common.constants.intv.model.DimensionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionnaireCacheModel;
import kd.tsc.tsrbd.common.constants.intv.questionnaire.QuestionnaireConstants;
import kd.tsc.tsrbd.formplugin.web.intv.questionnaire.IntvEvalQuestionnairePlugin;

public class IntvEvalQuestionnaireDimensionPlugin
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(IntvEvalQuestionnairePlugin.class);

    public void registerListener(EventObject event) {
        this.addClickListeners(new String[]{"edit", "delete", "up", "add", "down"});
    }

    public void click(EventObject evt) {
        Vector vector = (Vector)evt.getSource();
        switch (vector.getKey()) {
            case "add": {
                this.addDimension();
                break;
            }
            case "edit": {
                this.editDimension();
                break;
            }
            case "delete": {
                this.deleteDimension();
                break;
            }
            case "up": {
                this.moveUpDimension();
                break;
            }
            case "down": {
                this.moveDownDimension();
                break;
            }
        }
    }

    private void addDimension() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsrbd_inspectdim");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void editDimension() {
        String boxId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsrbd_inspectdim");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("operationBoxId", (Object)boxId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void deleteDimension() {
        String pkId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
        if (QuestionnaireConstants.EVALRETLISTBOXITEM.getId().equals(pkId)) {
            return;
        }
        ConfirmCallBackListener listener = new ConfirmCallBackListener("tsrbd_inspectdimop", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u5f53\u524d\u8bc4\u4ef7\u7ef4\u5ea6\u5417\uff1f", (String)"IntvEvalQuestionnaire_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
    }

    private void moveUpDimension() {
        String boxId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
        if ("-1".equals(boxId)) {
            return;
        }
        List inspects = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        if (inspects == null || inspects.isEmpty()) {
            return;
        }
        for (int i = 0; i < inspects.size(); ++i) {
            DimensionCacheModel curtInspect = (DimensionCacheModel)inspects.get(i);
            if (!boxId.equals(curtInspect.getId().toString())) continue;
            if (i == 0) break;
            DimensionCacheModel preInspect = (DimensionCacheModel)inspects.get(i - 1);
            inspects.set(i - 1, curtInspect);
            inspects.set(i, preInspect);
            break;
        }
        QuestionnaireCache.putInspectDimension((Collection)inspects, (IFormView)this.getView());
        QuestionnaireCache.putIsChangeInspectDimension((IFormView)this.getView(), (String)Boolean.TRUE.toString());
        this.getView().invokeOperation("refresh");
    }

    private void moveDownDimension() {
        String boxId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
        if ("-1".equals(boxId)) {
            return;
        }
        List inspects = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        if (inspects == null || inspects.isEmpty()) {
            return;
        }
        for (int i = 0; i < inspects.size(); ++i) {
            DimensionCacheModel curtInspect = (DimensionCacheModel)inspects.get(i);
            if (!boxId.equals(curtInspect.getId().toString())) continue;
            if (i == inspects.size() - 1) break;
            DimensionCacheModel nextInspect = (DimensionCacheModel)inspects.get(i + 1);
            inspects.set(i, nextInspect);
            inspects.set(i + 1, curtInspect);
            break;
        }
        QuestionnaireCache.putInspectDimension((Collection)inspects, (IFormView)this.getView());
        QuestionnaireCache.putIsChangeInspectDimension((IFormView)this.getView(), (String)Boolean.TRUE.toString());
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (HRStringUtils.equals((String)"tsrbd_inspectdimop", (String)event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            QuestionnaireCacheModel model = QuestionnaireCache.getCacheData((IFormView)this.getView());
            if (model == null || model.getId() == null) {
                logger.warn("questionnaire cache model is null");
                return;
            }
            String pkId = QuestionnaireCache.getActiveBoxIdFromCache((IFormView)this.getView());
            DimensionCache.removeInspectDimension((String)pkId, (IFormView)this.getView());
            QuestionCache.removeQuestionCache((IFormView)this.getView(), (String)pkId);
            QuestionnaireCache.putActiveBoxIdToCache((IFormView)this.getView(), (String)"-1");
            QuestionnaireCache.putIsChangeInspectDimension((IFormView)this.getView(), (String)Boolean.TRUE.toString());
            this.getView().invokeOperation("refresh");
        }
    }
}

