/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.intv.questionnaire;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.ParseCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.IQuestionHandlerStrategy;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.QuestionContext;
import kd.tsc.tsrbd.common.constants.intv.model.DimensionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.IQuestionnaireCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.OptionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionnaireCacheModel;
import kd.tsc.tsrbd.formplugin.web.intv.questionnaire.AbstractIntvEvalQuestionnaire;

public class IntvEvalQuestionnairePlugin
extends AbstractIntvEvalQuestionnaire
implements ListboxClickListener {
    public static final Log log = LogFactory.getLog(IntvEvalQuestionnairePlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter parameter = args.getFormShowParameter();
        if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
            parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u8bc4\u4ef7\u8868", (String)"IntvEvalQuestionnaire_14", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        } else {
            Object pkId = ((BaseShowParameter)parameter).getPkId();
            if (pkId == null) {
                return;
            }
            DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireById((Object)pkId);
            if (questionnaire != null) {
                parameter.setCaption(questionnaire.getString("name"));
            }
        }
    }

    public void beforeBindData(EventObject event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_saveandnew"});
        BillShowParameter bill = (BillShowParameter)this.getView().getFormShowParameter();
        Long questionnaireId = bill.getPkId() == null ? this.generateQuestionnaireId() : Long.valueOf(bill.getPkId().toString());
        this.refresh(questionnaireId);
    }

    public void afterBindData(EventObject event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_saveandnew"});
    }

    private Long generateQuestionnaireId() {
        QuestionnaireCacheModel model = QuestionnaireCache.getCacheData((IFormView)this.getView());
        if (model == null) {
            model = new QuestionnaireCacheModel();
            model.setId(Long.valueOf(ID.genLongId()));
            QuestionnaireCache.putCache((IFormView)this.getView(), (QuestionnaireCacheModel)model);
        }
        return model.getId();
    }

    public void beforeClosed(BeforeClosedEvent event) {
        QuestionnaireCacheModel model = QuestionnaireCache.getCacheData((IFormView)this.getView());
        if (model == null || model.getId() == null) {
            return;
        }
        DynamicObject questionnaire = QuestionnaireHelper.findQuestionnaireOpById((Object)model.getId());
        if (questionnaire == null) {
            QuestionnaireHelper.destroyInspectDimensionByQuestionnaireId((long)model.getId());
        }
    }

    public void listboxClick(ListboxEvent event) {
        QuestionnaireCache.putActiveBoxIdToCache((IFormView)this.getView(), (String)event.getItemId());
        this.initBoxListPageElement();
    }

    public void registerListener(EventObject event) {
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        box.addListboxClickListener((ListboxClickListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("bar_save".equals(evt.getItemKey())) {
            this.getModel().setValue("status", (Object)"C");
            BillShowParameter bill = (BillShowParameter)this.getView().getFormShowParameter();
            if (bill.getPkId() != null && bill.getBillStatus().getValue() == BillOperationStatus.ADDNEW.getValue()) {
                this.generateNewPrimaryKey();
            }
            this.validateQuestionTitle(evt);
        }
    }

    private void validateQuestionTitle(BeforeItemClickEvent evt) {
        StringBuilder sb = new StringBuilder();
        if (this.isNullTipInfo(sb)) {
            this.getView().showTipNotification(sb.toString(), Integer.valueOf(3000));
            evt.setCancel(true);
        }
    }

    private boolean isNullTipInfo(StringBuilder sb) {
        List inspects = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        if (inspects == null || inspects.isEmpty()) {
            return false;
        }
        boolean isCancel = false;
        for (DimensionCacheModel inspect : inspects) {
            if (inspect.getId() == null) continue;
            LocaleString localeString = QuestionnaireCache.parseCacheFieldToLocaleString((Object)inspect.getName());
            List questionCache = QuestionnaireCache.getQuestionCache((IFormView)this.getView(), (String)String.valueOf(inspect.getId()));
            if (questionCache == null || questionCache.isEmpty()) {
                String tipTitle = ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u201c%s\u201d:\u8bf7\u65b0\u589e\u9898\u76ee\u3002", (String)"IntvEvalQuestionnaire_16", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                sb.append(String.format(Locale.ROOT, tipTitle, localeString.getLocaleValue()));
                isCancel = true;
                continue;
            }
            for (int i = 0; i < questionCache.size(); ++i) {
                QuestionCacheModel model = (QuestionCacheModel)questionCache.get(i);
                if (!this.doIsNullRecursionInvoke((IQuestionnaireCacheModel)model)) continue;
                String tipTitle = ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\uff1a%s\u7b2c%s\u884c\u9898\u76ee\uff0c", (String)"IntvEvalQuestionnaire_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                sb.append(String.format(tipTitle, localeString.getLocaleValue(), i + 1)).append(((IQuestionHandlerStrategy)QuestionContext.getStrategyMap().get(model.getQuestionType())).getNameIsNullTipInfo());
                isCancel = true;
            }
        }
        return isCancel;
    }

    private boolean doIsNullRecursionInvoke(IQuestionnaireCacheModel model) {
        if (model.getName() == null) {
            return true;
        }
        LocaleString localeString = QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getName());
        if (HRStringUtils.isEmpty((String)localeString.getLocaleValue_zh_CN())) {
            return true;
        }
        if (model instanceof QuestionCacheModel) {
            QuestionCacheModel question = (QuestionCacheModel)model;
            if ("C".equals(question.getQuestionType())) {
                return false;
            }
            if (question.getOptions() == null || question.getOptions().isEmpty()) {
                return false;
            }
            for (OptionCacheModel option : question.getOptions()) {
                if (!this.doIsNullRecursionInvoke((IQuestionnaireCacheModel)option)) continue;
                return true;
            }
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": {
                this.submitQuestionnaireInfo();
                break;
            }
            case "view": {
                QuestionnaireHelper.showTsrbdIntvEvlPage(null, null, (String)"preview", null, (IFormView)this.getView(), (Object)ParseCache.transferCacheModeToViewModel((IFormView)this.getView()));
                break;
            }
        }
    }

    private void submitQuestionnaireInfo() {
        String questionnaireId = String.valueOf(this.getModel().getValue("id"));
        QuestionnaireCacheModel questionnaire = QuestionnaireCache.getCacheData((IFormView)this.getView());
        if (questionnaire == null) {
            log.error("questionnaire cache is null");
            return;
        }
        log.info("questionnaire cache :{}", (Object)JSONObject.toJSONString((Object)questionnaire));
        questionnaire.setId(Long.valueOf(questionnaireId));
        QuestionnaireCache.putCache((IFormView)this.getView(), (QuestionnaireCacheModel)questionnaire);
        List models = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        log.info("questionnaire dimension cache :{}", (Object)JSONObject.toJSONString((Object)models));
        ArrayList<DynamicObject> inspects = new ArrayList<DynamicObject>(models == null ? 1 : models.size());
        if (models != null && !models.isEmpty()) {
            for (int i = 0; i < models.size(); ++i) {
                DynamicObject dy = QuestionnaireHelper.generateEmptyInspectDimOp();
                inspects.add(dy);
                DimensionCacheModel model = (DimensionCacheModel)models.get(i);
                dy.set("name", (Object)QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getName()));
                dy.set("description", (Object)QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getDescription()));
                dy.set("id", (Object)model.getId());
                dy.set("intvevlqunrid", (Object)questionnaire.getId());
                dy.set("index", (Object)i);
                DynamicObjectCollection questionEntry = dy.getDynamicObjectCollection("questionentry");
                List questionCache = QuestionnaireCache.getQuestionCache((IFormView)this.getView(), (String)String.valueOf(model.getId()));
                log.info("questionnaire question  cache :{}", (Object)JSONObject.toJSONString((Object)questionCache));
                if (questionCache == null || questionCache.isEmpty()) continue;
                QuestionnaireCache.parseQuestionCache((DynamicObjectCollection)questionEntry, (List)questionCache);
                QuestionnaireCache.putQuestionCache((List)questionCache, (IFormView)this.getView(), (String)String.valueOf(model.getId()));
            }
        }
        log.info("questionnaire prepare save inspectDimOp  questionnaireId :{} ", (Object)questionnaireId);
        QuestionnaireHelper.saveInspectDimOp((DynamicObject[])inspects.toArray(new DynamicObject[0]), (long)questionnaire.getId());
        QuestionnaireCache.putActiveBoxIdToCache((IFormView)this.getView(), (String)(inspects.isEmpty() ? "-1" : ((DynamicObject)inspects.get(0)).getString("id")));
        QuestionnaireCache.removeIsChangeIsnspectDimension((IFormView)this.getView());
        QuestionnaireCache.removeIsChangeQuestion((IFormView)this.getView());
        this.getView().invokeOperation("refresh");
    }

    private void generateNewPrimaryKey() {
        List inspects = QuestionnaireCache.getInspectDimension((IFormView)this.getView());
        if (inspects == null || inspects.isEmpty()) {
            return;
        }
        for (DimensionCacheModel inspect : inspects) {
            List questionCache = QuestionnaireCache.getQuestionCache((IFormView)this.getView(), (String)String.valueOf(inspect.getId()));
            if (questionCache == null || questionCache.isEmpty()) continue;
            for (QuestionCacheModel model : questionCache) {
                model.setId(Long.valueOf(ID.genLongId()));
                if (model.getOptions() == null || model.getOptions().isEmpty()) continue;
                model.getOptions().forEach(option -> option.setId(Long.valueOf(ID.genLongId())));
            }
            QuestionnaireCache.removeQuestionCache((IFormView)this.getView(), (String)String.valueOf(inspect.getId()));
            inspect.setId(Long.valueOf(ID.genLongId()));
            QuestionnaireCache.putActiveBoxIdToCache((IFormView)this.getView(), (String)String.valueOf(inspect.getId()));
            QuestionnaireCache.putQuestionCache((List)questionCache, (IFormView)this.getView(), (String)String.valueOf(inspect.getId()));
        }
        QuestionnaireCache.putInspectDimension((Collection)inspects, (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        List newValue = changeData.getNewValue();
        String fieldKey = args.getProperty().getName();
        boolean hasCreateOrgOrGroup = "createorg".equals(fieldKey) || "group".equals(fieldKey);
        boolean hasCreateRecruscene = "recruscene".equals(fieldKey);
        boolean hasCreteGroup = "group".equals(fieldKey);
        if (newValue instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection localeDynamicObjects = (LocaleDynamicObjectCollection)changeData.getNewValue();
            newValue = localeDynamicObjects.stream().map(dynamicObject -> new LocaleString(dynamicObject.getString("localeid"), dynamicObject.getString(args.getProperty().getName()))).collect(Collectors.toList());
        } else if (newValue != null && hasCreateOrgOrGroup) {
            newValue = ((DynamicObject)newValue).getPkValue();
        } else if (newValue != null && hasCreateRecruscene) {
            DynamicObjectCollection recruscenes = (DynamicObjectCollection)newValue;
            newValue = recruscenes.stream().map(rsc -> rsc.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        }
        QuestionnaireCacheModel model = QuestionnaireCache.getCacheData((IFormView)this.getView());
        if (model == null) {
            model = new QuestionnaireCacheModel();
        }
        Method[] methods = QuestionnaireCacheModel.class.getDeclaredMethods();
        try {
            for (Method method : methods) {
                if (!method.getName().startsWith("set") || !method.getName().toLowerCase().contains(args.getProperty().getName())) continue;
                method.invoke((Object)model, newValue);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e1) {
            log.error("questionnaire set property value failed :", (Throwable)e1);
        }
        if (hasCreteGroup) {
            this.getModel().setValue("recruscene", null);
            model.setRecruscene(null);
        }
        QuestionnaireCache.putCache((IFormView)this.getView(), (QuestionnaireCacheModel)model);
    }
}

