/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.intv.questionnaire.dimension;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.id.ID;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.common.constants.intv.model.DimensionCacheModel;

public class DimensionAddPlugin
extends HRCoreBaseBillEdit {
    public void afterCreateNewData(EventObject e) {
        Object operationBoxId = this.getView().getFormShowParameter().getCustomParam("operationBoxId");
        if (operationBoxId == null) {
            return;
        }
        Long boxId = Long.valueOf(operationBoxId + "");
        List models = QuestionnaireCache.getInspectDimension((IFormView)this.getView().getParentView());
        if (models == null || models.isEmpty()) {
            return;
        }
        DimensionCacheModel model = models.stream().filter(x -> boxId.equals(x.getId())).findFirst().orElse(null);
        if (model == null) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        dataEntity.set("name", (Object)QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getName()));
        dataEntity.set("description", (Object)QuestionnaireCache.parseCacheFieldToLocaleString((Object)model.getDescription()));
        dataEntity.set("id", (Object)model.getId());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject event) {
        Button button = (Button)this.getView().getControl("btnsave");
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        if ("btnsave".equals(button.getKey())) {
            ArrayList<DimensionCacheModel> models = QuestionnaireCache.getInspectDimension((IFormView)this.getView().getParentView());
            if (models == null) {
                models = new ArrayList<DimensionCacheModel>(1);
            }
            DimensionCacheModel model = new DimensionCacheModel();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long pkValue = dataEntity.getLong("id");
            if (pkValue == 0L) {
                model.setId(Long.valueOf(ID.genLongId()));
                models.add(model);
            } else {
                for (DimensionCacheModel modelCache : models) {
                    if (pkValue != modelCache.getId()) continue;
                    model = modelCache;
                }
            }
            model.setName(dataEntity.get("name"));
            model.setDescription(dataEntity.get("description"));
            QuestionnaireCache.putInspectDimension(models, (IFormView)this.getView().getParentView());
            QuestionnaireCache.putActiveBoxIdToCache((IFormView)this.getView().getParentView(), (String)String.valueOf(model.getId()));
            QuestionnaireCache.putIsChangeInspectDimension((IFormView)this.getView().getParentView(), (String)Boolean.TRUE.toString());
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

