/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.intv.questionnaire.question;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.IQuestionHandlerStrategy;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.QuestionContext;
import kd.tsc.tsrbd.common.constants.intv.model.OptionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionCacheModel;
import net.sf.cglib.beans.BeanCopier;

public class DimensionQuestionPlugin
extends HRCoreBaseBillEdit
implements RowClickEventListener {
    private static List<String> BAR_ADD_GROUP = Arrays.asList("addradio", "addcheckbox", "addshortanswer");
    private static final String BTN_DEL_OPTION = "deletesign";
    private static final String BTN_ADD_OPTION = "addsign";
    private static final String CTRL_QUESTION_FLEX = "contentflex";
    private static final String KEY_VIEW = "VIEW";

    public void beforeBindData(EventObject e) {
        List models = QuestionCache.getQuestionCache((IFormView)this.getView().getParentView());
        String status = this.getView().getFormShowParameter().getStatus().toString();
        if (KEY_VIEW.equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        if (models == null || models.isEmpty()) {
            return;
        }
        DynamicObjectCollection questionEntry = this.getModel().getEntryEntity("questionentry");
        questionEntry.clear();
        DynamicObjectCollection questions = QuestionCache.parseQuestionCache((DynamicObjectCollection)questionEntry, (List)models);
        this.setOptionPanel(questions);
    }

    private void setOptionPanel(DynamicObjectCollection questions) {
        Boolean isEditAuth = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isEditAuth");
        if (questions == null || questions.isEmpty()) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("questionentry");
        for (int i = 0; i < questions.size(); ++i) {
            DynamicObject question = (DynamicObject)questions.get(i);
            List<String> allContentFlex = this.getAllOptionFlex(question.getString("questiontype"));
            DynamicObjectCollection options = question.getDynamicObjectCollection("optionsubentry");
            if (!isEditAuth.booleanValue()) {
                cardEntry.setChildVisible(false, i, new String[]{"cardentryflexpanelap2"});
            }
            if (options == null || options.isEmpty()) {
                cardEntry.setChildVisible(false, i, allContentFlex.toArray(new String[0]));
                continue;
            }
            this.processOptionOperationBtnVisible(cardEntry, i, options.size(), question.getString("questiontype"));
            for (int k = 0; k < options.size(); ++k) {
                question.set("content" + k, (Object)((DynamicObject)options.get(k)).getString("optionname"));
                allContentFlex.remove(CTRL_QUESTION_FLEX + k);
            }
            cardEntry.setChildVisible(false, i, allContentFlex.toArray(new String[0]));
        }
    }

    private void processOptionOperationBtnVisible(CardEntry cardEntry, int index, int size, String questionType) {
        IQuestionHandlerStrategy strategy = (IQuestionHandlerStrategy)QuestionContext.getStrategyMap().get(questionType);
        if (size <= strategy.getOptionDefaultMum()) {
            cardEntry.setChildVisible(false, index, new String[]{BTN_DEL_OPTION});
        }
        if (size >= strategy.getMaxOptionMum()) {
            cardEntry.setChildVisible(false, index, new String[]{BTN_ADD_OPTION});
        }
    }

    private List<String> getAllOptionFlex(String questionType) {
        ArrayList<String> allFlex = new ArrayList<String>(10);
        int maxOptionMum = ((IQuestionHandlerStrategy)QuestionContext.getStrategyMap().get(questionType)).getMaxOptionMum();
        for (int i = 1; i < maxOptionMum; ++i) {
            allFlex.add(CTRL_QUESTION_FLEX + i);
        }
        return allFlex;
    }

    public void registerListener(EventObject event) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("questionentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        toolbar.addItemClickListener((ItemClickListener)this);
        Vector addSign = (Vector)this.getView().getControl(BTN_ADD_OPTION);
        addSign.addClickListener((ClickListener)this);
        Vector deleteSign = (Vector)this.getView().getControl(BTN_DEL_OPTION);
        deleteSign.addClickListener((ClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (BAR_ADD_GROUP.contains(evt.getItemKey())) {
            QuestionCache.putAddQuestionButtonType((IFormView)this.getView(), (String)evt.getItemKey());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (!(evt.getSource() instanceof Vector)) {
            return;
        }
        Vector vector = (Vector)evt.getSource();
        String rowIndex = QuestionCache.getCurrentOperationRowIndex((IFormView)this.getView());
        List models = QuestionCache.getQuestionCache((IFormView)this.getView().getParentView());
        QuestionCacheModel question = (QuestionCacheModel)models.get(Integer.parseInt(rowIndex));
        if (BTN_ADD_OPTION.equals(vector.getKey())) {
            question.addEmptyOptions(1);
        } else if (BTN_DEL_OPTION.equals(vector.getKey())) {
            question.removeOptionLastElement();
        }
        QuestionCache.putIsChangeQuestion((IFormView)this.getView().getParentView(), (String)String.valueOf(this.getModel().getDataChanged()));
        QuestionCache.putQuestionCache((List)models, (IFormView)this.getView().getParentView());
        this.getView().invokeOperation("refresh");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        QuestionCacheModel cacheBean;
        if (!"questionentry".equals(e.getEntryProp().getName())) {
            return;
        }
        RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
        String questionType = this.getQuestionType();
        if (HRStringUtils.isNotEmpty((String)questionType)) {
            cacheBean = QuestionCache.addQuestionCache((String)questionType, (IFormView)this.getView().getParentView());
        } else {
            List models = QuestionCache.getQuestionCache((IFormView)this.getView().getParentView());
            String rowIndex = QuestionCache.getCurrentOperationRowIndex((IFormView)this.getView());
            QuestionCacheModel model = (QuestionCacheModel)models.get(Integer.parseInt(rowIndex));
            cacheBean = this.copyQuestionModel(model);
            models.add(cacheBean);
            QuestionCache.putQuestionCache((List)models, (IFormView)this.getView().getParentView());
        }
        this.getModel().setValue("questiontype", (Object)cacheBean.getQuestionType(), rowDataEntity.getRowIndex());
        QuestionCache.putIsChangeQuestion((IFormView)this.getView().getParentView(), (String)String.valueOf(this.getModel().getDataChanged()));
        this.processOptionPageControlVisible(cacheBean, rowDataEntity);
    }

    private QuestionCacheModel copyQuestionModel(QuestionCacheModel model) {
        QuestionCacheModel newBean = new QuestionCacheModel();
        BeanCopier.create(model.getClass(), newBean.getClass(), (boolean)false).copy((Object)model, (Object)newBean, null);
        newBean.setId(null);
        if (newBean.getOptions() != null && !newBean.getOptions().isEmpty()) {
            ArrayList<OptionCacheModel> options = new ArrayList<OptionCacheModel>(10);
            for (OptionCacheModel option : newBean.getOptions()) {
                OptionCacheModel optionBean = new OptionCacheModel();
                BeanCopier.create(option.getClass(), optionBean.getClass(), (boolean)false).copy((Object)option, (Object)optionBean, null);
                optionBean.setId(null);
                options.add(optionBean);
            }
            newBean.setOptions(options);
        }
        return newBean;
    }

    private void processOptionPageControlVisible(QuestionCacheModel model, RowDataEntity rowDataEntity) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("questionentry");
        List<String> contentFlex = this.getAllOptionFlex(model.getQuestionType());
        if (model.getOptions() != null && !model.getOptions().isEmpty()) {
            for (int i = 0; i < model.getOptions().size(); ++i) {
                contentFlex.remove(CTRL_QUESTION_FLEX + i);
            }
        }
        cardEntry.setChildVisible(false, rowDataEntity.getRowIndex(), contentFlex.toArray(new String[0]));
        DynamicObject question = rowDataEntity.getDataEntity();
        List options = model.getOptions();
        if (options == null || options.isEmpty()) {
            return;
        }
        this.processOptionOperationBtnVisible(cardEntry, rowDataEntity.getRowIndex(), options.size(), question.getString("questiontype"));
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int rowIndex = e.getRowIndexs()[0];
        if (rowIndex == 0) {
            return;
        }
        List models = QuestionCache.getQuestionCache((IFormView)this.getView().getParentView());
        QuestionCacheModel currentModel = (QuestionCacheModel)models.get(rowIndex);
        QuestionCacheModel upModel = (QuestionCacheModel)models.get(rowIndex - 1);
        models.set(rowIndex, upModel);
        models.set(rowIndex - 1, currentModel);
        QuestionCache.putQuestionCache((List)models, (IFormView)this.getView().getParentView());
        QuestionCache.putIsChangeQuestion((IFormView)this.getView().getParentView(), (String)String.valueOf(this.getModel().getDataChanged()));
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        List models;
        int rowIndex = e.getRowIndexs()[0];
        if (rowIndex == (models = QuestionCache.getQuestionCache((IFormView)this.getView().getParentView())).size() - 1) {
            return;
        }
        QuestionCacheModel currentModel = (QuestionCacheModel)models.get(rowIndex);
        QuestionCacheModel downModel = (QuestionCacheModel)models.get(rowIndex + 1);
        models.set(rowIndex, downModel);
        models.set(rowIndex + 1, currentModel);
        QuestionCache.putQuestionCache((List)models, (IFormView)this.getView().getParentView());
        QuestionCache.putIsChangeQuestion((IFormView)this.getView().getParentView(), (String)String.valueOf(this.getModel().getDataChanged()));
    }

    private String getQuestionType() {
        String questionType;
        String buttonType = QuestionCache.getAddQuestionButtonType((IFormView)this.getView());
        if (HRStringUtils.isEmpty((String)buttonType)) {
            return "";
        }
        switch (BAR_ADD_GROUP.indexOf(buttonType)) {
            case 0: {
                questionType = "A";
                break;
            }
            case 1: {
                questionType = "B";
                break;
            }
            default: {
                questionType = "C";
            }
        }
        QuestionCache.removeAddQuestionButtonType((IFormView)this.getView());
        return questionType;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        QuestionCache.deleteCache((int)e.getRowIndexs()[0], (IFormView)this.getView().getParentView());
        QuestionCache.putIsChangeQuestion((IFormView)this.getView().getParentView(), (String)String.valueOf(this.getModel().getDataChanged()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue() instanceof LocaleDynamicObjectCollection ? QuestionCache.processLocaleStringToCacheModel((Object)changeData.getNewValue(), (String)e.getProperty().getName()) : changeData.getNewValue();
        QuestionCache.modifyCacheProperty((String)e.getProperty().getName(), (Object)newValue, (int)changeData.getRowIndex(), (IFormView)this.getView().getParentView());
        QuestionCache.putIsChangeQuestion((IFormView)this.getView().getParentView(), (String)String.valueOf(this.getModel().getDataChanged()));
    }

    public void entryRowClick(RowClickEvent evt) {
        QuestionCache.putCurrentOperationRowIndex((IFormView)this.getView(), (String)String.valueOf(evt.getRow()));
    }
}

