/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelEditConstants;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;

public class AddTagPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String PAGE_CACHETAGS_KEY = "tagsCache";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Button submit = (Button)this.getControl("addsubbtn");
        submit.addClickListener((ClickListener)this);
        Label creatTag = (Label)this.getControl("creattagbtn");
        creatTag.addClickListener((ClickListener)this);
        Label clearselectlabel = (Label)this.getControl("clearselectlabel");
        clearselectlabel.addClickListener((ClickListener)this);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        if (HRStringUtils.isNotEmpty((String)searchText)) {
            this.searchEnter(searchText);
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchtags"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"personalhistorytags", "commonhistorytags"});
        }
        return Collections.emptyList();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"searchtags"});
    }

    public void afterCreateNewData(EventObject evt) {
        this.initData();
        this.hideLabelSelectBox();
    }

    private void hideLabelSelectBox() {
        int perSelectLabelNum = Integer.parseInt(this.getModel().getValue("personalselectednum") + "");
        int commSelectLabelNum = Integer.parseInt(this.getModel().getValue("commonselectednum") + "");
        if (perSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personalselecttag"});
        }
        if (commSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonselecttag"});
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String labelName = args.getKey();
        if (HRStringUtils.startsWithIgnoreCase((String)labelName, (String)"tag-")) {
            Label tagLabel = new Label();
            tagLabel.setKey(labelName);
            tagLabel.setView(this.getView());
            tagLabel.addClickListener((ClickListener)this);
            args.setControl((Control)tagLabel);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (!this.checkStdRsmDataStatus()) {
            return;
        }
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"tag-")) {
            this.clickTag(key);
        } else if (HRStringUtils.equals((String)key, (String)"addsubbtn")) {
            Boolean successEidt;
            LabelBO label;
            String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
            Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long tagObjTypeId = Long.parseLong(customParams.get("tagObjTypeId") + "");
            List tagObjList = (List)customParams.get("tagObjList");
            String pageType = customParams.get("pagetype") + "";
            LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
            ArrayList<LabelBO> labelBOs = new ArrayList<LabelBO>();
            for (Map tagData : (ArrayList)tagsMap.get("personalselected")) {
                label = new LabelBO();
                label.setId(Long.valueOf(Long.parseLong((String)tagData.get("id"))));
                label.setLabelCategory((String)tagData.get("type"));
                labelBOs.add(label);
            }
            for (Map tagData : (ArrayList)tagsMap.get("commonselected")) {
                label = new LabelBO();
                label.setId(Long.valueOf(Long.parseLong((String)tagData.get("id"))));
                label.setLabelCategory((String)tagData.get("type"));
                labelBOs.add(label);
            }
            if (HRStringUtils.equals((String)pageType, (String)"detail")) {
                successEidt = labelTagObjServiceHelper.batchEdit(tagObjTypeId, (Long)tagObjList.get(LabelEditConstants.NUM_0), labelBOs, Long.valueOf(RequestContext.get().getOrgId())).getSuccess();
            } else if (!labelBOs.isEmpty()) {
                successEidt = labelTagObjServiceHelper.batchAdd(tagObjTypeId, tagObjList, labelBOs).getSuccess();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u7684\u6807\u7b7e\u3002", (String)"AddTagPlugin_7", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                successEidt = Boolean.FALSE;
            }
            if (successEidt.booleanValue()) {
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
        } else if (HRStringUtils.equals((String)key, (String)"creattagbtn")) {
            this.verificaTag();
        } else if (HRStringUtils.equals((String)key, (String)"clearselectlabel")) {
            String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
            Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
            ArrayList personalSelectLabelMap = (ArrayList)tagsMap.get("personalselected");
            ArrayList commonSelectLabelMap = (ArrayList)tagsMap.get("commonselected");
            for (Map labelMap : personalSelectLabelMap) {
                this.clickTag("tag-personalselected-" + (String)labelMap.get("id"));
            }
            for (Map labelMap : commonSelectLabelMap) {
                this.clickTag("tag-commonselected-" + (String)labelMap.get("id"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        if (result == MessageBoxResult.Yes.getValue()) {
            this.createTag(event.getCallBackId());
        }
    }

    private void initData() {
        HashMap tagsMap = Maps.newHashMapWithExpectedSize((int)LabelEditConstants.NUM_3);
        tagsMap.put("personalhistory", new ArrayList());
        tagsMap.put("commonhistory", new ArrayList());
        tagsMap.put("search", new ArrayList());
        tagsMap.put("personalselected", new ArrayList());
        tagsMap.put("commonselected", new ArrayList());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long tagObjTypeId = Long.parseLong((String)customParams.get("tagObjTypeId"));
        List tagObjList = (List)customParams.get("tagObjList");
        String pageType = customParams.get("pagetype") + "";
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        if (HRStringUtils.equals((String)pageType, (String)"detail")) {
            List labelBos = labelTagObjServiceHelper.batchQueryIlPl(tagObjTypeId, tagObjList, Long.valueOf(RequestContext.get().getOrgId()));
            this.initLabelContent(labelBos, tagsMap, OperationArea.SELECTED_LABEL);
        } else {
            Label label = (Label)this.getView().getControl("addtagtitle");
            label.setText(ResManager.loadKDString((String)"\u6253\u6807\u7b7e", (String)"AddTagPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        }
        List recentUseList = labelTagObjServiceHelper.queryRecentUse(tagObjTypeId);
        this.initLabelContent(recentUseList, tagsMap, OperationArea.HISTORY_LABEL);
        this.getPageCache().put(PAGE_CACHETAGS_KEY, SerializationUtils.toJsonString((Object)tagsMap));
    }

    private void initLabelContent(List<LabelBO> labelBoList, Map<String, ArrayList<Map<String, String>>> tagsMap, OperationArea operationArea) {
        Map<String, List<LabelBO>> labelMap = labelBoList.stream().collect(Collectors.groupingBy(LabelBO::getLabelCategory));
        for (Map.Entry<String, List<LabelBO>> labelEntry : labelMap.entrySet()) {
            this.initLabelDetail(labelEntry, tagsMap, operationArea);
        }
        this.checkLabelData(labelMap, operationArea);
    }

    private void checkLabelData(Map<String, List<LabelBO>> labelMap, OperationArea operationArea) {
        if (operationArea != OperationArea.HISTORY_LABEL) {
            return;
        }
        List<LabelBO> personalLabelList = labelMap.get("A");
        List<LabelBO> commonLabelList = labelMap.get("B");
        if (personalLabelList == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personalhistorytips", "personalhistorytipsbox"});
            this.getModel().setValue("personalhistorytips", (Object)ResManager.loadKDString((String)"\u65e0\u6700\u8fd1\u4f7f\u7528\uff0c\u8bf7\u641c\u7d22\u9009\u62e9", (String)"AddTagPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"personhistoryallselecttip"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personalhistorytips", "personalhistorytipsbox"});
        }
        if (commonLabelList == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"commonhistorytips", "commonhistorytipsbox"});
            this.getModel().setValue("commonhistorytips", (Object)ResManager.loadKDString((String)"\u65e0\u6700\u8fd1\u4f7f\u7528\uff0c\u8bf7\u641c\u7d22\u9009\u62e9", (String)"AddTagPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonhistoryallselecttip"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonhistorytips", "commonhistorytipsbox"});
        }
    }

    private void initLabelDetail(Map.Entry<String, List<LabelBO>> labelEntry, Map<String, ArrayList<Map<String, String>>> tagsMap, OperationArea operationArea) {
        String labelType = labelEntry.getKey();
        int lengthSize = labelEntry.getValue().size();
        ArrayList<Map<String, String>> labelTags = new ArrayList<Map<String, String>>(lengthSize);
        this.initHistoryNum(labelType, lengthSize, operationArea);
        for (LabelBO labelBo : labelEntry.getValue()) {
            HashMap tagData = Maps.newHashMapWithExpectedSize((int)4);
            tagData.put("id", labelBo.getId() + "");
            tagData.put("name", labelBo.getName());
            tagData.put("type", labelBo.getLabelCategory());
            labelTags.add(tagData);
            this.initLabelClassify(labelType, labelBo, operationArea);
            this.checkLabelHasSelect(labelType, tagsMap, labelBo, operationArea);
        }
        this.setAllLabelMap(labelTags, tagsMap, labelType, operationArea);
    }

    private void initHistoryNum(String labelType, int lengthSize, OperationArea operationArea) {
        if (OperationArea.HISTORY_LABEL != operationArea) {
            return;
        }
        if ("A".equals(labelType)) {
            this.updataTagNum("personalhistory", lengthSize);
        } else if ("B".equals(labelType)) {
            this.updataTagNum("commonhistory", lengthSize);
        }
    }

    private void setAllLabelMap(ArrayList<Map<String, String>> labelTags, Map<String, ArrayList<Map<String, String>>> tagsMap, String labelType, OperationArea operationArea) {
        switch (operationArea) {
            case HISTORY_LABEL: {
                this.setHistoryLabelMap(labelTags, tagsMap, labelType);
                break;
            }
            case SELECTED_LABEL: {
                this.setSelectedLabelMap(labelTags, tagsMap, labelType);
                break;
            }
        }
    }

    private void setSelectedLabelMap(ArrayList<Map<String, String>> labelTags, Map<String, ArrayList<Map<String, String>>> tagsMap, String labelType) {
        int selectLabelNum = Integer.parseInt(Optional.of(this.getModel().getValue("selectednum") + "").orElse("0"));
        this.updataTagNum("personalselected", selectLabelNum + labelTags.size());
        if ("A".equals(labelType)) {
            tagsMap.put("personalselected", labelTags);
        } else if ("B".equals(labelType)) {
            tagsMap.put("commonselected", labelTags);
        }
    }

    private void setHistoryLabelMap(ArrayList<Map<String, String>> historyTags, Map<String, ArrayList<Map<String, String>>> tagsMap, String labelType) {
        if ("A".equals(labelType)) {
            tagsMap.put("personalhistory", historyTags);
        } else if ("B".equals(labelType)) {
            tagsMap.put("commonhistory", historyTags);
        }
    }

    private void checkLabelHasSelect(String labelType, Map<String, ArrayList<Map<String, String>>> tagsMap, LabelBO labelBo, OperationArea operationArea) {
        if (operationArea != OperationArea.HISTORY_LABEL) {
            return;
        }
        if ("A".equals(labelType) && this.haveTagInTags(tagsMap.get("personalselected"), labelBo.getId() + "").booleanValue()) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "personalhistory");
            this.getView().setVisible(Boolean.FALSE, new String[]{tagId});
            this.calcTagNum("personalhistory", "-");
        } else if ("B".equals(labelType) && this.haveTagInTags(tagsMap.get("commonselected"), labelBo.getId() + "").booleanValue()) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "commonhistory");
            this.getView().setVisible(Boolean.FALSE, new String[]{tagId});
            this.calcTagNum("commonhistory", "-");
        }
    }

    private void initLabelClassify(String labelType, LabelBO labelBo, OperationArea operationArea) {
        switch (operationArea) {
            case HISTORY_LABEL: {
                this.initHistoryLabelClassify(labelType, labelBo);
                break;
            }
            case SELECTED_LABEL: {
                this.initSelectedLabelClassify(labelType, labelBo);
                break;
            }
        }
    }

    private void initSelectedLabelClassify(String labelType, LabelBO labelBo) {
        int perSelectLabelNum = Integer.parseInt(this.getModel().getValue("personalselectednum") + "");
        int commSelectLabelNum = Integer.parseInt(this.getModel().getValue("commonselectednum") + "");
        if ("A".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "personalselected");
            this.addTag("personalselected", tagId, labelBo.getName(), true);
            this.getModel().setValue("personalselectednum", (Object)String.valueOf(++perSelectLabelNum));
        } else if ("B".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "commonselected");
            this.addTag("commonselected", tagId, labelBo.getName(), true);
            this.getModel().setValue("commonselectednum", (Object)String.valueOf(++commSelectLabelNum));
        }
    }

    private void initHistoryLabelClassify(String labelType, LabelBO labelBo) {
        if ("A".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "personalhistory");
            this.addTag("personalhistory", tagId, labelBo.getName(), false);
        } else if ("B".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "commonhistory");
            this.addTag("commonhistory", tagId, labelBo.getName(), false);
        }
    }

    private void searchEnter(String searchText) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"searchtags"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"personalhistorytags", "commonhistorytags"});
        String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
        Map tagsMap = HRStringUtils.isEmpty((String)Tags) ? null : (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
        ArrayList<HashMap> searchTags = new ArrayList<HashMap>();
        if (tagsMap != null) {
            searchTags = (ArrayList<HashMap>)tagsMap.get("search");
            for (Map map : searchTags) {
                this.deleteTag("search", this.joinTagKey((String)map.get("id"), "search"));
            }
            searchTags = new ArrayList<HashMap>();
        }
        Map searchRes = LabelDataHelper.searchILPLLabelByName((String)searchText, (Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("tagObjTypeId")));
        DynamicObject[] dynamicObjectArray = (DynamicObject[])searchRes.get("data");
        Arrays.sort(dynamicObjectArray, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o2.getString("labelcategory").charAt(LabelEditConstants.NUM_0) - o1.getString("labelcategory").charAt(LabelEditConstants.NUM_0);
            }
        });
        this.updataTagNum("search", dynamicObjectArray.length);
        if (dynamicObjectArray.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchtitle"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"searchtitle"});
        }
        Boolean isShowCreateNew = Boolean.TRUE;
        for (int i = 0; i < dynamicObjectArray.length; ++i) {
            if ((dynamicObjectArray[i].get("name") + "").equals(searchText)) {
                isShowCreateNew = Boolean.FALSE;
            }
            HashMap tagData = Maps.newHashMapWithExpectedSize((int)LabelEditConstants.NUM_4);
            tagData.put("id", dynamicObjectArray[i].get("id") + "");
            tagData.put("name", dynamicObjectArray[i].get("name") + "");
            tagData.put("type", dynamicObjectArray[i].get("labelcategory") + "");
            searchTags.add(tagData);
            this.addTag("search", this.joinTagKey(dynamicObjectArray[i].get("id") + "", "search"), dynamicObjectArray[i].get("name") + "", false);
            if (tagsMap != null && this.haveTagInTags((ArrayList)tagsMap.get("personalselected"), dynamicObjectArray[i].get("id") + "").booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey(dynamicObjectArray[i].get("id") + "", "search")});
                this.calcTagNum("search", "-");
            }
            if (tagsMap == null || !this.haveTagInTags((ArrayList)tagsMap.get("commonselected"), dynamicObjectArray[i].get("id") + "").booleanValue()) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey(dynamicObjectArray[i].get("id") + "", "search")});
            this.calcTagNum("search", "-");
        }
        if (isShowCreateNew.booleanValue()) {
            this.getModel().setValue("creattips", (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u641c\u7d22\u7ed3\u679c", (String)"AddTagPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), searchText));
            this.getView().setVisible(Boolean.TRUE, new String[]{"createtipflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"createtipflex"});
        }
        if (tagsMap != null) {
            tagsMap.put("search", searchTags);
        }
        this.getPageCache().put(PAGE_CACHETAGS_KEY, SerializationUtils.toJsonString((Object)tagsMap));
    }

    private void verificaTag() {
        String searchKey;
        Search search = (Search)this.getControl("searchap");
        String string = searchKey = search.getSearchKey() != null ? search.getSearchKey() : "";
        if (searchKey.length() > LabelEditConstants.NUM_10) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u7b7e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"AddTagPlugin_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        Long tagObjTypeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("tagObjTypeId"));
        Integer code = LabelDataHelper.createILLabelValidator((String)searchKey, (Long)tagObjTypeId);
        String currentTagObjTypeName = LabelDataHelper.getTagObjName((Long)tagObjTypeId);
        switch (code) {
            case 200: {
                this.createTag(code.toString());
                break;
            }
            case 201: {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(code.toString(), (IFormPlugin)this);
                String confirmMessage = ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u662f\u5426\u542f\u7528\uff1f", (String)"AddTagPlugin_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case 202: {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(code.toString(), (IFormPlugin)this);
                String confirmMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u662f\u5426\u5c06%s\u8bbe\u7f6e\u4e3a\u6807\u8bb0\u5bf9\u8c61\uff1f", (String)"AddTagPlugin_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), currentTagObjTypeName);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case 203: {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(code.toString(), (IFormPlugin)this);
                String confirmMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c%s\u4e0d\u5728\u6807\u8bb0\u5bf9\u8c61\u8303\u56f4\u5185\u4e14\u88ab\u7981\u7528\uff0c\u662f\u5426\u66f4\u6539\uff1f", (String)"AddTagPlugin_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), currentTagObjTypeName);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
        }
    }

    private void createTag(String code) {
        Search search = (Search)this.getControl("searchap");
        String searchKey = search.getSearchKey() != null ? search.getSearchKey() : "";
        Long tagObjTypeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("tagObjTypeId"));
        Map returned = Maps.newHashMapWithExpectedSize((int)LabelEditConstants.NUM_3);
        switch (Integer.parseInt(code)) {
            case 200: {
                returned = LabelDataHelper.createILLabel((String)searchKey, (Long)tagObjTypeId);
                break;
            }
            case 201: {
                returned = LabelDataHelper.updateILLabel((String)searchKey, (String)"1", null);
                break;
            }
            case 202: {
                returned = LabelDataHelper.updateILLabel((String)searchKey, null, (Long)tagObjTypeId);
                break;
            }
            case 203: {
                returned = LabelDataHelper.updateILLabel((String)searchKey, (String)"1", (Long)tagObjTypeId);
                break;
            }
        }
        if (returned.get("state").equals("T")) {
            DynamicObject labelObj = (DynamicObject)returned.get("label");
            String key = labelObj.get("id") + "";
            this.searchEnter(searchKey);
            String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
            Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
            if (!this.haveTagInTags((ArrayList)tagsMap.get("personalselected"), key).booleanValue()) {
                this.clickTag(this.joinTagKey(key, "search"));
            }
        }
    }

    private void clickTag(String key) {
        String tagId = this.splitTagKey(key)[LabelEditConstants.NUM_2];
        String origin = this.splitTagKey(key)[LabelEditConstants.NUM_1];
        String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
        Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
        int perSelectLabelNum = Integer.parseInt(this.getModel().getValue("personalselectednum") + "");
        int commSelectLabelNum = Integer.parseInt(this.getModel().getValue("commonselectednum") + "");
        if (HRStringUtils.equals((String)origin, (String)"personalhistory")) {
            Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("personalhistory"), tagId);
            ArrayList personSelecteds = (ArrayList)tagsMap.get("personalselected");
            Container flexpanelap = (Container)this.getView().getControl("personalselected");
            ArrayList labelKeyArr = Lists.newArrayListWithCapacity((int)personSelecteds.size());
            personSelecteds.forEach(labelMap -> labelKeyArr.add(this.joinTagKey((String)labelMap.get("id"), "personalselected")));
            flexpanelap.deleteControls(labelKeyArr.toArray(new String[0]));
            ((ArrayList)tagsMap.get("personalselected")).add(tagDate);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.calcTagNum("personalhistory", "-");
            Collections.reverse(personSelecteds);
            personSelecteds.forEach(labelMap -> this.addTag("personalselected", this.joinTagKey((String)labelMap.get("id"), "personalselected"), (String)labelMap.get("name"), true));
            ++perSelectLabelNum;
            this.getModel().setValue("personalselectednum", (Object)String.valueOf(perSelectLabelNum));
        } else if (HRStringUtils.equals((String)origin, (String)"commonhistory")) {
            Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("commonhistory"), tagId);
            ArrayList personSelecteds = (ArrayList)tagsMap.get("commonselected");
            Container flexpanelap = (Container)this.getView().getControl("commonselected");
            ArrayList labelKeyArr = Lists.newArrayListWithCapacity((int)personSelecteds.size());
            personSelecteds.forEach(labelMap -> labelKeyArr.add(this.joinTagKey((String)labelMap.get("id"), "commonselected")));
            flexpanelap.deleteControls(labelKeyArr.toArray(new String[0]));
            ((ArrayList)tagsMap.get("commonselected")).add(tagDate);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.calcTagNum("commonhistory", "-");
            Collections.reverse(personSelecteds);
            personSelecteds.forEach(labelMap -> this.addTag("commonselected", this.joinTagKey((String)labelMap.get("id"), "commonselected"), (String)labelMap.get("name"), true));
            ++commSelectLabelNum;
            this.getModel().setValue("commonselectednum", (Object)String.valueOf(commSelectLabelNum));
        } else if (HRStringUtils.equals((String)origin, (String)"search")) {
            Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("search"), tagId);
            String labelType = tagDate.get("type");
            String selectKey = this.getSelectLabelType(labelType);
            String historyKey = this.getHistoryLabelType(labelType);
            String selectNumKey = this.getSelectLabelNum(labelType);
            int selectLabelNum = "A".equals(labelType) ? (perSelectLabelNum = ++perSelectLabelNum) : (commSelectLabelNum = ++commSelectLabelNum);
            this.getModel().setValue(selectNumKey, (Object)String.valueOf(selectLabelNum));
            ArrayList personSelecteds = (ArrayList)tagsMap.get(selectKey);
            Container flexpanelap = (Container)this.getView().getControl(selectKey);
            ArrayList labelKeyArr = Lists.newArrayListWithCapacity((int)personSelecteds.size());
            personSelecteds.forEach(labelMap -> labelKeyArr.add(this.joinTagKey((String)labelMap.get("id"), selectKey)));
            flexpanelap.deleteControls(labelKeyArr.toArray(new String[0]));
            ((ArrayList)tagsMap.get(selectKey)).add(tagDate);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.calcTagNum("search", "-");
            Collections.reverse(personSelecteds);
            personSelecteds.forEach(labelMap -> this.addTag(selectKey, this.joinTagKey((String)labelMap.get("id"), selectKey), (String)labelMap.get("name"), true));
            if (this.haveTagInTags((ArrayList)tagsMap.get(historyKey), tagId).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey(tagId, historyKey)});
                this.calcTagNum(historyKey, "-");
            }
        } else {
            boolean hasSubtract = false;
            if (this.haveTagInTags((ArrayList)tagsMap.get("personalhistory"), tagId).booleanValue()) {
                this.deleteTag("personalselected", key);
                ((ArrayList)tagsMap.get("personalselected")).remove(this.getTagDataForList((ArrayList)tagsMap.get("personalselected"), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "personalhistory")});
                this.calcTagNum("personalhistory", "+");
                --perSelectLabelNum;
                this.getModel().setValue("personalselectednum", (Object)String.valueOf(perSelectLabelNum));
                hasSubtract = true;
            }
            if (this.haveTagInTags((ArrayList)tagsMap.get("commonhistory"), tagId).booleanValue()) {
                this.deleteTag("commonselected", key);
                ((ArrayList)tagsMap.get("commonselected")).remove(this.getTagDataForList((ArrayList)tagsMap.get("commonselected"), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "commonhistory")});
                this.calcTagNum("commonhistory", "+");
                --commSelectLabelNum;
                this.getModel().setValue("commonselectednum", (Object)String.valueOf(commSelectLabelNum));
                hasSubtract = true;
            }
            if (this.haveTagInTags((ArrayList)tagsMap.get("search"), tagId).booleanValue()) {
                Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("search"), tagId);
                String labelType = tagDate.get("type");
                String selectKey = this.getSelectLabelType(labelType);
                this.deleteTag(selectKey, key);
                ((ArrayList)tagsMap.get(selectKey)).remove(this.getTagDataForList((ArrayList)tagsMap.get(selectKey), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "search")});
                this.calcTagNum("search", "+");
                if (!hasSubtract) {
                    String selectNumKey = this.getSelectLabelNum(labelType);
                    int selectLabelNum = "A".equals(labelType) ? (perSelectLabelNum = --perSelectLabelNum) : (commSelectLabelNum = --commSelectLabelNum);
                    this.getModel().setValue(selectNumKey, (Object)String.valueOf(selectLabelNum));
                }
                hasSubtract = true;
            }
            if (!hasSubtract) {
                String labelType = "commonselected".equals(origin) ? "B" : "A";
                String selectKey = this.getSelectLabelType(labelType);
                this.deleteTag(selectKey, key);
                ((ArrayList)tagsMap.get(selectKey)).remove(this.getTagDataForList((ArrayList)tagsMap.get(selectKey), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "search")});
                this.calcTagNum("search", "+");
                String selectNumKey = this.getSelectLabelNum(labelType);
                int selectLabelNum = "A".equals(labelType) ? (perSelectLabelNum = --perSelectLabelNum) : (commSelectLabelNum = --commSelectLabelNum);
                this.getModel().setValue(selectNumKey, (Object)String.valueOf(selectLabelNum));
            }
        }
        this.showOrSelectLabelTag(perSelectLabelNum, commSelectLabelNum);
        int size = ((ArrayList)tagsMap.get("personalselected")).size() + ((ArrayList)tagsMap.get("commonselected")).size();
        this.updataTagNum("personalselected", size);
        this.getPageCache().put(PAGE_CACHETAGS_KEY, SerializationUtils.toJsonString((Object)tagsMap));
    }

    private String getSelectLabelNum(String labelType) {
        if ("A".equals(labelType)) {
            return "personalselectednum";
        }
        if ("B".equals(labelType)) {
            return "commonselectednum";
        }
        return "";
    }

    private String getHistoryLabelType(String labelType) {
        if ("A".equals(labelType)) {
            return "personalhistory";
        }
        if ("B".equals(labelType)) {
            return "commonhistory";
        }
        return "";
    }

    private String getSelectLabelType(String labelType) {
        if ("A".equals(labelType)) {
            return "personalselected";
        }
        if ("B".equals(labelType)) {
            return "commonselected";
        }
        return "";
    }

    private void showOrSelectLabelTag(int perSelectLabelNum, int commSelectLabelNum) {
        if (perSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personalselecttag"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personalselecttag"});
        }
        if (commSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonselecttag"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"commonselecttag"});
        }
    }

    private void deleteTag(String flexId, String tagKey) {
        Container flexpanelap = (Container)this.getView().getControl(flexId);
        flexpanelap.deleteControls(new String[]{tagKey});
    }

    private void addTag(String flexId, String tagId, String name, boolean isShowDeleteVector) {
        Container flexpanelap = (Container)this.getView().getControl(flexId);
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setKey(tagId);
        this.addClickListeners(new String[]{tagId});
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setClickable(true);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setForeColor("#666666");
        Style style = new Style();
        style.setBorder(this.setBorderStyle());
        completeLabelPanelAp.setStyle(style);
        ArrayList<Map> listitem = new ArrayList<Map>();
        LabelAp title = new LabelAp();
        title.setKey(tagId);
        title.setName(new LocaleString(name));
        title.setClickable(true);
        title.setForeColor("#666666");
        title.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICBtYXgtd2lkdGg6IDk2cHg7XG59In0=");
        this.addClickListeners(new String[]{title.getKey()});
        completeLabelPanelAp.getItems().add(title);
        if (isShowDeleteVector) {
            VectorAp vectorAp = this.createVectorByType(tagId);
            completeLabelPanelAp.getItems().add(vectorAp);
        }
        listitem.add(completeLabelPanelAp.createControl());
        flexpanelap.addControls(listitem);
    }

    private VectorAp createVectorByType(String labelTagObjId) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey("lvector" + labelTagObjId);
        vectorAp.setId(labelTagObjId);
        vectorAp.setfontClass("kdfont kdfont-guanbi8");
        vectorAp.setForeColor("#666666");
        vectorAp.setClickable(false);
        vectorAp.setFontSize(7);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("2px");
        style.setMargin(margin);
        vectorAp.setStyle(style);
        return vectorAp;
    }

    private Border setBorderStyle() {
        Border border = new Border();
        border.setBottom("1px_solid_#666666");
        border.setLeft("1px_solid_#666666");
        border.setRight("1px_solid_#666666");
        border.setTop("1px_solid_#666666");
        return border;
    }

    private Boolean haveTagInTags(ArrayList<Map<String, String>> list, String tagId) {
        Boolean bool = Boolean.FALSE;
        for (Map<String, String> tagData : list) {
            if (!HRStringUtils.equals((String)tagData.get("id"), (String)tagId)) continue;
            bool = Boolean.TRUE;
        }
        return bool;
    }

    private String joinTagKey(String key, String origin) {
        return "tag-" + origin + "-" + key;
    }

    private String[] splitTagKey(String key) {
        return key.split("-");
    }

    private Map<String, String> getTagDataForList(ArrayList<Map<String, String>> list, String tagId) {
        Map<String, String> tag = new HashMap<String, String>(16);
        for (Map<String, String> tagData : list) {
            if (!HRStringUtils.equals((String)tagData.get("id"), (String)tagId)) continue;
            tag = tagData;
        }
        return tag;
    }

    private void updataTagNum(String type, int num) {
        if (HRStringUtils.equals((String)type, (String)"personalselected")) {
            this.getModel().setValue("selectednum", (Object)num);
            String string = this.getView().getFormShowParameter().getCustomParam("pagetype") + "";
        } else if (HRStringUtils.equals((String)type, (String)"search")) {
            if (num == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"searchallselecttip"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"searchallselecttip"});
            }
            this.getModel().setValue("searchnum", (Object)num);
        } else if (HRStringUtils.equals((String)type, (String)"commonhistory")) {
            if (num == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"commonhistoryallselecttip"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"commonhistoryallselecttip"});
            }
            this.getModel().setValue("commonhistorynum", (Object)num);
        } else {
            if (num == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"personhistoryallselecttip"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"personhistoryallselecttip"});
            }
            this.getModel().setValue("personalhistorynum", (Object)num);
        }
    }

    private void calcTagNum(String type, String mode) {
        int reNum = HRStringUtils.equals((String)mode, (String)"-") ? new BigDecimal(this.getModel().getValue(type + "num").toString()).subtract(new BigDecimal(1)).intValue() : new BigDecimal(this.getModel().getValue(type + "num").toString()).add(new BigDecimal(1)).intValue();
        this.updataTagNum(type, reNum);
    }

    private boolean checkStdRsmDataStatus() {
        if (this.getView().getParentView() != null && StringUtils.equals((CharSequence)"tstpm_candidate_detail", (CharSequence)this.getView().getParentView().getParentView().getFormShowParameter().getFormId())) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"checkStdRsmDataStatus", (Object[])new Object[]{this.getView().getParentView().getParentView(), this.getView()});
        }
        return true;
    }

    public static enum OperationArea {
        HISTORY_LABEL,
        SELECTED_LABEL,
        SEARCH_LABEL;

    }
}

