/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.label.service.LabelServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbd.formplugin.web.label.utils.LabelPluginUtils;

public class IndividualLabelList
extends HRDataBaseList {
    private static final String PAGE_CACHE_KEY_TYPE2LABELS = "type2Labels";
    private static final String PAGE_CACHE_KEY_UNENABLED_IDS = "unEnabledIds";
    private static final String TSC_TSRBD_FORMPLUGIN = "tsc-tsrbd-formplugin";

    public void filterContainerInit(FilterContainerInitArgs args) {
        args.addFilterColumn((FilterColumn)LabelPluginUtils.getTagObjectCommonFilterColumn("%B%"));
        List filterColumns = args.getCommonFilterColumns();
        FilterColumn filterColumn0 = (FilterColumn)filterColumns.get(0);
        FilterColumn filterColumn1 = (FilterColumn)filterColumns.get(1);
        filterColumns.set(0, filterColumn1);
        filterColumns.set(1, filterColumn0);
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        LabelPluginUtils.setTagObjectFilter(qFilters, this.getControlFilters());
        qFilters.add(new QFilter("labelcategory", "=", (Object)"A"));
        qFilters.add(new QFilter("creator", "=", (Object)TSCRequestContext.getUserId()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.equalsIgnoreCase("delete")) {
            args.setCancel(true);
            ArrayList ids = new ArrayList();
            listSelectedRowCollection.stream().forEach(listSelectedRow -> ids.add((Long)listSelectedRow.getPrimaryKeyValue()));
            DynamicObject[] labels = LabelServiceHelper.getInstance().getIndividualLabels(ids);
            ArrayList<String> enabledNumbers = new ArrayList<String>();
            ArrayList<Long> unEnabledIds = new ArrayList<Long>();
            HashMap type2Labels = Maps.newHashMapWithExpectedSize((int)4);
            for (DynamicObject label : labels) {
                DynamicObjectCollection objTypes = label.getDynamicObjectCollection("tagobjtype");
                for (DynamicObject objType : objTypes) {
                    Long objTypeId = objType.getDynamicObject("fbasedataid").getLong("id");
                    ArrayList<Long> labelIds = (ArrayList<Long>)type2Labels.get(objTypeId);
                    if (null == labelIds) {
                        labelIds = new ArrayList<Long>();
                        type2Labels.put(objTypeId, labelIds);
                    }
                    labelIds.add(label.getLong("id"));
                }
                if (HRStringUtils.equals((String)label.getString("enable"), (String)"1")) {
                    enabledNumbers.add(label.getString("number"));
                    continue;
                }
                unEnabledIds.add(label.getLong("id"));
            }
            this.getPageCache().put(PAGE_CACHE_KEY_TYPE2LABELS, SerializationUtils.toJsonString((Object)type2Labels));
            if (this.checkOneEnable(labels, enabledNumbers)) {
                return;
            }
            if (this.checkMultiEnable(labels, enabledNumbers, unEnabledIds)) {
                return;
            }
            this.doDeleteOperation(labels, unEnabledIds);
        }
    }

    private void doDeleteOperation(DynamicObject[] dynamicObjects, List<Long> unEnabledIds) {
        if (unEnabledIds.size() == dynamicObjects.length) {
            this.getPageCache().put(PAGE_CACHE_KEY_UNENABLED_IDS, SerializationUtils.toJsonString(unEnabledIds));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u540e\u5c06\u540c\u6b65\u4ece\u6807\u8bb0\u5bf9\u8c61\u79fb\u9664\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"IndividualLabelList_4", (String)TSC_TSRBD_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    private boolean checkMultiEnable(DynamicObject[] dynamicObjects, List<String> enabledNumbers, List<Long> unEnabledIds) {
        if (unEnabledIds.size() != dynamicObjects.length) {
            ArrayList<String> tips = new ArrayList<String>(enabledNumbers.size());
            for (String enabledNumber : enabledNumbers) {
                String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u542f\u7528\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u5220\u9664\u3002", (String)"IndividualLabelList_0", (String)TSC_TSRBD_FORMPLUGIN, (Object[])new Object[0]), enabledNumber);
                tips.add(tip);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_operationresult");
            formShowParameter.setShowTitle(false);
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5171%s\u6761\u6807\u7b7e\uff0c\u5220\u9664\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761", (String)"IndividualLabelList_1", (String)TSC_TSRBD_FORMPLUGIN, (Object[])new Object[0]), dynamicObjects.length, dynamicObjects.length - enabledNumbers.size(), enabledNumbers.size());
            formShowParameter.setCustomParam("title", (Object)title);
            formShowParameter.setCustomParam("errorMsg", (Object)String.join((CharSequence)"\n", tips));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
            LabelServiceHelper.getInstance().delete("tsrbd_individuallabel", unEnabledIds);
            this.getView().invokeOperation("refresh");
            return true;
        }
        return false;
    }

    private boolean checkOneEnable(DynamicObject[] dynamicObjects, List<String> enabledNumbers) {
        if (enabledNumbers.size() == dynamicObjects.length && 1 == dynamicObjects.length) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u542f\u7528\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u5220\u9664\u3002", (String)"IndividualLabelList_0", (String)TSC_TSRBD_FORMPLUGIN, (Object[])new Object[0]), enabledNumbers.get(0));
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        int result = e.getResult().getValue();
        if (HRStringUtils.equals((String)"delete", (String)e.getCallBackId()) && result == MessageBoxResult.Yes.getValue()) {
            String tip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"IndividualLabelList_2", (String)TSC_TSRBD_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showSuccessNotification(tip);
            Map type2Labels = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGE_CACHE_KEY_TYPE2LABELS), Map.class);
            for (Map.Entry entry : type2Labels.entrySet()) {
                Long type = Long.parseLong((String)entry.getKey());
                LabelServiceHelper.getInstance().deleteTagByLabels((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(type), (List)entry.getValue());
            }
            List unEnabledIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGE_CACHE_KEY_UNENABLED_IDS), List.class);
            LabelServiceHelper.getInstance().delete("tsrbd_individuallabel", unEnabledIds);
            this.getView().invokeOperation("refresh");
        }
    }
}

