/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.business.domain.label.service.PortraitServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LabelDefaultShowPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(LabelDefaultShowPlugin.class);

    public void registerListener(EventObject event) {
        this.addClickListeners(new String[]{"vec_portrait", "fold_panel"});
        boolean isShowEditBtn = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCanEditLabel");
        if (isShowEditBtn) {
            this.addClickListeners(new String[]{"addlabelflex"});
        }
        this.addClickListeners(new String[]{"deletelabel"});
    }

    public void afterBindData(EventObject evt) {
    }

    public void afterCreateNewData(EventObject event) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isShowEditBtn = (Boolean)formShowParameter.getCustomParam("isCanEditLabel");
        Boolean isShowMyLabel = (Boolean)formShowParameter.getCustomParam("isShowMyLabel");
        Boolean isFoldContent = (Boolean)formShowParameter.getCustomParam("isFold");
        this.getModel().setValue("text_isfold", (Object)isFoldContent);
        this.getView().setVisible(isShowEditBtn, new String[]{"addlabelflex"});
        this.getView().setVisible(isShowMyLabel, new String[]{"flexpanel_mylabel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"labelpanel_prominent", "labelpanel_focus", "labelpanel_mylabel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"label_more_prominent", "label_more_focus"});
        this.loadMyLabelData();
        this.loadAILabelData();
    }

    public void click(EventObject evt) {
        if (!this.checkStdRsmDataStatus()) {
            return;
        }
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Long id = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("id") + "");
        Long typeId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("type") + "");
        Long aiId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("aiId") + "");
        Long aiTypeId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("aiTypeId") + "");
        if ("addlabelflex".equals(key)) {
            LabelDataHelper.showAddLabelPage((IFormPlugin)this, (IFormView)this.getView(), Collections.singletonList(id), (Long)typeId, (String)"detail");
        } else if ("vec_portrait".equals(key)) {
            LabelDataHelper.showAppRsmPortraitPage((IFormView)this.getView(), (Long)aiId, (Long)aiTypeId);
            this.loadAILabelData();
        } else if ("fold_panel".equals(key)) {
            Boolean curState = Boolean.parseBoolean(this.getModel().getValue("text_isfold") + "");
            this.getModel().setValue("text_isfold", (Object)(curState == false ? 1 : 0));
        } else if ("deletelabel".equals(key)) {
            this.deleteLabel();
        }
    }

    private void deleteLabel() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isShowEditBtn = (Boolean)formShowParameter.getCustomParam("isCanEditLabel");
        if (!isShowEditBtn.booleanValue()) {
            return;
        }
        Long labelId = Long.parseLong(this.getView().getModel().getValue("labelid") + "");
        Long tagObjTypeId = Long.parseLong((String)formShowParameter.getCustomParam("type"));
        Long tagObjId = (Long)formShowParameter.getCustomParam("id");
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        boolean removeSucess = labelTagObjServiceHelper.remove(tagObjTypeId, tagObjId, labelId);
        if (removeSucess) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"tsrbd_addtag", (CharSequence)actionId) || StringUtils.equals((CharSequence)"tsrbd_edittag", (CharSequence)actionId)) {
            this.loadMyLabelData();
        }
        if (this.getView().getParentView() != null) {
            LabelDataHelper.handleCloseCallBack((ClosedCallBackEvent)closedCallBackEvent, (IFormView)this.getView().getParentView());
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private List<LabelBO> queryLabel(FormShowParameter formShowParameter) {
        ArrayList pairList;
        Object tagObjIdObj = formShowParameter.getCustomParam("id");
        Long tagObjId = tagObjIdObj == null ? null : Long.valueOf(Long.parseLong(tagObjIdObj.toString()));
        Long tagObjTypeId = Long.parseLong((String)formShowParameter.getCustomParam("type"));
        Pair mainIdTypeId = Pair.of((Object)tagObjTypeId, (Object)tagObjId);
        Object pairListObj = formShowParameter.getCustomParams().get("typeIdList");
        logger.info("queryLabel.pairListObj:{}", pairListObj);
        List excludeLabelTypes = (List)formShowParameter.getCustomParam("excludeCategorys");
        if (pairListObj == null) {
            pairList = Collections.singletonList(mainIdTypeId);
        } else {
            Map pairMap = (Map)pairListObj;
            pairList = Lists.newArrayListWithExpectedSize((int)pairMap.size());
            for (Map.Entry entry : pairMap.entrySet()) {
                pairList.add(Pair.of((Object)Long.valueOf((String)entry.getKey()), (Object)Long.valueOf((String)entry.getValue())));
            }
            pairList.add(mainIdTypeId);
        }
        logger.info("queryLabel.formShowParams:{}", (Object)formShowParameter.getCustomParams());
        Long orgId = RequestContext.get().getOrgId();
        Object orgObject = formShowParameter.getCustomParam("useorg");
        if (orgObject != null) {
            orgId = Long.valueOf(String.valueOf(orgObject));
        }
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        return labelTagObjServiceHelper.batchQuery((List)pairList, orgId, excludeLabelTypes);
    }

    private void loadMyLabelData() {
        List<Object> labelBOList = this.queryLabel(this.getView().getFormShowParameter());
        labelBOList = labelBOList.stream().filter(labelBO -> labelBO.getCreateTime() != null).sorted(Comparator.comparing(LabelBO::getCreateTime).reversed()).collect(Collectors.toList());
        this.setLabelToEntry("mylabel", labelBOList);
    }

    private void loadAILabelData() {
        Long tagObjTypeId;
        Long tagObjId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("aiId") + "");
        Map portraitOverData = PortraitServiceHelper.getPortraitOverView((Long)tagObjId, (Long)(tagObjTypeId = Long.valueOf(Long.parseLong(this.getView().getFormShowParameter().getCustomParam("aiTypeId") + ""))));
        if (portraitOverData == null) {
            return;
        }
        if (portraitOverData.get("prominent") != null) {
            List prominentData = (List)portraitOverData.get("prominent");
            this.setLabelToEntry("prominent", this.transToLabelBo(prominentData));
        }
        if (portraitOverData.get("focus") != null) {
            List focusData = (List)portraitOverData.get("focus");
            this.setLabelToEntry("focus", this.transToLabelBo(focusData));
        }
    }

    private List<LabelBO> transToLabelBo(List<Map<String, String>> listData) {
        ArrayList<LabelBO> labelBOList = new ArrayList<LabelBO>(listData.size());
        SecureRandom secureRandom = new SecureRandom();
        for (Map<String, String> item : listData) {
            LabelBO labelBO = new LabelBO();
            labelBO.setId(Long.valueOf(secureRandom.nextLong()));
            labelBO.setName(item.get("prominentName"));
            labelBOList.add(labelBO);
        }
        return labelBOList;
    }

    private void setLabelToEntry(String labelType, List<LabelBO> labelBOList) {
        block6: {
            Boolean isShowLabelPanel;
            Gson gson = new Gson();
            this.getView().getPageCache().put("label_" + labelType, gson.toJson(labelBOList));
            int maxLabelNum = 3;
            if (labelType.equals("mylabel")) {
                maxLabelNum = 2;
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Boolean isShowEditBtn = (Boolean)formShowParameter.getCustomParam("isCanEditLabel");
                isShowLabelPanel = isShowEditBtn != false || labelBOList.size() > 0;
            } else {
                isShowLabelPanel = labelBOList.size() > 0;
            }
            this.getView().setVisible(isShowLabelPanel, new String[]{"labelpanel_" + labelType});
            this.getView().setVisible(Boolean.valueOf(isShowLabelPanel == false), new String[]{"nodata_" + labelType});
            this.getView().setVisible(Boolean.valueOf(labelBOList.size() > maxLabelNum), new String[]{"label_more_" + labelType});
            Label label = (Label)this.getControl("label_more_" + labelType);
            label.setText("+" + (labelBOList.size() - maxLabelNum));
            this.getModel().deleteEntryData("entryentity_" + labelType);
            if (labelBOList.size() <= 0) break block6;
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity_" + labelType, Math.min(labelBOList.size(), maxLabelNum));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Boolean isShowEditBtn = (Boolean)formShowParameter.getCustomParam("isCanEditLabel");
            logger.info("\u3010LabelDefaultShowPlugin\u3011\"setLabelToEntry\" isShowEditBtn:{}", (Object)isShowEditBtn);
            this.getView().setVisible(isShowEditBtn, new String[]{"deletelabel"});
            if (isShowEditBtn.booleanValue() && "mylabel".equals(labelType)) {
                for (int index = 0; index < labelBOList.size(); ++index) {
                    if (index >= maxLabelNum) continue;
                    this.getModel().setValue("labelid", (Object)labelBOList.get(index).getId(), rowIndex[index]);
                    this.getModel().setValue("text_" + labelType, (Object)labelBOList.get(index).getName(), rowIndex[index]);
                }
            } else {
                for (int index = 0; index < labelBOList.size(); ++index) {
                    if (index >= maxLabelNum) continue;
                    this.getModel().setValue("text_" + labelType, (Object)labelBOList.get(index).getName(), rowIndex[index]);
                }
            }
        }
    }

    private boolean checkStdRsmDataStatus() {
        String parentFormId = this.getView().getParentView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"tstpm_candidate_detail", (CharSequence)parentFormId)) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"checkStdRsmDataStatus", (Object[])new Object[]{this.getView().getParentView(), this.getView()});
        }
        return true;
    }
}

