/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import kd.tsc.tsrbd.formplugin.web.label.LabelDefaultShowPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LabelShowPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(LabelDefaultShowPlugin.class);

    public void registerListener(EventObject event) {
        boolean isShowButton = (Boolean)this.getView().getFormShowParameter().getCustomParam("isshowbutton");
        if (isShowButton) {
            this.addClickListeners(new String[]{"addlabelflex", "addlabel", "addlabelvector"});
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        boolean isShowButton = (Boolean)formShowParameter.getCustomParam("isshowbutton");
        List<Object> labelBOList = this.queryLabel(formShowParameter);
        labelBOList = labelBOList.stream().filter(labelBO -> labelBO.getCreateTime() != null).sorted(Comparator.comparing(LabelBO::getCreateTime).reversed()).collect(Collectors.toList());
        FlexPanelAp labelShowPanelAp = this.createLabelShowPanel(labelBOList, isShowButton);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("id", "flexpanelap5");
        paramMap.put("items", labelShowPanelAp.createControl().get("items"));
        args.getItems().add(paramMap);
    }

    public void afterBindData(EventObject event) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isShowButton = (Boolean)formShowParameter.getCustomParam("isshowbutton");
        this.getView().setVisible(isShowButton, new String[]{"addlabelflex"});
        this.reloadLabelData();
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (key.contains("lvector")) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            args.setControl((Control)vector);
        }
    }

    public void click(EventObject evt) {
        if (!this.checkStdRsmDataStatus()) {
            return;
        }
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Long typeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("type"));
        if (key.startsWith("lvector")) {
            LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(typeId));
            labelTagObjServiceHelper.removeById(Long.valueOf(Long.parseLong(key.substring("lvector".length()))));
            this.reloadLabelData();
        } else if ("addlabelflex".equals(key) || "addlabel".equals(key) || "addlabelvector".equals(key)) {
            Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            LabelDataHelper.showAddLabelPage((IFormPlugin)this, (IFormView)this.getView(), Collections.singletonList(id), (Long)typeId, (String)"detail");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"tsrbd_addtag", (CharSequence)actionId) || StringUtils.equals((CharSequence)"tsrbd_edittag", (CharSequence)actionId)) {
            this.reloadLabelData();
        }
        if (this.getView().getParentView() != null) {
            LabelDataHelper.handleCloseCallBack((ClosedCallBackEvent)closedCallBackEvent, (IFormView)this.getView().getParentView());
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private FlexPanelAp createLabelShowPanel(List<LabelBO> labelBOList, boolean showVector) {
        FlexPanelAp labelShowPanelAp = new FlexPanelAp();
        labelShowPanelAp.setKey("labelshowpanel");
        for (LabelBO labelBO : labelBOList) {
            FlexPanelAp completeLabelPanel = this.createCompleteLabelPanel(labelBO, showVector);
            labelShowPanelAp.getItems().add(completeLabelPanel);
        }
        return labelShowPanelAp;
    }

    private List<LabelBO> queryLabel(FormShowParameter formShowParameter) {
        ArrayList pairList;
        Object tagObjIdObj = formShowParameter.getCustomParam("id");
        Long tagObjId = tagObjIdObj == null ? null : Long.valueOf(Long.parseLong(tagObjIdObj.toString()));
        Long tagObjTypeId = Long.parseLong((String)formShowParameter.getCustomParam("type"));
        Pair mainIdTypeId = Pair.of((Object)tagObjTypeId, (Object)tagObjId);
        Object pairListObj = formShowParameter.getCustomParams().get("typeIdList");
        logger.info("queryLabel.pairListObj:{}", pairListObj);
        List excludeLabelTypes = (List)formShowParameter.getCustomParam("excludeCategorys");
        if (pairListObj == null) {
            pairList = Collections.singletonList(mainIdTypeId);
        } else {
            Map pairMap = (Map)pairListObj;
            pairList = Lists.newArrayListWithExpectedSize((int)pairMap.size());
            for (Map.Entry entry : pairMap.entrySet()) {
                pairList.add(Pair.of((Object)Long.valueOf((String)entry.getKey()), (Object)Long.valueOf((String)entry.getValue())));
            }
            pairList.add(mainIdTypeId);
        }
        logger.info("queryLabel.formShowParams:{}", (Object)formShowParameter.getCustomParams());
        Long orgId = RequestContext.get().getOrgId();
        Object orgObject = formShowParameter.getCustomParam("useorg");
        if (orgObject != null) {
            orgId = Long.valueOf(String.valueOf(orgObject));
        }
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        return labelTagObjServiceHelper.batchQuery((List)pairList, orgId, excludeLabelTypes);
    }

    private LabelAp createLabel(String labelName, String labelTagObjId) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label" + labelTagObjId);
        labelAp.setName(new LocaleString(labelName));
        labelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICBtYXgtd2lkdGg6IDk2cHg7XG59In0=");
        return labelAp;
    }

    private VectorAp createVectorByType(String fontclass, String labelTagObjId) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey("lvector" + labelTagObjId);
        vectorAp.setId(labelTagObjId);
        vectorAp.setfontClass(fontclass);
        vectorAp.setForeColor("#FFFFFF");
        vectorAp.setFontSize(7);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("6px");
        style.setMargin(margin);
        vectorAp.setStyle(style);
        if ("".equals(labelTagObjId)) {
            vectorAp.setClickable(false);
            vectorAp.setNeedHoverClass(false);
        }
        return vectorAp;
    }

    private FlexPanelAp createCompleteLabelPanel(LabelBO labelBO, boolean showVector) {
        VectorAp vector;
        boolean isShowVectorOrLabelType;
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setKey("completelabelpanel" + labelBO.getLabelTagObjId());
        String labelType = labelBO.getLabelCategory();
        String fontClass = "";
        switch (labelType) {
            case "A": {
                fontClass = "kdfont kdfont-guanbi6";
                break;
            }
            case "B": {
                fontClass = "kdfont kdfont-guanbi6";
                break;
            }
            case "C": {
                fontClass = "kdfont kdfont-zhinengbiaoqian";
                break;
            }
        }
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setRadius("100px");
        completeLabelPanelAp.setHeight(new LocaleString("18px"));
        completeLabelPanelAp.setForeColor("#666666");
        completeLabelPanelAp.setAlignItems("center");
        completeLabelPanelAp.setAlignContent("center");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("13px");
        margin.setRight("8px");
        Padding padding = new Padding();
        padding.setLeft("6px");
        padding.setRight("6px");
        style.setBorder(this.setBorderStyle());
        style.setMargin(margin);
        style.setPadding(padding);
        completeLabelPanelAp.setStyle(style);
        String idStr = String.valueOf(labelBO.getLabelTagObjId());
        LabelAp label = this.createLabel(labelBO.getName(), idStr);
        completeLabelPanelAp.getItems().add(label);
        boolean bl = isShowVectorOrLabelType = showVector && ("B".equals(labelType) || "A".equals(labelType));
        if (isShowVectorOrLabelType) {
            vector = this.createVectorByType(fontClass, idStr);
            completeLabelPanelAp.getItems().add(vector);
        }
        if ("C".equals(labelType)) {
            vector = this.createVectorByType(fontClass, "");
            completeLabelPanelAp.getItems().add(vector);
        }
        return completeLabelPanelAp;
    }

    private Border setBorderStyle() {
        Border border = new Border();
        border.setBottom("1px_solid_#666666");
        border.setLeft("1px_solid_#666666");
        border.setRight("1px_solid_#666666");
        border.setTop("1px_solid_#666666");
        return border;
    }

    private void reloadLabelData() {
        HashMap paramMap = Maps.newHashMap();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean isShowButton = (Boolean)formShowParameter.getCustomParam("isshowbutton");
        List<Object> labelBOList = this.queryLabel(this.getView().getFormShowParameter());
        labelBOList = labelBOList.stream().filter(labelBO -> labelBO.getCreateTime() != null).sorted(Comparator.comparing(LabelBO::getCreateTime).reversed()).collect(Collectors.toList());
        paramMap.put("items", this.createLabelShowPanel(labelBOList, isShowButton).createControl().get("items"));
        this.getView().updateControlMetadata("flexpanelap5", (Map)paramMap);
    }

    private boolean checkStdRsmDataStatus() {
        String parentFormId = this.getView().getParentView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"tstpm_candidate_detail", (CharSequence)parentFormId)) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"checkStdRsmDataStatus", (Object[])new Object[]{this.getView().getParentView(), this.getView()});
        }
        return true;
    }
}

