/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;

public class LabelShowPopPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    public void registerListener(EventObject event) {
        this.addClickListeners(new String[]{"deletepersonallabel", "deletecommonlabel"});
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String labelStr = this.getModel().getValue("text_labeltype") + "";
        int maxShowLabelNum = "mylabel".equals(labelStr) ? 2 : 3;
        String labelListStr = this.getView().getParentView().getPageCache().get("label_" + labelStr);
        List labelBOList = (List)SerializationUtils.fromJsonString((String)labelListStr, List.class);
        this.getModel().deleteEntryData("entryentity_morelabel");
        FormShowParameter formShowParameter = this.getView().getParentView().getFormShowParameter();
        Boolean isShowEditBtn = (Boolean)formShowParameter.getCustomParam("isCanEditLabel");
        if (isShowEditBtn != null && !isShowEditBtn.booleanValue()) {
            this.getModel().setValue("ishidedeletelabel", (Object)"true");
        }
        Map<String, List<Map>> groupMap = labelBOList.stream().collect(Collectors.groupingBy(stringStringMap -> (String)stringStringMap.get("labelCategory")));
        for (Map.Entry<String, List<Map>> labelMap : groupMap.entrySet()) {
            int index;
            int[] entitySize;
            List<Map> labelMapValue;
            if ("A".equals(labelMap.getKey())) {
                labelMapValue = labelMap.getValue();
                entitySize = this.getModel().batchCreateNewEntryRow("entryentity_morelabel", labelMapValue.size());
                for (index = 0; index < labelMapValue.size(); ++index) {
                    this.getModel().setValue("labelid", labelMapValue.get(index).get("id"), entitySize[index]);
                    this.getModel().setValue("text_label", labelMapValue.get(index).get("name"), entitySize[index]);
                }
                continue;
            }
            labelMapValue = labelMap.getValue();
            entitySize = this.getModel().batchCreateNewEntryRow("entryentity_commonlabel", labelMapValue.size());
            for (index = 0; index < labelMapValue.size(); ++index) {
                this.getModel().setValue("commonlabelid", labelMapValue.get(index).get("id"), entitySize[index]);
                this.getModel().setValue("text_commonlabel", labelMapValue.get(index).get("name"), entitySize[index]);
            }
        }
        DynamicObjectCollection entryentity_morelabel = this.getModel().getEntryEntity("entryentity_morelabel");
        int personalLabelSize = entryentity_morelabel.size();
        this.getView().setVisible(Boolean.valueOf(personalLabelSize > 0), new String[]{"personallabeltag"});
        DynamicObjectCollection entryentity_commonlabel = this.getModel().getEntryEntity("entryentity_commonlabel");
        int commonLabelSize = entryentity_commonlabel.size();
        this.getView().setVisible(Boolean.valueOf(commonLabelSize > 0), new String[]{"commonlabeltag"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("deletepersonallabel".equals(key) || "deletecommonlabel".equals(key)) {
            this.deleteLabel(key);
        }
    }

    private void deleteLabel(String entryKey) {
        FormShowParameter formShowParameter = this.getView().getParentView().getFormShowParameter();
        Boolean isShowEditBtn = (Boolean)formShowParameter.getCustomParam("isCanEditLabel");
        if (isShowEditBtn == null || !isShowEditBtn.booleanValue()) {
            return;
        }
        Long labelId = null;
        if ("deletepersonallabel".equals(entryKey)) {
            labelId = Long.parseLong(this.getView().getModel().getValue("labelid") + "");
        } else if ("deletecommonlabel".equals(entryKey)) {
            labelId = Long.parseLong(this.getView().getModel().getValue("commonlabelid") + "");
        }
        Long tagObjTypeId = Long.parseLong((String)formShowParameter.getCustomParam("type"));
        Long tagObjId = (Long)formShowParameter.getCustomParam("id");
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        Boolean removeSucess = labelTagObjServiceHelper.remove(tagObjTypeId, tagObjId, labelId);
        if (removeSucess.booleanValue()) {
            String labelStr = this.getModel().getValue("text_labeltype") + "";
            String labelListStr = this.getView().getParentView().getPageCache().get("label_" + labelStr);
            List labelBOList = (List)SerializationUtils.fromJsonString((String)labelListStr, List.class);
            Iterator iterable = labelBOList.iterator();
            while (iterable.hasNext()) {
                Map labelMap = (Map)iterable.next();
                if (!labelMap.get("id").toString().equals(String.valueOf(labelId))) continue;
                iterable.remove();
            }
            this.getView().getParentView().getPageCache().put("label_" + labelStr, SerializationUtils.toJsonString((Object)labelBOList));
            this.getView().invokeOperation("refresh");
            this.getPageCache().put("isDelete", "true");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        String isDelete = this.getPageCache().get("isDelete");
        if (Boolean.parseBoolean(isDelete)) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

