/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.label.service.LabelServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbd.formplugin.web.label.utils.LabelPluginUtils;
import org.apache.commons.collections.CollectionUtils;

public class PublicLabelEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_CONFIRM_UPDATE_LABEL = "updateLabel";
    private static final String TSC_TSRBS_FORMPLUGIN = "tsc-tsrbs-formplugin";

    public void beforeBindData(EventObject event) {
        LabelPluginUtils.setTitle((Label)this.getView().getControl("viewtitle"), this.getView().getFormShowParameter(), this.getModel());
    }

    public void afterCreateNewData(EventObject event) {
        LabelPluginUtils.setTagObjDefaultValue(this.getModel().getDataEntity(), "1020_S");
    }

    public void afterBindData(EventObject event) {
        if (this.getView().getFormShowParameter().getStatus().getValue() != OperationStatus.EDIT.getValue()) {
            this.getModel().setValue("ctrlstrategy", (Object)"5");
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.equalsIgnoreCase("save")) {
            int operationStatus = this.getView().getFormShowParameter().getStatus().getValue();
            if (operationStatus == OperationStatus.EDIT.getValue()) {
                this.doEditOperation(args, dataEntity);
            }
            if (operationStatus == OperationStatus.ADDNEW.getValue()) {
                this.doAddOperation(args, dataEntity);
            }
        }
    }

    private void doAddOperation(BeforeDoOperationEventArgs args, DynamicObject dataEntity) {
        if (this.checkName(args, dataEntity)) {
            return;
        }
        DynamicObject[] dynamicObjects = LabelServiceHelper.getInstance().getPublicLabels(dataEntity.getString("name"));
        if (dynamicObjects.length > 0) {
            args.setCancel(true);
            DynamicObject dbCreateOrg = dynamicObjects[0].getDynamicObject("createorg");
            String dbNumber = dynamicObjects[0].getString("number");
            IHRAppCache appCache = HRAppCache.get((String)"tsc");
            Set useOrgIds = (Set)appCache.get("app_key_tsc_tsrbd_public_label_use_orgs" + TSCRequestContext.getUserId(), Set.class);
            if (CollectionUtils.isEmpty((Collection)useOrgIds) || !useOrgIds.contains(dbCreateOrg.getString("id"))) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e0e%s\u516c\u5171\u6807\u7b7e\u91cd\u540d\uff0c\u8bf7\u8054\u7cfb%s\u7ba1\u7406\u5458\u53d8\u66f4", (String)"PublicLabelEdit_1", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]), dbNumber, dynamicObjects[0].getDynamicObject("createorg").getString("name"));
                this.getView().showMessage(msg);
            }
        }
    }

    private void doEditOperation(BeforeDoOperationEventArgs args, DynamicObject dataEntity) {
        Long id = dataEntity.getLong("id");
        String selectProperties = String.join((CharSequence)",", "ctrlstrategy", "name");
        DynamicObject original = LabelServiceHelper.getInstance().queryOriginalOne(selectProperties, id);
        if (!HRStringUtils.equals((String)original.getString("name"), (String)dataEntity.getString("name")) && this.checkName(args, dataEntity)) {
            return;
        }
        if (!HRStringUtils.equals((String)original.getString("ctrlstrategy"), (String)dataEntity.getString("ctrlstrategy"))) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_CONFIRM_UPDATE_LABEL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u5c06\u4f1a\u5f71\u54cd\u57fa\u7840\u8d44\u6599\u7684\u4f7f\u7528\uff0c\u8bf7\u614e\u91cd\uff01\u786e\u8ba4\u8981\u53d8\u66f4\u5417\uff1f", (String)"PublicLabelEdit_4", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    private boolean checkName(BeforeDoOperationEventArgs args, DynamicObject dataEntity) {
        DynamicObject[] dynamicObjects = LabelServiceHelper.getInstance().getPublicLabels(dataEntity.getString("name"));
        if (dynamicObjects.length > 0) {
            args.setCancel(true);
            DynamicObject dbCreateOrg = dynamicObjects[0].getDynamicObject("createorg");
            IHRAppCache appCache = HRAppCache.get((String)"tsc");
            Set useOrgIds = (Set)appCache.get("app_key_tsc_tsrbd_public_label_use_orgs" + TSCRequestContext.getUserId(), Set.class);
            if (CollectionUtils.isNotEmpty((Collection)useOrgIds) && useOrgIds.contains(dbCreateOrg.getString("id"))) {
                FieldTip tip = LabelServiceHelper.getInstance().getFieldTip();
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IndividualLabelEdit_0", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        MulBasedataEdit tagObjType = (MulBasedataEdit)this.getView().getControl("tagobjtype");
        if (null != tagObjType) {
            tagObjType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String property = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"tagobjtype", (String)property)) {
            QFilter qFilter = new QFilter("labeltype", "like", (Object)"%B%");
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u6807\u8bb0\u5bf9\u8c61", (String)"IndividualLabelList_3", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (HRStringUtils.equals((String)KEY_CONFIRM_UPDATE_LABEL, (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }
}

