/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelEditConstants;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import kd.tsc.tsrbd.formplugin.web.label.AddTagPlugin;
import org.apache.commons.lang3.StringUtils;

public class RemoveTagPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String PAGE_CACHETAGS_KEY = "tagsCache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Button submit = (Button)this.getControl("clearbtn");
        submit.addClickListener((ClickListener)this);
        Label clearselectlabel = (Label)this.getControl("clearselectlabel");
        clearselectlabel.addClickListener((ClickListener)this);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        if (HRStringUtils.isNotEmpty((String)searchText)) {
            this.searchEnter(searchText);
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchtags"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"personalhistorytags", "commonhistorytags"});
        }
        return Collections.emptyList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"searchtags"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initDate();
        this.hideLabelSelectBox();
    }

    private void hideLabelSelectBox() {
        int perSelectLabelNum = Integer.parseInt(this.getModel().getValue("personalselectednum") + "");
        int commSelectLabelNum = Integer.parseInt(this.getModel().getValue("commonselectednum") + "");
        if (perSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personalselecttag"});
        }
        if (commSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonselecttag"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"tag-")) {
            this.clickTag(key);
        } else if (HRStringUtils.equals((String)key, (String)"clearbtn")) {
            String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
            Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
            ArrayList<Long> tagsId = new ArrayList<Long>();
            for (Map tagData : (ArrayList)tagsMap.get("personalselected")) {
                tagsId.add(Long.parseLong((String)tagData.get("id")));
            }
            for (Map tagData : (ArrayList)tagsMap.get("commonselected")) {
                tagsId.add(Long.parseLong((String)tagData.get("id")));
            }
            if (tagsId.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u7684\u6807\u7b7e\u3002", (String)"AddTagPlugin_7", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long tagObjTypeId = Long.parseLong(customParams.get("tagObjTypeId") + "");
            List tagObjList = (List)customParams.get("tagObjList");
            LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
            Boolean isRemove = labelTagObjServiceHelper.batchRemove(tagObjTypeId, tagObjList, tagsId).getSuccess();
            if (isRemove.booleanValue()) {
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
        } else if (HRStringUtils.equals((String)key, (String)"clearselectlabel")) {
            String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
            Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
            ArrayList personalSelectLabelMap = (ArrayList)tagsMap.get("personalselected");
            ArrayList commonSelectLabelMap = (ArrayList)tagsMap.get("commonselected");
            for (Map labelMap : personalSelectLabelMap) {
                this.clickTag("tag-personalselected-" + (String)labelMap.get("id"));
            }
            for (Map labelMap : commonSelectLabelMap) {
                this.clickTag("tag-commonselected-" + (String)labelMap.get("id"));
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String labelName = e.getKey();
        if (HRStringUtils.startsWithIgnoreCase((String)labelName, (String)"tag-")) {
            Label tagLabel = new Label();
            tagLabel.setKey(labelName);
            tagLabel.setView(this.getView());
            tagLabel.addClickListener((ClickListener)this);
            e.setControl((Control)tagLabel);
        }
    }

    private void initDate() {
        HashMap tagsMap = Maps.newHashMapWithExpectedSize((int)LabelEditConstants.NUM_3);
        tagsMap.put("personalhistory", new ArrayList());
        tagsMap.put("commonhistory", new ArrayList());
        tagsMap.put("search", new ArrayList());
        tagsMap.put("personalselected", new ArrayList());
        tagsMap.put("commonselected", new ArrayList());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long tagObjTypeId = Long.parseLong(customParams.get("tagObjTypeId") + "");
        List tagObjList = (List)customParams.get("tagObjList");
        String pageType = customParams.get("pagetype") + "";
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        if (HRStringUtils.equals((String)pageType, (String)"list")) {
            List labelBos = labelTagObjServiceHelper.batchQueryIlPl(tagObjTypeId, tagObjList, Long.valueOf(RequestContext.get().getOrgId()));
            labelBos.sort(new Comparator<LabelBO>(){

                @Override
                public int compare(LabelBO o1, LabelBO o2) {
                    return o2.getLabelCategory().charAt(0) - o1.getLabelCategory().charAt(0);
                }
            });
            this.initLabelContent(labelBos, tagsMap, AddTagPlugin.OperationArea.HISTORY_LABEL);
        }
        this.getPageCache().put(PAGE_CACHETAGS_KEY, SerializationUtils.toJsonString((Object)tagsMap));
    }

    private void searchEnter(String searchText) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"searchtags"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"personalhistorytags", "commonhistorytags"});
        String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
        if (StringUtils.isEmpty((CharSequence)Tags)) {
            return;
        }
        Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
        ArrayList<Map> searchTags = new ArrayList<Map>(16);
        ArrayList personalLabelMap = (ArrayList)tagsMap.get("personalhistory");
        ArrayList commonLabelMap = (ArrayList)tagsMap.get("commonhistory");
        if (tagsMap != null) {
            searchTags = (ArrayList<Map>)tagsMap.get("search");
            for (Map tag : searchTags) {
                this.deleteTag("search", this.joinTagKey((String)tag.get("id"), "search"));
            }
            searchTags = new ArrayList<Map>();
        }
        int labelSize = personalLabelMap.size() + commonLabelMap.size();
        this.updataTagNum("search", labelSize);
        ArrayList allLabelMap = new ArrayList(labelSize);
        allLabelMap.addAll(personalLabelMap);
        allLabelMap.addAll(commonLabelMap);
        for (Map labelMap : allLabelMap) {
            if (HRStringUtils.indexOfIgnoreCase((String)((String)labelMap.get("name")), (String)searchText) == -1) continue;
            searchTags.add(labelMap);
            this.addTag("search", this.joinTagKey((String)labelMap.get("id") + "", "search"), (String)labelMap.get("name") + "", false);
            if (tagsMap != null && this.haveTagInTags((ArrayList)tagsMap.get("personalselected"), (String)labelMap.get("id") + "").booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey((String)labelMap.get("id") + "", "search")});
                this.calcTagNum("search", "-");
            }
            if (tagsMap == null || !this.haveTagInTags((ArrayList)tagsMap.get("commonselected"), (String)labelMap.get("id") + "").booleanValue()) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey((String)labelMap.get("id") + "", "search")});
            this.calcTagNum("search", "-");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"searchtitle"});
        if (searchTags.size() == 0) {
            this.getModel().setValue("searchtips", (Object)ResManager.loadKDString((String)"\u65e0\u641c\u7d22\u7ed3\u679c", (String)"RemoveTagPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"searchtips"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchtips"});
        }
        if (tagsMap != null) {
            tagsMap.put("search", searchTags);
        }
        this.getPageCache().put(PAGE_CACHETAGS_KEY, SerializationUtils.toJsonString((Object)tagsMap));
    }

    private void initLabelContent(List<LabelBO> labelBoList, Map<String, ArrayList<Map<String, String>>> tagsMap, AddTagPlugin.OperationArea operationArea) {
        Map<String, List<LabelBO>> labelMap = labelBoList.stream().collect(Collectors.groupingBy(LabelBO::getLabelCategory));
        for (Map.Entry<String, List<LabelBO>> labelEntry : labelMap.entrySet()) {
            this.initLabelDetail(labelEntry, tagsMap, operationArea);
        }
        this.checkLabelData(labelMap, operationArea);
    }

    private void checkLabelData(Map<String, List<LabelBO>> labelMap, AddTagPlugin.OperationArea operationArea) {
        if (operationArea != AddTagPlugin.OperationArea.HISTORY_LABEL) {
            return;
        }
        List<LabelBO> personalLabelList = labelMap.get("A");
        List<LabelBO> commonLabelList = labelMap.get("B");
        if (personalLabelList == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personalhistorytips", "personalhistorytipsbox"});
            this.getModel().setValue("personalhistorytips", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u79fb\u9664\u6807\u7b7e", (String)"RemoveTagPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"personhistoryallselecttip"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personalhistorytips", "personalhistorytipsbox"});
        }
        if (commonLabelList == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"commonhistorytips", "commonhistorytipsbox"});
            this.getModel().setValue("commonhistorytips", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u79fb\u9664\u6807\u7b7e", (String)"RemoveTagPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonhistoryallselecttip"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonhistorytips", "commonhistorytipsbox"});
        }
    }

    private void initLabelDetail(Map.Entry<String, List<LabelBO>> labelEntry, Map<String, ArrayList<Map<String, String>>> tagsMap, AddTagPlugin.OperationArea operationArea) {
        String labelType = labelEntry.getKey();
        int lengthSize = labelEntry.getValue().size();
        ArrayList<Map<String, String>> labelTags = new ArrayList<Map<String, String>>(lengthSize);
        this.initHistoryNum(labelType, lengthSize, operationArea);
        for (LabelBO labelBo : labelEntry.getValue()) {
            HashMap tagData = Maps.newHashMapWithExpectedSize((int)4);
            tagData.put("id", labelBo.getId() + "");
            tagData.put("name", labelBo.getName());
            tagData.put("type", labelBo.getLabelCategory());
            labelTags.add(tagData);
            this.initLabelClassify(labelType, labelBo, operationArea);
            this.checkLabelHasSelect(labelType, tagsMap, labelBo, operationArea);
        }
        this.setAllLabelMap(labelTags, tagsMap, labelType, operationArea);
    }

    private void initHistoryNum(String labelType, int lengthSize, AddTagPlugin.OperationArea operationArea) {
        if (AddTagPlugin.OperationArea.HISTORY_LABEL != operationArea) {
            return;
        }
        if ("A".equals(labelType)) {
            this.updataTagNum("personalhistory", lengthSize);
        } else if ("B".equals(labelType)) {
            this.updataTagNum("commonhistory", lengthSize);
        }
    }

    private void setAllLabelMap(ArrayList<Map<String, String>> labelTags, Map<String, ArrayList<Map<String, String>>> tagsMap, String labelType, AddTagPlugin.OperationArea operationArea) {
        switch (operationArea) {
            case HISTORY_LABEL: {
                this.setHistoryLabelMap(labelTags, tagsMap, labelType);
                break;
            }
            case SELECTED_LABEL: {
                this.setSelectedLabelMap(labelTags, tagsMap, labelType);
                break;
            }
        }
    }

    private void setSelectedLabelMap(ArrayList<Map<String, String>> labelTags, Map<String, ArrayList<Map<String, String>>> tagsMap, String labelType) {
        int selectLabelNum = Integer.parseInt(Optional.of(this.getModel().getValue("selectednum") + "").orElse("0"));
        this.updataTagNum("personalselected", selectLabelNum + labelTags.size());
        if ("A".equals(labelType)) {
            tagsMap.put("personalselected", labelTags);
        } else if ("B".equals(labelType)) {
            tagsMap.put("commonselected", labelTags);
        }
    }

    private void setHistoryLabelMap(ArrayList<Map<String, String>> historyTags, Map<String, ArrayList<Map<String, String>>> tagsMap, String labelType) {
        if ("A".equals(labelType)) {
            tagsMap.put("personalhistory", historyTags);
        } else if ("B".equals(labelType)) {
            tagsMap.put("commonhistory", historyTags);
        }
    }

    private void checkLabelHasSelect(String labelType, Map<String, ArrayList<Map<String, String>>> tagsMap, LabelBO labelBo, AddTagPlugin.OperationArea operationArea) {
        if (operationArea != AddTagPlugin.OperationArea.HISTORY_LABEL) {
            return;
        }
        if ("A".equals(labelType) && this.haveTagInTags(tagsMap.get("personalselected"), labelBo.getId() + "").booleanValue()) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "personalhistory");
            this.getView().setVisible(Boolean.FALSE, new String[]{tagId});
            this.calcTagNum("personalhistory", "-");
        } else if ("B".equals(labelType) && this.haveTagInTags(tagsMap.get("commonselected"), labelBo.getId() + "").booleanValue()) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "commonhistory");
            this.getView().setVisible(Boolean.FALSE, new String[]{tagId});
            this.calcTagNum("commonhistory", "-");
        }
    }

    private void calcTagNum(String type, String mode) {
        int reNum = HRStringUtils.equals((String)mode, (String)"-") ? new BigDecimal(this.getModel().getValue(type + "num").toString()).subtract(new BigDecimal(1)).intValue() : new BigDecimal(this.getModel().getValue(type + "num").toString()).add(new BigDecimal(1)).intValue();
        this.updataTagNum(type, reNum);
    }

    private void updataTagNum(String type, int num) {
        if (HRStringUtils.equals((String)type, (String)"personalselected")) {
            this.getModel().setValue("selectednum", (Object)num);
            String string = this.getView().getFormShowParameter().getCustomParam("pagetype") + "";
        } else if (HRStringUtils.equals((String)type, (String)"search")) {
            if (num == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"searchallselecttip"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"searchallselecttip"});
            }
            this.getModel().setValue("searchnum", (Object)num);
        } else if (HRStringUtils.equals((String)type, (String)"commonhistory")) {
            if (num == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"commonhistoryallselecttip"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"commonhistoryallselecttip"});
            }
            this.getModel().setValue("commonhistorynum", (Object)num);
        } else {
            if (num == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"personhistoryallselecttip"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"personhistoryallselecttip"});
            }
            this.getModel().setValue("personalhistorynum", (Object)num);
        }
    }

    private void initLabelClassify(String labelType, LabelBO labelBo, AddTagPlugin.OperationArea operationArea) {
        switch (operationArea) {
            case HISTORY_LABEL: {
                this.initHistoryLabelClassify(labelType, labelBo);
                break;
            }
            case SELECTED_LABEL: {
                this.initSelectedLabelClassify(labelType, labelBo);
                break;
            }
        }
    }

    private void initSelectedLabelClassify(String labelType, LabelBO labelBo) {
        int perSelectLabelNum = Integer.parseInt(this.getModel().getValue("personalselectednum") + "");
        int commSelectLabelNum = Integer.parseInt(this.getModel().getValue("commonselectednum") + "");
        if ("A".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "personalselected");
            this.addTag("personalselected", tagId, labelBo.getName(), false);
            this.getModel().setValue("personalselectednum", (Object)String.valueOf(++perSelectLabelNum));
        } else if ("B".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "commonselected");
            this.addTag("commonselected", tagId, labelBo.getName(), false);
            this.getModel().setValue("commonselectednum", (Object)String.valueOf(++commSelectLabelNum));
        }
    }

    private void initHistoryLabelClassify(String labelType, LabelBO labelBo) {
        if ("A".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "personalhistory");
            this.addTag("personalhistory", tagId, labelBo.getName(), false);
        } else if ("B".equals(labelType)) {
            String tagId = this.joinTagKey(labelBo.getId() + "", "commonhistory");
            this.addTag("commonhistory", tagId, labelBo.getName(), false);
        }
    }

    private Boolean haveTagInTags(ArrayList<Map<String, String>> list, String tagId) {
        Boolean bool = Boolean.FALSE;
        for (Map<String, String> tagData : list) {
            if (!HRStringUtils.equals((String)tagData.get("id"), (String)tagId)) continue;
            bool = Boolean.TRUE;
        }
        return bool;
    }

    private void searchEnterOp(String searchText) {
        this.getModel().setValue("resultstate", (Object)"search");
        String Tags = this.getPageCache().get("personalhistorytags");
        ArrayList initTags = (ArrayList)SerializationUtils.fromJsonString((String)Tags, ArrayList.class);
        for (Map tagData : initTags) {
            if (HRStringUtils.indexOfIgnoreCase((String)((String)tagData.get("name")), (String)searchText) != -1) {
                tagData.put("isSearch", "1");
                if (!HRStringUtils.equals((String)((String)tagData.get("isSelected")), (String)"0")) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey((String)tagData.get("id"), "init")});
                continue;
            }
            tagData.put("isSearch", "0");
            this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey((String)tagData.get("id"), "init")});
        }
        this.updataTagNumTips(initTags);
        this.getPageCache().put("personalhistorytags", SerializationUtils.toJsonString((Object)initTags));
    }

    private void clickTag(String key) {
        String tagId = this.splitTagKey(key)[LabelEditConstants.NUM_2];
        String origin = this.splitTagKey(key)[LabelEditConstants.NUM_1];
        String Tags = this.getPageCache().get(PAGE_CACHETAGS_KEY);
        Map tagsMap = (Map)SerializationUtils.fromJsonString((String)Tags, Map.class);
        int perSelectLabelNum = Integer.parseInt(this.getModel().getValue("personalselectednum") + "");
        int commSelectLabelNum = Integer.parseInt(this.getModel().getValue("commonselectednum") + "");
        if (HRStringUtils.equals((String)origin, (String)"personalhistory")) {
            Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("personalhistory"), tagId);
            ((ArrayList)tagsMap.get("personalselected")).add(tagDate);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.calcTagNum("personalhistory", "-");
            this.addTag("personalselected", this.joinTagKey(tagId, "personalselected"), tagDate.get("name"), true);
            ++perSelectLabelNum;
            this.getModel().setValue("personalselectednum", (Object)String.valueOf(perSelectLabelNum));
        } else if (HRStringUtils.equals((String)origin, (String)"commonhistory")) {
            Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("commonhistory"), tagId);
            ((ArrayList)tagsMap.get("commonselected")).add(tagDate);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.calcTagNum("commonhistory", "-");
            this.addTag("commonselected", this.joinTagKey(tagId, "commonselected"), tagDate.get("name"), true);
            ++commSelectLabelNum;
            this.getModel().setValue("commonselectednum", (Object)String.valueOf(commSelectLabelNum));
        } else if (HRStringUtils.equals((String)origin, (String)"search")) {
            Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("search"), tagId);
            String labelType = tagDate.get("type");
            String selectKey = this.getSelectLabelType(labelType);
            String historyKey = this.getHistoryLabelType(labelType);
            String selectNumKey = this.getSelectLabelNum(labelType);
            int selectLabelNum = "A".equals(labelType) ? (perSelectLabelNum = ++perSelectLabelNum) : (commSelectLabelNum = ++commSelectLabelNum);
            this.getModel().setValue(selectNumKey, (Object)String.valueOf(selectLabelNum));
            ((ArrayList)tagsMap.get(selectKey)).add(tagDate);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.calcTagNum("search", "-");
            this.addTag(selectKey, this.joinTagKey(tagId, selectKey), tagDate.get("name"), true);
            if (this.haveTagInTags((ArrayList)tagsMap.get(historyKey), tagId).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.joinTagKey(tagId, historyKey)});
                this.calcTagNum(historyKey, "-");
            }
        } else {
            boolean hasSubtract = false;
            if (this.haveTagInTags((ArrayList)tagsMap.get("personalhistory"), tagId).booleanValue()) {
                this.deleteTag("personalselected", key);
                ((ArrayList)tagsMap.get("personalselected")).remove(this.getTagDataForList((ArrayList)tagsMap.get("personalselected"), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "personalhistory")});
                this.calcTagNum("personalhistory", "+");
                --perSelectLabelNum;
                this.getModel().setValue("personalselectednum", (Object)String.valueOf(perSelectLabelNum));
                hasSubtract = true;
            }
            if (this.haveTagInTags((ArrayList)tagsMap.get("commonhistory"), tagId).booleanValue()) {
                this.deleteTag("commonselected", key);
                ((ArrayList)tagsMap.get("commonselected")).remove(this.getTagDataForList((ArrayList)tagsMap.get("commonselected"), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "commonhistory")});
                this.calcTagNum("commonhistory", "+");
                --commSelectLabelNum;
                this.getModel().setValue("commonselectednum", (Object)String.valueOf(commSelectLabelNum));
                hasSubtract = true;
            }
            if (this.haveTagInTags((ArrayList)tagsMap.get("search"), tagId).booleanValue()) {
                Map<String, String> tagDate = this.getTagDataForList((ArrayList)tagsMap.get("search"), tagId);
                String labelType = tagDate.get("type");
                String selectKey = this.getSelectLabelType(labelType);
                this.deleteTag(selectKey, key);
                ((ArrayList)tagsMap.get(selectKey)).remove(this.getTagDataForList((ArrayList)tagsMap.get(selectKey), tagId));
                this.getView().setVisible(Boolean.TRUE, new String[]{this.joinTagKey(tagId, "search")});
                this.calcTagNum("search", "+");
                if (!hasSubtract) {
                    String selectNumKey = this.getSelectLabelNum(labelType);
                    int selectLabelNum = "A".equals(labelType) ? (perSelectLabelNum = --perSelectLabelNum) : (commSelectLabelNum = --commSelectLabelNum);
                    this.getModel().setValue(selectNumKey, (Object)String.valueOf(selectLabelNum));
                }
            }
        }
        this.showOrSelectLabelTag(perSelectLabelNum, commSelectLabelNum);
        int size = ((ArrayList)tagsMap.get("personalselected")).size() + ((ArrayList)tagsMap.get("commonselected")).size();
        this.updataTagNum("personalselected", size);
        this.getPageCache().put(PAGE_CACHETAGS_KEY, SerializationUtils.toJsonString((Object)tagsMap));
    }

    private String getSelectLabelNum(String labelType) {
        if ("A".equals(labelType)) {
            return "personalselectednum";
        }
        if ("B".equals(labelType)) {
            return "commonselectednum";
        }
        return "";
    }

    private String getHistoryLabelType(String labelType) {
        if ("A".equals(labelType)) {
            return "personalhistory";
        }
        if ("B".equals(labelType)) {
            return "commonhistory";
        }
        return "";
    }

    private String getSelectLabelType(String labelType) {
        if ("A".equals(labelType)) {
            return "personalselected";
        }
        if ("B".equals(labelType)) {
            return "commonselected";
        }
        return "";
    }

    private void showOrSelectLabelTag(int perSelectLabelNum, int commSelectLabelNum) {
        if (perSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personalselecttag"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personalselecttag"});
        }
        if (commSelectLabelNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commonselecttag"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"commonselecttag"});
        }
    }

    private void deleteTag(String flexId, String tagKey) {
        Container flexpanelap = (Container)this.getView().getControl(flexId);
        flexpanelap.deleteControls(new String[]{tagKey});
    }

    private void addTag(String flexId, String tagId, String name, boolean isShowDeleteVector) {
        Container flexpanelap = (Container)this.getView().getControl(flexId);
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setKey(tagId);
        this.addClickListeners(new String[]{tagId});
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setClickable(true);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setForeColor("#666666");
        Style style = new Style();
        style.setBorder(this.setBorderStyle());
        completeLabelPanelAp.setStyle(style);
        ArrayList<Map> listitem = new ArrayList<Map>();
        LabelAp title = new LabelAp();
        title.setKey(tagId);
        title.setName(new LocaleString(name));
        title.setClickable(true);
        title.setForeColor("#666666");
        title.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICBtYXgtd2lkdGg6IDk2cHg7XG59In0=");
        this.addClickListeners(new String[]{title.getKey()});
        completeLabelPanelAp.getItems().add(title);
        if (isShowDeleteVector) {
            VectorAp vectorAp = this.createVectorByType(tagId);
            completeLabelPanelAp.getItems().add(vectorAp);
        }
        listitem.add(completeLabelPanelAp.createControl());
        flexpanelap.addControls(listitem);
    }

    private VectorAp createVectorByType(String labelTagObjId) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey("lvector" + labelTagObjId);
        vectorAp.setId(labelTagObjId);
        vectorAp.setfontClass("kdfont kdfont-guanbi8");
        vectorAp.setForeColor("#666666");
        vectorAp.setClickable(false);
        vectorAp.setFontSize(7);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("2px");
        style.setMargin(margin);
        vectorAp.setStyle(style);
        return vectorAp;
    }

    private Border setBorderStyle() {
        Border border = new Border();
        border.setBottom("1px_solid_#666666");
        border.setLeft("1px_solid_#666666");
        border.setRight("1px_solid_#666666");
        border.setTop("1px_solid_#666666");
        return border;
    }

    private String joinTagKey(String key, String origin) {
        return "tag-" + origin + "-" + key;
    }

    private String[] splitTagKey(String key) {
        return key.split("-");
    }

    private Map<String, String> getTagDataForList(ArrayList<Map<String, String>> list, String tagId) {
        Map<String, String> tag = new HashMap<String, String>(16);
        for (Map<String, String> tagData : list) {
            if (!HRStringUtils.equals((String)tagData.get("id"), (String)tagId)) continue;
            tag = tagData;
        }
        return tag;
    }

    private void updataTagNumTips(ArrayList<Map<String, String>> list) {
        int selectedSize = 0;
        int searchSize = 0;
        int selectedSearchSize = 0;
        for (Map<String, String> tagData : list) {
            if (HRStringUtils.equals((String)tagData.get("isSelected"), (String)"1")) {
                ++selectedSize;
                if (HRStringUtils.equals((String)tagData.get("isSearch"), (String)"1")) {
                    ++selectedSearchSize;
                }
            }
            if (!HRStringUtils.equals((String)tagData.get("isSearch"), (String)"1")) continue;
            ++searchSize;
        }
        this.getModel().setValue("selectednum", (Object)selectedSize);
        this.updataCopywriteTips(list, selectedSize, searchSize, selectedSearchSize);
    }

    private void updataCopywriteTips(ArrayList<Map<String, String>> list, int selectedSize, int searchSize, int selectedSearchSize) {
        String resultState = this.getModel().getValue("resultstate") + "";
        String tipText = HRStringUtils.equals((String)resultState, (String)"init") ? this.updataCopywriteTipsInit(list, selectedSize) : this.updataCopywriteTipsSearch(searchSize, selectedSearchSize);
        if (HRStringUtils.equals((String)tipText, (String)"")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchtipflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"searchtipflex"});
        }
        this.getModel().setValue("searchtips", (Object)tipText);
    }

    private String updataCopywriteTipsInit(ArrayList<Map<String, String>> list, int selectedSize) {
        String tipText = list.size() == 0 ? ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u79fb\u9664\u6807\u7b7e", (String)"RemoveTagPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]) : (selectedSize == list.size() ? ResManager.loadKDString((String)"\u5168\u90e8\u5df2\u9009", (String)"RemoveTagPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]) : "");
        return tipText;
    }

    private String updataCopywriteTipsSearch(int searchSize, int selectedSearchSize) {
        String tipText = searchSize == 0 ? ResManager.loadKDString((String)"\u65e0\u641c\u7d22\u7ed3\u679c", (String)"RemoveTagPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]) : (searchSize == selectedSearchSize ? ResManager.loadKDString((String)"\u641c\u7d22\u7ed3\u679c\u5168\u90e8\u5df2\u9009", (String)"RemoveTagPlugin_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]) : "");
        return tipText;
    }
}

