/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.label.utils;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class LabelPluginUtils {
    private static final String CAPTION_TAG_OBJECT = "\u6807\u8bb0\u5bf9\u8c61";
    private static final String ALGO_KEY = "LabelPluginUtils.getTagObjectCommonFilterColumn#tsrbs_tagobjtype";
    private static final String SELECT_FIELDS = "id,number,name";

    private LabelPluginUtils() {
        throw new IllegalStateException("LabelPluginUtils class");
    }

    @NotNull
    public static CommonFilterColumn getTagObjectCommonFilterColumn(String labelType) {
        CommonFilterColumn tagObjectColumn = new CommonFilterColumn("tagobjtype");
        tagObjectColumn.setCaption(new LocaleString(CAPTION_TAG_OBJECT));
        tagObjectColumn.setMulti(true);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_tagobjtype");
        QFilter qFilter = new QFilter("labeltype", "like", (Object)labelType);
        try (DataSet dataSet = serviceHelper.queryDataSet(ALGO_KEY, SELECT_FIELDS, new QFilter[]{qFilter});){
            for (Row rs : dataSet) {
                String id = rs.getString("id");
                String name = rs.getString("name");
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(id);
                comboItem.setCaption(new LocaleString(name));
                comboItemList.add(comboItem);
            }
        }
        tagObjectColumn.setComboItems(comboItemList);
        return tagObjectColumn;
    }

    public static void setTagObjectFilter(List<QFilter> qFilters, ControlFilters controlFilters) {
        if (null != controlFilters) {
            List tagObjectIdList = controlFilters.getFilter("tagobjtype");
            ArrayList tagObjectIds = new ArrayList();
            tagObjectIdList.stream().forEach(tagObject -> {
                String tagObjectId = (String)tagObject;
                if (!HRStringUtils.isEmpty((String)tagObjectId)) {
                    tagObjectIds.add(Long.valueOf(tagObjectId));
                }
            });
            if (tagObjectIds.size() > 0) {
                qFilters.add(new QFilter("tagobjtype.fbasedataid", "in", tagObjectIds));
            }
        }
    }

    public static void setTagObjDefaultValue(DynamicObject dataEntity, String defaultNumber) {
        DynamicObject[] dataList;
        DynamicObjectCollection tagObj = dataEntity.getDynamicObjectCollection("tagobjtype");
        DynamicObjectType dynamicObjectType = tagObj.getDynamicObjectType();
        for (DynamicObject data : dataList = BusinessDataServiceHelper.load((String)"tsrbd_tagobjtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)defaultNumber)})) {
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("fbasedataid", (Object)data);
            tagObj.add((Object)dynamicObject);
        }
    }

    public static void setTitle(Label title, FormShowParameter formShowParameter, IDataModel model) {
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW == operationStatus) {
            title.setText(ResManager.loadKDString((String)"\u65b0\u589e\u6807\u7b7e", (String)"PublicLabelEdit_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        }
        if (OperationStatus.EDIT == operationStatus) {
            title.setText(ResManager.loadKDString((String)"\u7f16\u8f91\u6807\u7b7e", (String)"PublicLabelEdit_3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        }
        if (OperationStatus.VIEW == operationStatus) {
            String number = model.getValue("number").toString();
            String name = model.getValue("name").toString();
            title.setText(number + ":" + name);
        }
    }
}

