/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.msgtrack;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.msgtrack.service.MessageTrackService;
import kd.tsc.tsrbd.business.domain.msgtrack.service.MsgTrackEntity;
import kd.tsc.tsrbd.business.domain.msgtrack.service.MsgTrackHelper;
import org.apache.commons.lang3.StringUtils;

public class NoticeTabPlugin
extends HRDynamicFormBasePlugin
implements CellClickListener {
    private static final String EMAILRESULT = "emailresult";
    private static final String EMAILTITLE = "emailtitle";
    private static final String EMAILSENDER = "emailsender";
    private static final String EMAILSTATUS = "emailstatus";
    private static final String EMAILID = "emailid";
    private static final String ISEMAIL = "isemail";
    private static final String EMAILREPEAT = "emailrepeat";
    private static final String EMAILSENDTIME = "emailsendtime";
    private static final String MSGRESULT = "msgresult";
    private static final String MSGSENDER = "msgsender";
    private static final String MSGSTATUS = "msgstatus";
    private static final String MSGID = "msgid";
    private static final String ISMESSAGE = "ismessage";
    private static final String MSGREPEAT = "msgrepeat";
    private static final String MSGSENDTIME = "msgsendtime";
    private static final String ROW = "row";
    private static final String EMAILNOTICE = "emailnotice";
    private static final String MSGNOTICE = "msgnotice";
    private static final String EMAILRESEND = "emailresend";
    private static final String MSGRESEND = "msgresend";
    private static final String METHOD = "method";
    private static final String ISRESEND = "isresend";
    private static final String DATA_STATUS = "datastatus";
    private static final String PAGE_KEY_STD_RSM_DETAIL = "tstpm_candidate_detail";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        Map<String, MsgTrackEntity> msgTrackAggregation = this.getMsgTrackAggregation();
        if (!msgTrackAggregation.isEmpty()) {
            this.setNoticeTab(msgTrackAggregation);
        }
        this.setStdRsmDataStatus();
    }

    private void setStdRsmDataStatus() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.equals((CharSequence)PAGE_KEY_STD_RSM_DETAIL, (CharSequence)parentView.getFormShowParameter().getFormId())) {
            String dataStatus = (String)parentView.getFormShowParameter().getCustomParam(DATA_STATUS);
            this.getModel().setValue(DATA_STATUS, (Object)dataStatus);
        }
    }

    private Map<String, MsgTrackEntity> getMsgTrackAggregation() {
        Object stdRsmIdObj = this.getView().getFormShowParameter().getCustomParam("id");
        Long stdRsmId = stdRsmIdObj == null ? null : Long.valueOf(stdRsmIdObj.toString());
        DynamicObject[] msgTrackObjs = MsgTrackHelper.queryMsgTrackObjList((Long)stdRsmId);
        HashMap<Long, Set<Long>> aggregation = new HashMap<Long, Set<Long>>(16);
        ArrayList<Long> msgTrackids = new ArrayList<Long>(msgTrackObjs.length);
        TreeMap<String, MsgTrackEntity> msgTrackMap = new TreeMap<String, MsgTrackEntity>(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                return obj2.compareTo(obj1);
            }
        });
        for (DynamicObject msgTrackObj : msgTrackObjs) {
            Long oprecordid = msgTrackObj.getLong("oprecordid");
            Long msgtrackid = msgTrackObj.getLong("msgtrackid");
            Set<Long> trackIds = new HashSet<Long>();
            if (aggregation.get(oprecordid) != null) {
                trackIds = (Set)aggregation.get(oprecordid);
            }
            trackIds.add(msgtrackid);
            aggregation.put(oprecordid, trackIds);
            msgTrackids.add(msgtrackid);
        }
        if (aggregation.isEmpty() || msgTrackids.isEmpty()) {
            return msgTrackMap;
        }
        this.dealMsgTrackMap(msgTrackMap, msgTrackids, aggregation);
        return msgTrackMap;
    }

    private void dealMsgTrackMap(Map<String, MsgTrackEntity> msgTrackMap, List<Long> msgTrackids, Map<Long, Set<Long>> aggregation) {
        DynamicObject[] msgTracks = MsgTrackHelper.queryMsgTrackList(msgTrackids);
        Set<Map.Entry<Long, Set<Long>>> entrySet = aggregation.entrySet();
        Iterator<Map.Entry<Long, Set<Long>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> object;
            Map.Entry<Long, Set<Long>> map = object = iterator.next();
            MsgTrackEntity msgTrackEntity = new MsgTrackEntity();
            String createtime = "";
            for (DynamicObject msgTrack : msgTracks) {
                if (!map.getValue().contains(msgTrack.getLong("id"))) continue;
                Long id = msgTrack.getLong("id");
                createtime = msgTrack.getString("createtime").substring(0, 19);
                String notmethod = ((Map)msgTrack.getDynamicObject("notmethod").get("name")).get("zh_CN").toString();
                String pushscene = ((Map)msgTrack.getDynamicObject("pushscene").get("name")).get("zh_CN").toString();
                String sender = ((Map)msgTrack.getDynamicObject("sender").get("name")).get("zh_CN").toString();
                String sendStatus = msgTrack.getString("sendstatus");
                String sendResult = this.transStatus(sendStatus);
                String sendtime = msgTrack.getString("sendtime").substring(0, 19);
                int repeatcount = msgTrack.getInt("repeatcount");
                if (HRStringUtils.equals((String)ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25", (String)"MsgTrack_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), (String)sendResult)) {
                    sendResult = sendResult + "\uff0c" + ResManager.loadKDString((String)"\u5176\u4ed6\u539f\u56e0", (String)"MsgTrack_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                }
                msgTrackEntity.setPushscene(pushscene);
                msgTrackEntity.setCreatetime(createtime);
                if (HRStringUtils.equals((String)ResManager.loadKDString((String)"\u7535\u5b50\u90ae\u4ef6", (String)"MsgTrack_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), (String)notmethod)) {
                    msgTrackEntity.setEmail(true);
                    String emailtitle = msgTrack.getString(EMAILTITLE);
                    msgTrackEntity.setEmailId(id);
                    msgTrackEntity.setEmailResult(sendResult);
                    msgTrackEntity.setEmailTitle(emailtitle);
                    msgTrackEntity.setEmailSender(sender);
                    msgTrackEntity.setEmailStatus(sendStatus);
                    msgTrackEntity.setEmailrepeat(repeatcount);
                    msgTrackEntity.setEmailsendtime(sendtime);
                    continue;
                }
                msgTrackEntity.setMessage(true);
                msgTrackEntity.setMsgId(id);
                msgTrackEntity.setMsgResult(sendResult);
                msgTrackEntity.setMsgSender(sender);
                msgTrackEntity.setMsgStatus(sendStatus);
                msgTrackEntity.setMsgrepeat(repeatcount);
                msgTrackEntity.setMsgsendtime(sendtime);
            }
            msgTrackMap.put(createtime, msgTrackEntity);
        }
    }

    private void setNoticeTab(Map<String, MsgTrackEntity> msgTrackMap) {
        IDataModel dataModel = this.getModel();
        dataModel.batchCreateNewEntryRow("entryentity", msgTrackMap.size());
        Map permission = (Map)this.getView().getFormShowParameter().getCustomParam("permission");
        Set<Map.Entry<String, MsgTrackEntity>> msgTrackMapKey = msgTrackMap.entrySet();
        Iterator<Map.Entry<String, MsgTrackEntity>> iterator = msgTrackMapKey.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, MsgTrackEntity> obj = iterator.next();
            Map.Entry<String, MsgTrackEntity> map = obj;
            MsgTrackEntity msgTrackEntity = map.getValue();
            if (msgTrackEntity.isEmail()) {
                dataModel.setValue(EMAILRESULT, (Object)msgTrackEntity.getEmailResult(), index);
                dataModel.setValue(EMAILTITLE, (Object)msgTrackEntity.getEmailTitle(), index);
                dataModel.setValue(EMAILSENDER, (Object)msgTrackEntity.getEmailSender(), index);
                dataModel.setValue(EMAILSTATUS, (Object)msgTrackEntity.getEmailStatus(), index);
                dataModel.setValue(EMAILID, (Object)msgTrackEntity.getEmailId(), index);
                dataModel.setValue(EMAILSENDTIME, (Object)msgTrackEntity.getEmailsendtime(), index);
                dataModel.setValue(EMAILREPEAT, (Object)msgTrackEntity.getEmailrepeat(), index);
                dataModel.setValue(ISEMAIL, (Object)"true", index);
            }
            if (msgTrackEntity.isMessage()) {
                dataModel.setValue(MSGRESULT, (Object)msgTrackEntity.getMsgResult(), index);
                dataModel.setValue(MSGSENDER, (Object)msgTrackEntity.getMsgSender(), index);
                dataModel.setValue(MSGSTATUS, (Object)msgTrackEntity.getMsgStatus(), index);
                dataModel.setValue(MSGID, (Object)msgTrackEntity.getMsgId(), index);
                dataModel.setValue(MSGSENDTIME, (Object)msgTrackEntity.getMsgsendtime(), index);
                dataModel.setValue(MSGREPEAT, (Object)msgTrackEntity.getMsgrepeat(), index);
                dataModel.setValue(ISMESSAGE, (Object)"true", index);
            }
            String pushScene = msgTrackEntity.getPushscene();
            dataModel.setValue("createtime", (Object)msgTrackEntity.getCreatetime(), index);
            dataModel.setValue("pushscene", (Object)pushScene, index);
            if (permission != null && permission.get(pushScene) != null && ((Boolean)permission.get(pushScene)).booleanValue()) {
                dataModel.setValue("permission", (Object)"true", index);
            } else {
                dataModel.setValue("permission", (Object)"false", index);
            }
            ++index;
        }
    }

    private String transStatus(String status) {
        String reStatus = "";
        switch (status) {
            case "0": {
                reStatus = ResManager.loadKDString((String)"\u53d1\u9001\u4e2d", (String)"MsgTrack_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                break;
            }
            case "1": {
                reStatus = ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"MsgTrack_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                break;
            }
            case "2": {
                reStatus = ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25", (String)"MsgTrack_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return reStatus;
    }

    public void cellClick(CellClickEvent arg) {
        int row = arg.getRow();
        IDataModel entryOperate = this.getModel();
        DynamicObject dynamicObject = entryOperate.getEntryRowEntity("entryentity", row);
        if (EMAILNOTICE.equals(arg.getFieldKey()) || MSGNOTICE.equals(arg.getFieldKey())) {
            if (!this.checkStdRsmDataStatus()) {
                return;
            }
            this.openNoticeDetail(dynamicObject, arg.getFieldKey());
        }
        if (EMAILRESEND.equals(arg.getFieldKey()) || MSGRESEND.equals(arg.getFieldKey())) {
            if (!this.checkStdRsmDataStatus()) {
                return;
            }
            this.openResend(dynamicObject, arg.getFieldKey(), row);
        }
    }

    private boolean checkStdRsmDataStatus() {
        if (this.getView().getParentView() != null && StringUtils.equals((CharSequence)PAGE_KEY_STD_RSM_DETAIL, (CharSequence)this.getView().getParentView().getFormShowParameter().getFormId())) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"checkStdRsmDataStatus", (Object[])new Object[]{this.getView().getParentView(), this.getView()});
        }
        return true;
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void openNoticeDetail(DynamicObject dynamicObject, String button) {
        String pushscene = dynamicObject.getString("pushscene");
        FormShowParameter showParameter = new FormShowParameter();
        long msgTrackId = 0L;
        showParameter.setFormId("tsrbd_noticedetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (HRStringUtils.equals((String)EMAILNOTICE, (String)button)) {
            msgTrackId = dynamicObject.getLong(EMAILID);
            showParameter.setCustomParam("key", (Object)"email");
        } else if (HRStringUtils.equals((String)MSGNOTICE, (String)button)) {
            msgTrackId = dynamicObject.getLong(MSGID);
            showParameter.setCustomParam("key", (Object)"message");
        }
        showParameter.setCustomParam("pushscene", (Object)pushscene);
        showParameter.setCustomParam("msgcontent", (Object)this.getMsgContent(msgTrackId));
        this.getView().showForm(showParameter);
    }

    private void openResend(DynamicObject dynamicObject, String button, int row) {
        String pushscene = dynamicObject.getString("pushscene");
        long msgTrackId = 0L;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_resend");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (HRStringUtils.equals((String)EMAILRESEND, (String)button)) {
            msgTrackId = dynamicObject.getLong(EMAILID);
            showParameter.setCustomParam("key", (Object)"email");
        } else if (HRStringUtils.equals((String)MSGRESEND, (String)button)) {
            msgTrackId = dynamicObject.getLong(MSGID);
            showParameter.setCustomParam("key", (Object)"message");
        }
        showParameter.setCustomParam("pushscene", (Object)pushscene);
        showParameter.setCustomParam("msgcontent", (Object)this.getMsgContent(msgTrackId));
        showParameter.setCustomParam("msgtrackid", (Object)msgTrackId);
        showParameter.setCustomParam(ROW, (Object)row);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "resend"));
        this.getView().showForm(showParameter);
    }

    private String getMsgContent(Long msgTrackId) {
        DynamicObject msgTrack = MsgTrackHelper.queryMsgTrack((Long)msgTrackId);
        return msgTrack.getString("msgcontent");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"resend", (String)actionId)) {
            Map dataMap = (Map)returnData;
            if (HRObjectUtils.equals(dataMap.get(ISRESEND), (Object)Boolean.TRUE)) {
                this.updateResend(returnData);
                ArrayList<Long> msgTrackIds = new ArrayList<Long>(1);
                msgTrackIds.add((Long)dataMap.get("msgtrackid"));
                MessageTrackService.getInstance().updateStdRsmActInfo(msgTrackIds);
            } else {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u901a\u77e5\u65b9\u5f0f\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u91cd\u65b0\u53d1\u9001\u3002", (String)"MsgTrack_11", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), dataMap.get("notmethod")));
            }
        }
    }

    private void updateResend(Object returnData) {
        Map dataMap = (Map)returnData;
        DynamicObject msgTrack = MsgTrackHelper.queryMsgTrack((Long)((Long)dataMap.get("msgtrackid")));
        String method = dataMap.get(METHOD).toString();
        int index = (Integer)dataMap.get(ROW);
        String sender = ((Map)msgTrack.getDynamicObject("sender").get("name")).get("zh_CN").toString();
        String sendStatus = msgTrack.getString("sendstatus");
        String sendResult = this.transStatus(sendStatus);
        int repeatcount = msgTrack.getInt("repeatcount");
        String sendtime = msgTrack.getString("sendtime").substring(0, 19);
        IDataModel dataModel = this.getModel();
        if (HRStringUtils.equals((String)"email", (String)method)) {
            dataModel.setValue(EMAILRESULT, (Object)sendResult, index);
            dataModel.setValue(EMAILSENDER, (Object)sender, index);
            dataModel.setValue(EMAILSTATUS, (Object)sendStatus, index);
            dataModel.setValue(EMAILREPEAT, (Object)repeatcount, index);
            dataModel.setValue(EMAILSENDTIME, (Object)sendtime, index);
        } else if (HRStringUtils.equals((String)"message", (String)method)) {
            dataModel.setValue(MSGRESULT, (Object)sendResult, index);
            dataModel.setValue(MSGSENDER, (Object)sender, index);
            dataModel.setValue(MSGSTATUS, (Object)sendStatus, index);
            dataModel.setValue(MSGREPEAT, (Object)repeatcount, index);
            dataModel.setValue(MSGSENDTIME, (Object)sendtime, index);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u5728\u53d1\u9001\u72b6\u6001\u533a\u57df\u67e5\u770b\u53d1\u9001\u7ed3\u679c\u3002", (String)"MsgTrack_7", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
    }
}

