/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.offer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.fieldscm.CfgMsgFieldSchemeService;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferFieldsHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateBizHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;
import kd.tsc.tsrbd.business.domain.offer.service.modal.impl.IOfferLetterTemplateService;
import kd.tsc.tsrbd.common.constants.CfgMsgFieldSchemeConstants;

public class OfferTemplateBillEdit
extends HRDataBaseEdit {
    protected static Log logger = LogFactory.getLog(OfferTemplateBillEdit.class);
    private static final Map<Boolean, String> ENABLE_MAP = Maps.newHashMapWithExpectedSize((int)2);
    private static final OfferTemplateHelper OFFER_TEMPLATE_HELPER = new OfferTemplateHelper();
    private static final OfferTemplateBizHelper OFFER_TEMPLATE_BIZ_HELPER = new OfferTemplateBizHelper();
    private static final int FONTSIZE = 14;
    private static final String FIELD_KEY_LIST = "fieldkeylist";
    private static int MAX_SIZE = 15;

    public void registerListener(EventObject e) {
        Label more = (Label)this.getControl("more");
        more.addClickListener((ClickListener)this);
        Vector vector = (Vector)this.getControl("vectorapmore");
        vector.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
        Container container = (Container)this.getControl("commonfield");
        List items = container.getItems();
        Set<String> setKey = items.stream().map(Control::getKey).collect(Collectors.toSet());
        setKey.forEach(key -> {
            Label label = (Label)this.getControl((String)key);
            label.addClickListener((ClickListener)this);
        });
    }

    public void beforeBindData(EventObject e) {
        boolean watermark = OFFER_TEMPLATE_HELPER.judgeSysWatermark("tsrbd_offertemplate");
        if (watermark) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"iswatermark"});
        }
        IFormView parentView = this.getView().getParentView();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        Optional.ofNullable(parentView).ifPresent(pv -> {
            String formId = pv.getFormShowParameter().getFormId();
            if (!"bos_list".equals(formId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_modify", "bar_cancel"});
            } else {
                this.getView().setVisible(Boolean.valueOf(status.equals((Object)OperationStatus.VIEW)), new String[]{"bar_modify", "bar_close"});
                this.getView().setVisible(Boolean.valueOf(!status.equals((Object)OperationStatus.VIEW)), new String[]{"bar_save", "bar_cancel"});
            }
        });
        this.getView().setEnable(Boolean.valueOf(!status.equals((Object)OperationStatus.VIEW)), new String[]{"fieldsetpanelap", "richflex"});
        this.getView().setVisible(Boolean.valueOf(!status.equals((Object)OperationStatus.VIEW)), new String[]{"flexmore"});
    }

    public void afterBindData(EventObject e) {
        String content = this.getModel().getDataEntity().getString("content_tag");
        RichTextEditor edit = (RichTextEditor)this.getControl("richtexteditorap");
        String showContent = OfferFieldsHelper.enSwitchZh((String)content);
        edit.setText(showContent);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getModel().setValue("viewenable", dataEntity.get("enable"));
        this.getModel().setDataChanged(false);
        Map<String, String> msgTempFieldMap = this.getMsgTempFieldMap();
        logger.info("OfferTemplateBillEdit.afterBindData.msgTempFieldMap\uff1a{}", msgTempFieldMap);
        FlexPanelAp labelShowPanel = this.createLabelShowPanel(msgTempFieldMap);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("items", labelShowPanel.createControl().get("items"));
        this.getView().updateControlMetadata("commonfield", (Map)paramMap);
        this.getView().sendFormAction(this.getView());
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexmore"});
    }

    public void afterCreateNewData(EventObject e) {
        String salaryDetType = this.getSalaryDetType();
        this.getModel().setValue("salarydettype", (Object)salaryDetType);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase("preview")) {
            IAppCache iAppCache = AppCache.get((String)"tsrbd_offertempreview");
            RichTextEditor edit = (RichTextEditor)this.getControl("richtexteditorap");
            iAppCache.put("richtexteditorap", (Object)edit.getText());
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("formId", "tsrbd_offertempreview");
            proxy.addAction("setSlideBillFormId", map);
            proxy.addAction("showSlideBill", map);
        }
        if (itemKey.equalsIgnoreCase("bar_close")) {
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("more".equals(key)) {
            this.showMoreView();
        } else if ("vectorapmore".equals(key)) {
            this.showMoreView();
        } else {
            Label label = (Label)evt.getSource();
            String labelKey = label.getKey();
            IOfferLetterTemplateService templateService = new IOfferLetterTemplateService(null);
            Map poolMap = templateService.getOfferLetterTemplateVariables(null);
            OFFER_TEMPLATE_BIZ_HELPER.dynamicInsertText(this.getView(), "{" + (String)poolMap.get(labelKey) + "}");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        if (closedCallBackEvent.getActionId().equalsIgnoreCase("tsrbd_offerfield") && null != (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) {
            List list = returnData.stream().map(ListSelectedRow::getNumber).collect(Collectors.toList());
            DynamicObject[] fieldPools = OfferFieldsHelper.getFieldPoolByMsgFieldNumber(list);
            Map<String, String> stringMap = Arrays.stream(fieldPools).collect(Collectors.toMap(dy -> dy.getString("fieldkey"), dy -> dy.getString("name")));
            Container container = (Container)this.getControl("commonfield");
            OFFER_TEMPLATE_BIZ_HELPER.deletePageCache(container, this.getPageCache());
            IPageCache pageCache = this.getView().getPageCache();
            OFFER_TEMPLATE_BIZ_HELPER.savePageCache(pageCache, stringMap, container);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            RichTextEditor edit = (RichTextEditor)this.getControl("richtexteditorap");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            List fields = OfferTemplateBizHelper.getJudgeRequire();
            List fieldTips = OfferTemplateBizHelper.judgeRequire((DynamicObject)dataEntity, (List)fields);
            String content = edit.getText();
            if (HRStringUtils.isEmpty((String)content)) {
                fields.add("content");
            }
            String requireMessage = OfferTemplateBizHelper.judgeRequireMessage((DynamicObject)dataEntity, (List)fields);
            if (!fieldTips.isEmpty() || HRStringUtils.isNotEmpty((String)requireMessage)) {
                this.getView().showFieldTips(fieldTips);
                String message = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"offerTemplateBillEdit_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(requireMessage + message);
                args.setCancel(true);
                return;
            }
            Boolean viewEnable = this.getModel().getDataEntity().getBoolean("viewenable");
            this.getModel().setValue("enable", (Object)ENABLE_MAP.get(viewEnable));
            String saveContent = OfferFieldsHelper.zhSwitchEn(this.getMsgTempFieldMap(), (String)content);
            dataEntity.set("content_tag", (Object)saveContent);
        }
        if ("modify".equalsIgnoreCase(operateKey)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPermissionItemId("4715a0df000000ac");
            this.getView().updateView();
        }
    }

    private Map<String, String> getMsgTempFieldMap() {
        String salaryType = (String)this.getModel().getValue("salarydettype");
        Long scmId = CfgMsgFieldSchemeConstants.SCHEME_TSC;
        if (HRStringUtils.equals((String)"2", (String)salaryType)) {
            scmId = CfgMsgFieldSchemeConstants.SCHEME_WTC;
        }
        return CfgMsgFieldSchemeService.getInstance().getMsgTempFieldMap(scmId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            OperationResult result = args.getOperationResult();
            String message = result.getMessage();
            if (HRStringUtils.isEmpty((String)message)) {
                String content = this.getModel().getDataEntity().getString("content_tag");
                String showContent = OfferFieldsHelper.enSwitchZh((String)content);
                RichTextEditor edit = (RichTextEditor)this.getControl("richtexteditorap");
                edit.setText(showContent);
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().updateView();
            } else {
                this.getView().showOperationResult(result);
            }
        }
    }

    public FlexPanelAp createLabelShowPanel(Map<String, String> labelMap) {
        FlexPanelAp labelShowPanelAp = new FlexPanelAp();
        labelShowPanelAp.setKey("wwff");
        ArrayList keyList = Lists.newArrayListWithCapacity((int)labelMap.size());
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            String key = entry.getKey();
            keyList.add(key);
            LabelAp label = this.createLabel(entry.getValue(), key);
            labelShowPanelAp.getItems().add(label);
        }
        this.getPageCache().put(FIELD_KEY_LIST, SerializationUtils.toJsonString((Object)keyList));
        return labelShowPanelAp;
    }

    public LabelAp createLabel(String labelName, String labelTagObjId) {
        IAppCache appCache = AppCache.get((String)"offerFieldStatus");
        String offerFieldStatus = (String)appCache.get(labelTagObjId, String.class);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(labelTagObjId);
        labelAp.setName(new LocaleString(labelName));
        if ("A".equals(offerFieldStatus)) {
            labelAp.setForeColor("#0E5FD8");
        } else {
            labelAp.setForeColor("#FF0000");
        }
        labelAp.setFontSize(14);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setClickable(true);
        return labelAp;
    }

    private void showMoreView() {
        boolean isMultiSelect = true;
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tsrbd_offerfield", (boolean)true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsrbd_offerfield"));
        Container container = (Container)this.getControl("commonfield");
        List items = container.getItems();
        Set setKey = items.stream().map(Control::getKey).collect(Collectors.toSet());
        QFilter moreFilter = OFFER_TEMPLATE_HELPER.getMoreFilter(setKey);
        String listString = this.getPageCache().get(FIELD_KEY_LIST);
        List fieldList = (List)SerializationUtils.fromJsonString((String)listString, List.class);
        String salarydettype = (String)this.getModel().getValue("salarydettype");
        Long scmId = CfgMsgFieldSchemeConstants.SCHEME_TSC;
        if (HRStringUtils.equals((String)"2", (String)salarydettype)) {
            scmId = CfgMsgFieldSchemeConstants.SCHEME_WTC;
        }
        Map msgTempFieldMap = CfgMsgFieldSchemeService.getInstance().getMsgTempFieldMap(scmId);
        ArrayList collect = new ArrayList(msgTempFieldMap.keySet());
        QFilter qFilter = new QFilter("bizfield", "not in", (Object)fieldList);
        qFilter.and(new QFilter("bizfield", "in", collect));
        parameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public String getSalaryDetType() {
        Object salaryDetType = new BizConfigParamHelper().get("tsrbd_offerconfig", "salarydettype");
        if (salaryDetType == null) {
            return "";
        }
        return salaryDetType.toString();
    }

    static {
        ENABLE_MAP.put(Boolean.TRUE, "1");
        ENABLE_MAP.put(Boolean.FALSE, "0");
    }
}

