/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.offer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.business.domain.offer.service.helper.FieldPoolHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.JobFamilyScmHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateBizHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;

public class OfferTemplateF7Edit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static Log log = LogFactory.getLog(OfferTemplateF7Edit.class);
    private static final OfferTemplateHelper OFFER_TEMPLATE_HELPER = new OfferTemplateHelper();
    private static final OfferTemplateBizHelper OFFER_TEMPLATE_BIZ_HELPER = new OfferTemplateBizHelper();

    public void registerListener(EventObject event) {
        BasedataEdit jobScm = (BasedataEdit)this.getControl("jobscm");
        jobScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        jobScm.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit jobSeq = (BasedataEdit)this.getControl("jobseq");
        jobSeq.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        jobSeq.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit jobFamily = (BasedataEdit)this.getControl("jobfamily");
        jobFamily.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        jobFamily.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit jobClass = (BasedataEdit)this.getControl("jobclass");
        jobClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        jobClass.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit lowJobLevel = (BasedataEdit)this.getControl("lowjoblevel");
        lowJobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit highJobLevel = (BasedataEdit)this.getControl("highjoblevel");
        highJobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lowGradeLevel = (BasedataEdit)this.getControl("lowjobgrade");
        lowGradeLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit highJobGrade = (BasedataEdit)this.getControl("highjobgrade");
        highJobGrade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recruscene = (BasedataEdit)this.getControl("mulrecruscene");
        recruscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject dy2;
        DynamicObject country;
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("admindivision".equalsIgnoreCase(fieldKey) && null != (country = (dy2 = this.getModel().getDataEntity()).getDynamicObject("country"))) {
            QFilter filter = OFFER_TEMPLATE_HELPER.getLeaveFilter(country);
            event.addCustomQFilter(filter);
        }
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscm");
        DynamicObject jobSeq = dataEntity.getDynamicObject("jobseq");
        DynamicObject jobFamily = dataEntity.getDynamicObject("jobfamily");
        DynamicObject jobClass = dataEntity.getDynamicObject("jobclass");
        if ("jobscm".equalsIgnoreCase(fieldKey)) {
            QFilter filter = JobFamilyScmHelper.getJobScmFilter((DynamicObject)jobScm);
            event.addCustomQFilter(filter);
        }
        if ("jobseq".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                QFilter filter = JobFamilyScmHelper.getJobSeqFilter((DynamicObject)jobScmDy, (DynamicObject)jobSeq);
                event.addCustomQFilter(filter);
            });
        }
        if ("jobfamily".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                ArrayList familyList = Lists.newArrayListWithExpectedSize((int)1);
                if (null != jobFamily) {
                    familyList.add(jobFamily);
                }
                QFilter filter = JobFamilyScmHelper.getJobFamilyFilter((DynamicObject)jobScmDy, (List)familyList);
                event.addCustomQFilter(filter);
            });
        }
        if ("jobclass".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                QFilter filter = JobFamilyScmHelper.getJobClassFilter((DynamicObject)jobScmDy, (DynamicObject)jobClass);
                event.addCustomQFilter(filter);
            });
        }
        if ("lowjoblevel".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                DynamicObject highJobLevel = dataEntity.getDynamicObject("highjoblevel");
                QFilter filter = JobFamilyScmHelper.getLowJobLevelFilter((DynamicObject)jobScmDy, (DynamicObject)jobFamily, (DynamicObject)jobClass, (DynamicObject)highJobLevel);
                event.addCustomQFilter(filter);
            });
        }
        if ("highjoblevel".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                DynamicObject lowJobLevel = dataEntity.getDynamicObject("lowjoblevel");
                QFilter filter = JobFamilyScmHelper.getHighJobLevelFilter((DynamicObject)jobScmDy, (DynamicObject)jobFamily, (DynamicObject)jobClass, (DynamicObject)lowJobLevel);
                event.addCustomQFilter(filter);
            });
        }
        if ("lowjobgrade".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                DynamicObject highGradeLevel = dataEntity.getDynamicObject("highjobgrade");
                QFilter filter = JobFamilyScmHelper.getLowJobGradeFilter((DynamicObject)jobScmDy, (DynamicObject)jobFamily, (DynamicObject)jobClass, (DynamicObject)highGradeLevel);
                event.addCustomQFilter(filter);
            });
        }
        if ("highjobgrade".equalsIgnoreCase(fieldKey)) {
            Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
                DynamicObject lowJowGrade = dataEntity.getDynamicObject("lowjobgrade");
                QFilter filter = JobFamilyScmHelper.getHighJobGradeFilter((DynamicObject)jobScmDy, (DynamicObject)jobFamily, (DynamicObject)jobClass, (DynamicObject)lowJowGrade);
                event.addCustomQFilter(filter);
            });
        }
        if ("mulrecruscene".equalsIgnoreCase(fieldKey)) {
            DynamicObject reCruTyp = dataEntity.getDynamicObject("recrutyp");
            Optional.ofNullable(reCruTyp).ifPresent(dy -> {
                long reCruTypId = dy.getLong("id");
                QFilter filter = new QFilter("recruitmentcategory.fbasedataid.id", "=", (Object)reCruTypId);
                event.addCustomQFilter(filter);
            });
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldKey = basedataEdit.getFieldKey();
        if ("admindivision".equalsIgnoreCase(fieldKey)) {
            OFFER_TEMPLATE_BIZ_HELPER.adminDivisionSelect(this.getModel());
        }
        if ("country".equalsIgnoreCase(fieldKey)) {
            OFFER_TEMPLATE_BIZ_HELPER.countrySelect(event, this.getModel());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("recrutyp".equals(name)) {
            this.getModel().setValue("mulrecruscene", null);
        }
        if ("jobscm".equals(name)) {
            OFFER_TEMPLATE_BIZ_HELPER.batchSetElementNull(this.getModel(), new String[]{"jobseq", "jobfamily", "jobclass", "lowjoblevel", "lowjobgrade", "highjobgrade"});
        }
        if ("jobseq".equals(name)) {
            OFFER_TEMPLATE_BIZ_HELPER.batchSetElementNull(this.getModel(), new String[]{"jobfamily", "jobclass", "lowjoblevel", "lowjobgrade", "highjobgrade"});
        }
        if ("jobfamily".equals(name)) {
            OFFER_TEMPLATE_BIZ_HELPER.batchSetElementNull(this.getModel(), new String[]{"jobclass", "lowjoblevel", "highjoblevel", "lowjobgrade", "highjobgrade"});
        }
        if ("jobclass".equals(name)) {
            OFFER_TEMPLATE_BIZ_HELPER.batchSetElementNull(this.getModel(), new String[]{"lowjoblevel", "highjoblevel", "lowjobgrade", "highjobgrade"});
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        HashMap field = Maps.newHashMapWithExpectedSize((int)16);
        FieldPoolHelper.getFieldKeyMappingName((Map)field, (String)"0");
        FieldPoolHelper.getFieldKeyMappingName((Map)field, (String)"1");
        Set stringSet = field.keySet();
        if (stringSet.contains(key)) {
            if (!this.checkStatus(key)) {
                return;
            }
            OFFER_TEMPLATE_BIZ_HELPER.dynamicInsertText(this.getView(), "{" + (String)field.get(key) + "}");
        }
    }

    private boolean checkStatus(String key) {
        HRBaseServiceHelper msgFieldHelper = new HRBaseServiceHelper("tsrbd_offerfield");
        QFilter qFilter = new QFilter("bizfield", "=", (Object)key);
        DynamicObject msgField = msgFieldHelper.queryOne("id", qFilter);
        if (HRObjectUtils.isEmpty((Object)msgField)) {
            log.info("OfferTemplateF7Edit.checkStatus.msgField is not data");
            return false;
        }
        HRBaseServiceHelper msgFieldSchemeHelper = new HRBaseServiceHelper("tsrbd_msgtempfldscm");
        QFilter qFilter2 = new QFilter("entryentity.offerfield", "=", msgField.get("id"));
        DynamicObject msgFieldScheme = msgFieldSchemeHelper.queryOne("entryentity.fieldstatus,entryentity.offerfield", qFilter2);
        if (HRObjectUtils.isEmpty((Object)msgFieldScheme)) {
            log.info("OfferTemplateF7Edit.checkStatus.msgFieldScheme is not data");
            return false;
        }
        DynamicObjectCollection collection = msgFieldScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntity : collection) {
            if (!entryEntity.getString("offerfield.id").equals(msgField.getString("id"))) continue;
            String fieldStatus = entryEntity.getString("fieldstatus");
            HashMap<String, String> map = new HashMap<String, String>(1);
            if (!"A".equals(fieldStatus)) {
                String message = ResManager.loadKDString((String)"\u53d8\u91cf\u5b57\u6bb5\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u88ab\u5f15\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OfferTemplateF7Edit_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                map.put("fc", "#FF0000");
                this.getView().updateControlMetadata(key, map);
                return false;
            }
            map.put("fc", "#0E5FD8");
            this.getView().updateControlMetadata(key, map);
            return true;
        }
        return true;
    }
}

