/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.perm;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.perm.PermItemCommonService;
import kd.tsc.tsrbd.common.entity.perm.OpPermItemEntity;

public class PermItemCommonEdit
extends AbstractFormPlugin {
    public void createNewData(BizDataEventArgs ee) {
        super.createNewData(ee);
        IFormView formView = this.getView();
        PermItemCommonService.getInstance().loadDataHandleViewPerm(formView);
    }

    public void loadData(LoadDataEventArgs ee) {
        IFormView formView = this.getView();
        PermItemCommonService.getInstance().loadDataHandleViewPerm(formView);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            PermItemCommonService.getInstance().afterBindDataHandleViewPerm(this.getView());
        }
    }

    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        Set opPermItemEntities = PermItemCommonService.getInstance().getPermItemOpList(this.getView());
        for (OpPermItemEntity opPermItemEntity : opPermItemEntities) {
            this.addClickListeners(new String[]{opPermItemEntity.getKey()});
        }
        Set opPermItemToolBars = PermItemCommonService.getInstance().getPermItemOpToolBarSet(this.getView());
        if (opPermItemToolBars != null && !opPermItemToolBars.isEmpty()) {
            opPermItemToolBars.forEach(toolBar -> this.addItemClickListeners(new String[]{toolBar}));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs propertyChangedArgs) {
        Control control;
        String name = propertyChangedArgs.getProperty().getName();
        Set opPermItemEntities = PermItemCommonService.getInstance().getPermItemPropChangeOpList(this.getView());
        OpPermItemEntity selectOpPermItemEntity = null;
        for (OpPermItemEntity opPermItemEntity : opPermItemEntities) {
            ChangeData[] changeDataArr;
            if (!HRStringUtils.equals((String)name, (String)opPermItemEntity.getParentKey()) || (changeDataArr = propertyChangedArgs.getChangeSet()) == null || changeDataArr.length <= 0) continue;
            String newValue = (String)changeDataArr[0].getNewValue();
            if (!opPermItemEntity.getKey().equals(newValue)) continue;
            selectOpPermItemEntity = opPermItemEntity;
            break;
        }
        ValueMapItem selectVmi = null;
        if (selectOpPermItemEntity != null && (control = this.getControl(name)) instanceof ComboEdit) {
            ComboProp comboProp = (ComboProp)((ComboEdit)control).getProperty();
            List lists = comboProp.getComboItems();
            for (ValueMapItem vmi : lists) {
                if (!selectOpPermItemEntity.getKey().equals(vmi.getValue())) continue;
                selectVmi = vmi;
                break;
            }
        }
        if (selectVmi != null) {
            boolean checkResult = PermItemCommonService.getInstance().checkPermItemOp(selectOpPermItemEntity, selectVmi.getName(), this.getView());
            if (!checkResult) {
                this.getPageCache().put("property_changed_perm_checked_result", "fail");
            } else {
                this.getPageCache().remove("property_changed_perm_checked_result");
            }
            return;
        }
        this.getPageCache().remove("property_changed_perm_checked_result");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String opKey = evt.getOperationKey();
        evt.setCancel(!PermItemCommonService.getInstance().checkPermItemOp(key, opKey, this.getView()));
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String opKey = null;
        if (control instanceof Button) {
            opKey = ((Button)control).getOperationKey();
        }
        if (HRStringUtils.isNotEmpty(opKey)) {
            evt.setCancel(!PermItemCommonService.getInstance().checkPermItemOp(key, opKey, this.getView()));
        }
    }
}

