/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.portrait;

import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.label.service.PortraitServiceHelper;
import kd.tsc.tsrbd.business.domain.portrait.PortraitHelper;
import kd.tsc.tsrbd.common.utils.CacheUtils;

public class PortraitMainFormPlugin
extends HRDynamicFormBasePlugin {
    private static final String SLIDE_MOTION = "afterShowSlideBill";

    public void customEvent(CustomEventArgs evt) {
        if (SLIDE_MOTION.equals(evt.getKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject evt) {
        String sessionId = RequestContext.get().getGlobalSessionId();
        DistributeSessionlessCache cache = CacheUtils.getDistributeSessionlessCache();
        String count = (String)cache.get("count".concat(RequestContext.get().getGlobalSessionId()));
        String id = (String)cache.get("id".concat(sessionId).concat(count));
        String typeId = (String)cache.get("type".concat(sessionId).concat(count));
        String portrait = PortraitServiceHelper.getPortraitDetail((Long)Long.valueOf(id), (Long)Long.valueOf(typeId));
        if (portrait == null) {
            portrait = "{}";
        }
        DynamicObject resumeInfo = PortraitHelper.getResumeInfo((String)id, (String)typeId, (String)"fullname,photo");
        String fullName = "";
        String imgUrl = "";
        if (resumeInfo != null) {
            fullName = resumeInfo.getString("fullname");
            imgUrl = resumeInfo.getString("photo");
        }
        Image head = (Image)this.getControl("photo");
        if (!HRStringUtils.isEmpty((String)imgUrl)) {
            head.setUrl(HRImageUrlUtil.getImageFullUrl((String)imgUrl));
        } else {
            head.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
        Label label = (Label)this.getView().getControl("title");
        if (HRStringUtils.isNotEmpty((String)fullName)) {
            label.setText(fullName + "-" + ResManager.loadKDString((String)"AI\u6d1e\u5bdf", (String)"Portrait_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        } else {
            label.setText(ResManager.loadKDString((String)"AI\u6d1e\u5bdf", (String)"Portrait_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        }
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)2);
        customParam.put("cusParam_portraitData", portrait);
        customParam.put("cusParam_random", new SecureRandom().nextInt());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("custom_portrait");
        customcontrol.setData((Object)customParam);
    }
}

