/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.process;

import com.google.common.collect.ImmutableList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.process.helper.OperationResultHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;
import kd.tsc.tsrbd.business.domain.process.service.cfg.impl.BasicProcessConfigService;
import kd.tsc.tsrbd.formplugin.web.utils.PageElementUtils;

public class RecruitmentProcessListEdit
extends HRDataBaseList {
    public void beforeBindData(EventObject event) {
        PageElementUtils.hideElements(new String[]{"flexpanel_treebtn", "iscontainlower"}, this.getView());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        new BasicProcessConfigService().showProcessInfoPage(this.getView(), Long.valueOf(primaryKeyValue.toString()), parameter.isLookUp(), this.getCreateOrg(), new CloseCallBack((IFormPlugin)this, "modify"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (Objects.isNull(operationResult)) {
            return;
        }
        String operateKey = args.getOperateKey();
        if (operationResult.isSuccess() && "addprocess".equals(operateKey)) {
            this.addProcess();
        }
        if (operationResult.isSuccess() && "copyprocess".equals(operateKey)) {
            this.copyProcess();
        }
        if (!operateKey.equals("delete")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.getView().invokeOperation("refresh");
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.setOrderBy("enable desc,createtime desc,id asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            int size;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"useorg.id".equals(fieldName) || (size = commonFilterColumn.getDefaultValues().size()) == 0) continue;
            String value = commonFilterColumn.getDefaultValues().get(0).toString();
            this.getView().getPageCache().put("userOrgId", value);
        }
    }

    private void copyProcess() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection collection = billList.getSelectedRows();
        if (collection.isEmpty()) {
            return;
        }
        if (collection.size() > 1) {
            String message = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProcessConfig_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
            OperationResult validateResult = OperationResultHelper.getFatalErrorOperateResult((List)ImmutableList.of((Object)message), null);
            this.getView().showOperationResult(validateResult);
            return;
        }
        Long primaryKeyValue = (Long)collection.get(0).getPrimaryKeyValue();
        Long appId = ProcessServiceHelper.getAppIdByProcId((Long)primaryKeyValue);
        if (appId == 1030L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bf9\u9002\u7528\u5e94\u7528\u4e3a\u201c\u62db\u8058\u670d\u52a1\u76f4\u901a\u8f66\u201d\u7684\u6d41\u7a0b\u8fdb\u884c\u590d\u5236\u3002", (String)"ProcessConfig_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_processconfig");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("useorgId", (Object)this.getCreateOrg());
        showParameter.setCustomParam("id", collection.get(0).getPrimaryKeyValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsrbd_processconfig"));
        showParameter.setCustomParam("isPersonalizedModify", (Object)Boolean.TRUE);
        showParameter.setCaption(ResManager.loadKDString((String)"\u62db\u8058\u6d41\u7a0b", (String)"BizConfigMenu_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        IFormView view = SessionManager.getCurrent().getView(showParameter.getPageId());
        view.getPageCache().put("createOrg", this.getCreateOrg());
    }

    private void addProcess() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_processconfig");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("group", (Object)1030L);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsrbd_processconfig"));
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("useorgId", (Object)this.getCreateOrg());
        showParameter.setCaption(ResManager.loadKDString((String)"\u62db\u8058\u6d41\u7a0b", (String)"BizConfigMenu_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        IFormView view = SessionManager.getCurrent().getView(showParameter.getPageId());
        view.getPageCache().put("createOrg", this.getCreateOrg());
    }

    private String getCreateOrg() {
        FilterKeyValueCollections otherFilterValues;
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        String userOrgId = "";
        if (fc != null && (otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues()) != null) {
            for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                String fieldName = (String)((FilterKeyValue)filterKeyValues.get(0)).getValue().get(0);
                if (!"useorg.id".equals(fieldName)) continue;
                List value = ((FilterKeyValue)filterKeyValues.get(1)).getValue();
                userOrgId = value.get(0).toString();
                this.getView().getPageCache().put("userOrgId", userOrgId);
            }
        }
        if (HRStringUtils.isEmpty((String)userOrgId)) {
            userOrgId = this.getView().getPageCache().get("userOrgId");
        }
        return userOrgId;
    }
}

