/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.process;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import org.apache.commons.lang3.StringUtils;

public class RecruitmentStageNewEdit
extends HRDataBaseEdit {
    private static final String TOOL_BAR_ENTRY = "advcontoolbarap";
    private static final String FIELD_STAT_BASE = "stat";
    private static final String CLOSE_CALL_BACK_CALL_MARK = "select_stat";
    public static final String BAR_SAVE = "btnsave";
    public static final String BAR_CLOSE = "bar_close";
    public static final String BAR_CANCEL = "btncancel";
    public static final int TIP_TIME = 5000;

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{TOOL_BAR_ENTRY});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && StringUtils.equals((CharSequence)"deleteentry", (CharSequence)itemKey)) {
            long stageId = this.getModel().getDataEntity().getLong("id");
            int[] statSelectEntries = ((EntryGrid)this.getView().getControl("statselnewentry")).getSelectRows();
            DynamicObjectCollection stats = this.getModel().getDataEntity(true).getDynamicObjectCollection("statselnewentry");
            ArrayList statIds = Lists.newArrayListWithCapacity((int)statSelectEntries.length);
            Arrays.stream(statSelectEntries).mapToLong(statSelectEntry -> ((DynamicObject)stats.get(statSelectEntry)).getLong("stat.id")).forEach(statIds::add);
            Boolean tsprFlag = (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tspr", (String)"appFileService", (String)"queryAppfileRecrustst", (Object[])new Object[]{stageId, statIds});
            Boolean tsirmFlag = (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsirm", (String)"appFileService", (String)"queryAppfileRecrustst", (Object[])new Object[]{stageId, statIds});
            if (tsprFlag.booleanValue() || tsirmFlag.booleanValue()) {
                evt.setCancel(true);
                DynamicObject stat = ((DynamicObject)stats.get(statSelectEntries[0])).getDynamicObject(FIELD_STAT_BASE);
                String name = stat.getString("name");
                String number = stat.getString("number");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a%s\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u79fb\u9664\u3002", (String)"RecruitmentStageNewEditTip_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), number, name));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        String preSize = this.getPageCache().get(this.getView().getPageId() + "SIZE");
        if (HRStringUtils.isBlank((CharSequence)preSize)) {
            return;
        }
        int currentSize = Integer.parseInt(preSize) - rowIndexs.length;
        if (currentSize <= 0) {
            this.getPageCache().remove(this.getView().getPageId() + "SIZE");
            return;
        }
        this.getPageCache().put(this.getView().getPageId() + "SIZE", String.valueOf(currentSize));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)CLOSE_CALL_BACK_CALL_MARK, (CharSequence)itemKey)) {
            String preSize = this.getPageCache().get(this.getView().getPageId() + "SIZE");
            DynamicObjectCollection collection = new DynamicObjectCollection();
            if (!HRStringUtils.isBlank((CharSequence)preSize)) {
                int size = Integer.parseInt(preSize);
                for (int i = 0; i < size; ++i) {
                    DynamicObject stat = (DynamicObject)this.getModel().getValue(FIELD_STAT_BASE, i);
                    collection.add((Object)stat);
                }
            }
            List excludeParam = collection.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "not in", excludeParam).and(new QFilter("enable", "=", (Object)"1"));
            int f7Style = 2;
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tsrbd_recrustatnew", (boolean)true, (int)f7Style);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62db\u8058\u72b6\u6001\u3002", (String)"RecruitmentStageNewEditTip_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_CALL_MARK));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.nonNull(returnData) && returnData instanceof ListSelectedRowCollection) {
            int size = ((ListSelectedRowCollection)returnData).size();
            this.getModel().batchCreateNewEntryRow("statselnewentry", size);
            String preSize = this.getPageCache().get(this.getView().getPageId() + "SIZE");
            int start = 0;
            if (!HRStringUtils.isBlank((CharSequence)preSize)) {
                start = Integer.parseInt(preSize);
            }
            this.getPageCache().put(this.getView().getPageId() + "SIZE", start == 0 ? String.valueOf(size) : String.valueOf(start + size));
            for (ListSelectedRow listSelectedRow : (ListSelectedRowCollection)returnData) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"tsrbd_recrustatnew", (String)String.join((CharSequence)",", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue())});
                this.getModel().setValue(FIELD_STAT_BASE, (Object)obj, start);
                ++start;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection statselnewentry = dataEntity.getDynamicObjectCollection("statselnewentry");
        if (Objects.isNull(statselnewentry) || statselnewentry.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5173\u8054\u62db\u8058\u72b6\u6001\u3002", (String)"RecruitmentStageNewEditTip_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterBindData(EventObject eventObject) {
        DynamicObjectCollection dynamicObjectCollection;
        super.afterBindData(eventObject);
        FormShowParameter form = this.getView().getFormShowParameter();
        OperationStatus status = form.getStatus();
        boolean issyspreset = this.getModel().getDataEntity().getBoolean("issyspreset");
        if (issyspreset) {
            form.setStatus(OperationStatus.VIEW);
        }
        if (null != (dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("statselnewentry")) && dynamicObjectCollection.size() > 0) {
            this.getPageCache().put(this.getView().getPageId() + "SIZE", String.valueOf(dynamicObjectCollection.size()));
        }
    }
}

