/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.process.cfg;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigTypeService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.factory.ProcessConfigFactory;

public class ProcessConfigEntryPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private final Map<String, Consumer<RowClickEvent>> ENTRY_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, String> HYPER_MAP = Maps.newHashMapWithExpectedSize((int)16);

    public ProcessConfigEntryPlugin() {
        this.ENTRY_MAP.put("entryentity", this::leftEntryClick);
        this.HYPER_MAP.put("basedatapropfield1", "tsrbd_operate");
        this.HYPER_MAP.put("basedatapropfield2", "tsrbd_field");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getPageCache().put("PAGE_OP_CHANGE_DATA_KEY", "");
    }

    public void registerListener(EventObject event) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid opEntryGrid = (EntryGrid)this.getControl("opentryentity");
        opEntryGrid.addRowClickListener((RowClickEventListener)this);
        opEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid fieldEntryGrid = (EntryGrid)this.getControl("fieldentryentity");
        fieldEntryGrid.addRowClickListener((RowClickEventListener)this);
        fieldEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        Consumer<RowClickEvent> consumer = this.ENTRY_MAP.get(entryKey);
        if (null != consumer) {
            consumer.accept(evt);
        }
        this.getView().cacheFormShowParameter();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        IPageCache pageCache = this.getView().getPageCache();
        JSONArray dataChange = JSONArray.parseArray((String)pageCache.get("PAGE_OP_CHANGE_DATA_KEY"));
        if (dataChange == null) {
            dataChange = new JSONArray();
        }
        if (HRStringUtils.equals((String)"islistdisplay", (String)name)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("opentryentity");
            DynamicObject operate = (DynamicObject)this.getModel().getValue("operate", currentRowIndex);
            if (null == operate) {
                return;
            }
            String key = "operate." + operate.get("id");
            this.dataChanged(dataChange, key);
            pageCache.put("PAGE_OP_CHANGE_DATA_KEY", dataChange.toJSONString());
        } else if (HRStringUtils.equals((String)"isdisplay", (String)name)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("fieldentryentity");
            DynamicObject field = (DynamicObject)this.getModel().getValue("field", currentRowIndex);
            if (field == null) {
                return;
            }
            String key = "field." + field.get("id");
            this.dataChanged(dataChange, key);
            pageCache.put("PAGE_OP_CHANGE_DATA_KEY", dataChange.toJSONString());
        }
    }

    private void leftEntryClick(RowClickEvent event) {
        Search search = (Search)this.getView().getControl("searchap");
        search.setSearchKey("");
        IPageCache pageCache = this.getView().getPageCache();
        String itemId = pageCache.get("listBoxClickItemId");
        IFormView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        ProcessConfigService configService = ProcessConfigFactory.getConfigService((String)"tsrbd_processconfig");
        ProcessConfigTypeService typeService = ProcessConfigFactory.getTypeService((String)itemId);
        configService.setProcessConfigTypeService(typeService);
        configService.listBoxClick(view);
        view.getPageCache().put("listBoxClickItemId", itemId);
    }

    private void opEntryClick(RowClickEvent event) {
        IPageCache pageCache = this.getView().getPageCache();
        JSONArray dataChange = JSONArray.parseArray((String)pageCache.get("PAGE_OP_CHANGE_DATA_KEY"));
        if (dataChange == null) {
            dataChange = new JSONArray();
        }
        int row = event.getRow();
        DynamicObject operate = (DynamicObject)this.getModel().getValue("operate", row);
        boolean check = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), (String)"4715a0df000000ac");
        if (null == operate || !check) {
            return;
        }
        String key = "operate." + operate.get("id");
        this.dataChanged(dataChange, key);
        pageCache.put("PAGE_OP_CHANGE_DATA_KEY", dataChange.toJSONString());
    }

    private void fieldEntryClick(RowClickEvent event) {
        IPageCache pageCache = this.getView().getPageCache();
        JSONArray dataChange = JSONArray.parseArray((String)pageCache.get("PAGE_OP_CHANGE_DATA_KEY"));
        if (dataChange == null) {
            dataChange = new JSONArray();
        }
        int row = event.getRow();
        DynamicObject field = (DynamicObject)this.getModel().getValue("field", row);
        boolean check = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), (String)"4715a0df000000ac");
        if (field == null || !check) {
            return;
        }
        String key = "field." + field.get("id");
        this.dataChanged(dataChange, key);
        pageCache.put("PAGE_OP_CHANGE_DATA_KEY", dataChange.toJSONString());
    }

    private void dataChanged(JSONArray dataChange, String key) {
        if (dataChange.contains((Object)key)) {
            dataChange.remove((Object)key);
        } else {
            dataChange.add((Object)key);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(this.HYPER_MAP.get(fieldName));
        EntryGrid source = (EntryGrid)hyperLinkClickEvent.getSource();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject dataEntity = source.getEntryData().getDataEntitys()[rowIndex];
        Object id = dataEntity.get(4);
        billShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
        billShowParameter.setPkId(id);
        billShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

