/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.process.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigBizHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.factory.ProcessConfigFactory;

public class ProcessConfigPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener {
    private final Map<String, Consumer<BeforeDoOperationEventArgs>> OPERATE_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, Consumer<ItemClickEvent>> ITEM_CLICK_MAP = Maps.newHashMapWithExpectedSize((int)16);

    public ProcessConfigPlugin() {
        this.OPERATE_MAP.put("save", this::beforeSave);
        this.OPERATE_MAP.put("close", this::beforeClose);
        this.ITEM_CLICK_MAP.put("previous", this::itemClickSave);
        this.ITEM_CLICK_MAP.put("next", this::itemClickClose);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter parameter = args.getFormShowParameter();
        Long processId = (Long)args.getFormShowParameter().getCustomParam("id");
        if (null != processId) {
            ArrayList pkIdLIst = Lists.newArrayList((Object[])new Long[]{processId});
            DynamicObject[] objects = TscMutexHelper.checkHasMutex((String)"tsrbd_rqmtproc", (List)pkIdLIst, (String)"modify");
            if (objects.length > 0) {
                parameter.setStatus(OperationStatus.VIEW);
            }
            String prefix = ResManager.loadKDString((String)"\u62db\u8058\u6d41\u7a0b", (String)"ProcessConfigPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
            DynamicObject processInfo = ProcessConfigBizHelper.getProcInfoById((Long)processId, (String)"name");
            if (processInfo == null) {
                args.getFormShowParameter().setCaption(prefix);
            } else {
                args.getFormShowParameter().setCaption(prefix + "-" + processInfo.getString("name"));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String childPageId;
        super.beforeClosed(e);
        Object processId = this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject process = ProcessServiceHelper.getProcessById((String)"status", (Object)processId);
        Map baseDataStatus = HRBaseDataConfigUtil.getStatus((String)"tsrbd_rqmtproc");
        boolean isOpen = Boolean.parseBoolean(baseDataStatus.get("auditcheck").toString());
        if (null != process && !"A".equals(process.getString("status")) && isOpen) {
            this.getModel().setDataChanged(false);
        }
        if (HRStringUtils.isEmpty((String)(childPageId = this.getView().getPageCache().get("pageId")))) {
            return;
        }
        IFormView childView = this.getView().getView(childPageId);
        if (null == childView) {
            return;
        }
        childView.invokeOperation("close");
    }

    public void beforeBindData(EventObject event) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        BillShowParameter processParameter = this.getProcessBasicParameter();
        Object processId = this.getView().getFormShowParameter().getCustomParam("id");
        if (parameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            processParameter.setCustomParam("id", processId);
            processParameter.setCustomParam("group", parameter.getCustomParam("group"));
            processParameter.setCustomParam("isPersonalizeData", (Object)Boolean.TRUE);
        } else {
            DynamicObject process = ProcessServiceHelper.getProcessById((String)"status", (Object)processId);
            if (null == process) {
                processParameter.setCustomParam("id", processId);
                processParameter.setCustomParam("group", parameter.getCustomParam("group"));
                processParameter.setCustomParam("isPersonalizeData", (Object)Boolean.TRUE);
            } else {
                String processStatus = process.getString("status");
                Map baseDataStatus = HRBaseDataConfigUtil.getStatus((String)"tsrbd_rqmtproc");
                boolean isOpen = Boolean.parseBoolean(baseDataStatus.get("auditcheck").toString());
                boolean bStatus = "A".equals(processStatus) || !isOpen;
                this.getView().setEnable(Boolean.valueOf(bStatus), new String[]{"flexbasic", "configtab"});
                this.getView().setVisible(Boolean.valueOf(bStatus), new String[]{"save"});
                processParameter.setPkId(processId);
                processParameter.setCustomParam("useorgId", parameter.getCustomParam("useorgId"));
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"previous"});
        processParameter.setPageId(this.getView().getPageId() + "tsrbd_rqmtproc");
        this.getView().getPageCache().put("pageId", processParameter.getPageId());
        this.getView().showForm((FormShowParameter)processParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String message = (String)parameter.getCustomParam("message");
        if (HRStringUtils.isNotEmpty((String)message)) {
            this.getView().showTipNotification(message);
        }
        this.getView().getPageCache().put("listBoxClickItemId", "operate");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        Consumer<ItemClickEvent> consumer = this.ITEM_CLICK_MAP.get(evt.getItemKey());
        if (null != consumer) {
            consumer.accept(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Consumer<BeforeDoOperationEventArgs> consumer = this.OPERATE_MAP.get(operateKey);
        if (null != consumer) {
            consumer.accept(args);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && HRStringUtils.equals((String)"close", (String)messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
    }

    public void tabSelected(TabSelectEvent event) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String tabKey = event.getTabKey();
        if (tabKey.equals("configtab") && !this.checkData()) {
            tab.activeTab("flexbasic");
            return;
        }
        this.changeStepShow("flexbasic".equals(tabKey));
    }

    private void changeStepShow(boolean show) {
        this.getView().setVisible(Boolean.valueOf(!show), new String[]{"previous"});
        this.getView().setVisible(Boolean.valueOf(show), new String[]{"next"});
    }

    private BillShowParameter getProcessBasicParameter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        BillShowParameter basicParameter = new BillShowParameter();
        basicParameter.setFormId("tsrbd_rqmtproc");
        basicParameter.setStatus(parameter.getStatus());
        basicParameter.getOpenStyle().setShowType(ShowType.InContainer);
        basicParameter.getOpenStyle().setTargetKey("flexbasic");
        basicParameter.setCustomParam("useorgId", parameter.getCustomParam("useorgId"));
        return basicParameter;
    }

    private void beforeSave(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        ProcessConfigService service = ProcessConfigFactory.getConfigService((String)formId);
        boolean result = service.saveProcessConfigResult(view);
        args.setCancel(!result);
    }

    private void beforeClose(BeforeDoOperationEventArgs args) {
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
        boolean result = ProcessConfigBizHelper.viewDoClose((IFormView)this.getView(), (ConfirmCallBackListener)callBackListener);
        args.setCancel(result);
    }

    private void itemClickClose(ItemClickEvent event) {
        this.activeTab();
    }

    private void itemClickSave(ItemClickEvent event) {
        this.activeTab();
    }

    private void activeTab() {
        if (!this.checkData()) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        this.changeStepShow(tab.getCurrentTab().equals("flexbasic"));
        if (tab.getCurrentTab().equals("flexbasic")) {
            tab.activeTab("configtab");
        } else {
            tab.activeTab("flexbasic");
        }
    }

    private boolean checkData() {
        String pageId = this.getView().getPageCache().get("pageId");
        IFormView view = this.getView().getView(pageId);
        Object group = view.getModel().getDataEntity(true).get("group");
        int size = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
        Object app = view.getModel().getDataEntity(true).get("applicableapp");
        StringBuilder sbd = new StringBuilder();
        if (null == app) {
            sbd.append(ResManager.loadKDString((String)"\u201c\u9002\u7528\u5e94\u7528\u201d", (String)"ProcessConfigPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            sbd.append('\u3001');
        }
        if (null == group) {
            sbd.append(ResManager.loadKDString((String)"\u201c\u62db\u8058\u7c7b\u578b\u201d", (String)"ProcessConfigPlugin_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            sbd.append('\u3001');
        }
        if (size == 0) {
            sbd.append(ResManager.loadKDString((String)"\u201c\u62db\u8058\u73af\u8282\u201d", (String)"ProcessConfigPlugin_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            sbd.append('\u3001');
        }
        if (sbd.length() != 0) {
            String text = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9", (String)"ProcessConfigPlugin_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
            String value = sbd.substring(0, sbd.length() - 1);
            this.getView().showTipNotification(text + value + "\u3002");
            return false;
        }
        return true;
    }
}

