/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.process.cfg;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class ProcessConfigSearchPlugin
extends HRDynamicFormBasePlugin
implements SearchEnterListener {
    private final Map<String, Consumer<SearchEnterEvent>> SEARCH = Maps.newHashMapWithExpectedSize((int)16);

    public ProcessConfigSearchPlugin() {
        this.SEARCH.put("operate", this::operateSearch);
        this.SEARCH.put("field", this::fieldSearch);
    }

    public void registerListener(EventObject event) {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent event) {
        IPageCache pageCache = this.getView().getPageCache();
        String itemId = pageCache.get("listBoxClickItemId");
        Consumer<SearchEnterEvent> consumer = this.SEARCH.get(itemId);
        consumer.accept(event);
    }

    private void operateSearch(SearchEnterEvent event) {
        String text = event.getText();
        IPageCache pageCache = this.getView().getPageCache();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object pkValue = this.getModel().getValue("id", index);
        String cache = pageCache.get("operate" + pkValue);
        List<JSONObject> searchResult = Lists.newArrayListWithCapacity((int)16);
        List list = (List)JSONObject.parseObject((String)cache, List.class);
        if (HRStringUtils.isNotEmpty((String)text)) {
            for (JSONObject jsonObject : list) {
                if (!jsonObject.getJSONObject("operate").getString("name").contains(text)) continue;
                searchResult.add(jsonObject);
            }
        } else {
            searchResult = list;
        }
        this.getModel().deleteEntryData("opentryentity");
        if (!searchResult.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("opentryentity", searchResult.size());
            int step = 0;
            for (JSONObject jsonObject : searchResult) {
                JSONObject operate = jsonObject.getJSONObject("operate");
                this.getModel().setValue("operate", operate.get((Object)"id"), step);
                this.getModel().setValue("islistdisplay", jsonObject.get((Object)"islistdisplay"), step);
                ++step;
            }
        }
    }

    private void fieldSearch(SearchEnterEvent event) {
        String text = event.getText();
        IPageCache pageCache = this.getView().getPageCache();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object pkValue = this.getModel().getValue("id", index);
        String cache = pageCache.get("field" + pkValue);
        List list = (List)JSONObject.parseObject((String)cache, List.class);
        List<JSONObject> searchResult = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.isNotEmpty((String)text)) {
            for (JSONObject jsonObject : list) {
                if (!jsonObject.getJSONObject("field").getString("name").contains(text)) continue;
                searchResult.add(jsonObject);
            }
        } else {
            searchResult = list;
        }
        this.getModel().deleteEntryData("fieldentryentity");
        if (!searchResult.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("fieldentryentity", searchResult.size());
            int step = 0;
            for (JSONObject jsonObject : searchResult) {
                JSONObject field = jsonObject.getJSONObject("field");
                this.getModel().setValue("field", field.get((Object)"id"), step);
                this.getModel().setValue("isdisplay", jsonObject.get((Object)"isdisplay"), step);
                ++step;
            }
        }
    }
}

