/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.process.cfg;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigBizHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigTypeService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.factory.ProcessConfigFactory;

public class ProcessTemplateConfigPlugin
extends HRDynamicFormBasePlugin {
    private final Map<String, Consumer<BeforeDoOperationEventArgs>> OPERATE_MAP = Maps.newHashMapWithExpectedSize((int)16);

    public ProcessTemplateConfigPlugin() {
        this.OPERATE_MAP.put("save", this::beforeSave);
        this.OPERATE_MAP.put("close", this::beforeClose);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (ProcessServiceHelper.hasModifyPermission()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"opentryentity", "fieldentryentity"});
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"opentryentity", "fieldentryentity"});
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        IFormView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        ProcessConfigService service = ProcessConfigFactory.getConfigService((String)formId);
        ProcessConfigTypeService typeService = ProcessConfigFactory.getTypeService((String)"operate");
        service.setProcessConfigTypeService(typeService);
        service.initData(view);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Consumer<BeforeDoOperationEventArgs> consumer = this.OPERATE_MAP.get(operateKey);
        if (null != consumer) {
            consumer.accept(args);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && HRStringUtils.equals((String)"close", (String)messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        MutexHelper.release((String)"tsrbd_recrustgtyp", (String)"modify", (String)"10010");
    }

    private void beforeClose(BeforeDoOperationEventArgs event) {
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
        boolean result = ProcessConfigBizHelper.viewDoClose((IFormView)this.getView(), (ConfirmCallBackListener)callBackListener);
        event.setCancel(result);
    }

    private void beforeSave(BeforeDoOperationEventArgs event) {
        IFormView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        ProcessConfigService service = ProcessConfigFactory.getConfigService((String)formId);
        if (service.saveProcessConfigResult(view)) {
            view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ProcessConfig_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
            view.sendFormAction(view.getParentView());
            view.close();
        }
    }
}

