/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.rewardrule;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.offer.service.helper.JobFamilyScmHelper;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleDataHelper;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleQFilterHelper;
import kd.tsc.tsrbd.formplugin.web.rewardrule.RewardRuleAbstractPlugin;
import org.apache.commons.lang3.StringUtils;

public class RewardOnboardEditPlugin
extends RewardRuleAbstractPlugin {
    private static Set<String> KEYS = new HashSet<String>(8);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit recrustgnew = (BasedataEdit)this.getView().getControl("recrustgnew1");
        recrustgnew.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recrustatnew = (BasedataEdit)this.getView().getControl("recrustatnew1");
        recrustatnew.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobscmhr = (BasedataEdit)this.getView().getControl("jobscmhr1");
        jobscmhr.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobFamily = (BasedataEdit)this.getView().getControl("jobfamilyhr1");
        jobFamily.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            Donothing operate = (Donothing)args.getSource();
            String operateKey = operate.getOperateKey();
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"setlevelrange")) {
                this.openLevelORGradeRange("tsrbd_joblevelrange");
            } else if (HRStringUtils.equals((String)operateKey, (String)"setgraderange")) {
                this.openLevelORGradeRange("tsrbd_jobgraderange");
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"onboard")) {
                this.getView().invokeOperation("deleteentry_onboard");
                this.calculationResults();
            }
            args.setCancel(true);
        }
    }

    private void showFormLevelAndGrade(String form, Map<String, Object> map) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(form);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, form));
        formShowParameter.setCustomParams(map);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "tsrbd_joblevelrange": 
            case "tsrbd_jobgraderange": {
                this.setGradeOrLevelRange(closedCallBackEvent, actionId);
                break;
            }
        }
    }

    private void setGradeOrLevelRange(ClosedCallBackEvent event, String type) {
        HashMap returnData = (HashMap)event.getReturnData();
        if (returnData != null) {
            int index = (Integer)returnData.get("index");
            if ("tsrbd_jobgraderange".equals(type)) {
                DynamicObject highjobgrade = (DynamicObject)returnData.get("highjobgrade");
                DynamicObject lowjobgrade = (DynamicObject)returnData.get("lowjobgrade");
                this.setFieldRange("classgraderange1", lowjobgrade, "lowjobgrade1_id", highjobgrade, "highjobgrade1_id", index);
            } else if ("tsrbd_joblevelrange".equals(type)) {
                DynamicObject highjoblevel = (DynamicObject)returnData.get("highjoblevel");
                DynamicObject lowjoblevel = (DynamicObject)returnData.get("lowjoblevel");
                this.setFieldRange("classlevelrange1", lowjoblevel, "classlevellow1_id", highjoblevel, "classlevelhigh1_id", index);
            }
        }
    }

    public void setFieldRange(String rangeStrField, DynamicObject lowObject, String lowField, DynamicObject highObject, String highField, int index) {
        String lowJobString = "";
        String highJobString = "";
        Long lowPkId = null;
        Long highPkId = null;
        String message = "";
        if (highObject == null && lowObject == null) {
            return;
        }
        if (highObject != null) {
            highJobString = highObject.getString("name");
            highPkId = highObject.getLong("id");
        }
        if (lowObject != null) {
            lowJobString = lowObject.getString("name");
            lowPkId = lowObject.getLong("id");
        }
        if (StringUtils.isNotEmpty((CharSequence)highJobString) && StringUtils.isNotEmpty((CharSequence)lowJobString)) {
            message = lowJobString + "-" + highJobString;
        } else if (StringUtils.isNotEmpty((CharSequence)lowJobString)) {
            message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u53ca\u4ee5\u4e0a", (String)"RewardOnboardEditPlugin_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), lowJobString);
        } else if (StringUtils.isNotEmpty((CharSequence)highJobString)) {
            message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u53ca\u4ee5\u4e0b", (String)"RewardOnboardEditPlugin_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), highJobString);
        }
        this.getModel().setValue(rangeStrField, (Object)message, index);
        this.getModel().setValue(lowField, (Object)lowPkId, index);
        this.getModel().setValue(highField, (Object)highPkId, index);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setClassLevelGradeRange();
    }

    private void setClassLevelGradeRange() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity1");
        entryEntity.forEach(entry -> {
            if (entry.getDynamicObject("lowjobgrade1") != null) {
                String lowLevel = entry.getDynamicObject("classlevellow1").getString("name");
                String highLevel = entry.getDynamicObject("classlevelhigh1").getString("name");
                entry.set("classlevelrange1", (Object)(lowLevel + "-" + highLevel));
                String lowGrade = entry.getDynamicObject("lowjobgrade1").getString("name");
                String highGrade = entry.getDynamicObject("highjobgrade1").getString("name");
                entry.set("classgraderange1", (Object)(lowGrade + "-" + highGrade));
            }
        });
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setClassLevelGradeRange();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (HRStringUtils.equals((String)name, (String)"recrustgnew1")) {
            this.setRecruStgBeforeF7SelectEvent(formShowParameter);
        } else if (HRStringUtils.equals((String)name, (String)"recrustatnew1")) {
            this.setRecruStatBeforeF7SelectEvent(beforeF7SelectEvent, formShowParameter);
        } else if (HRStringUtils.equals((String)name, (String)"jobscmhr1")) {
            // empty if block
        }
        if (HRStringUtils.equals((String)name, (String)"jobfamilyhr1")) {
            DynamicObject[] dataEntitys = this.getEntityDynamicObjects("entryentity1");
            int eventRow = beforeF7SelectEvent.getRow();
            DynamicObject dy = dataEntitys[eventRow];
            Optional.ofNullable(dy.getDynamicObject("jobscmhr1")).ifPresent(jobscm -> {
                QFilter qFilter = JobFamilyScmHelper.getJobFamilyFilter((DynamicObject)jobscm, (List)Collections.EMPTY_LIST);
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            });
        }
    }

    private void setRecruStgBeforeF7SelectEvent(ListShowParameter formShowParameter) {
        QFilter qFilterTree = RewardRuleQFilterHelper.queryRecrustgTyp((String)"=");
        formShowParameter.getTreeFilterParameter().getQFilters().add(qFilterTree);
        QFilter qFilterList = RewardRuleQFilterHelper.queryRecrustgNew((String)"=");
        formShowParameter.getListFilterParameter().getQFilters().add(qFilterList);
    }

    private void setRecruStatBeforeF7SelectEvent(BeforeF7SelectEvent beforeF7SelectEvent, ListShowParameter formShowParameter) {
        DynamicObject[] dataEntitys = this.getEntityDynamicObjects("entryentity1");
        int eventRow = beforeF7SelectEvent.getRow();
        DynamicObject dy = dataEntitys[eventRow];
        long id = dy.getDynamicObject("recrustgnew1").getLong("id");
        HashMap statusSet = new HashMap(dataEntitys.length);
        ArrayList existID = new ArrayList(dataEntitys.length);
        Arrays.stream(dataEntitys).forEach(entity -> Optional.ofNullable(entity.getDynamicObject("recrustatnew1")).ifPresent(status -> {
            if (statusSet.containsKey(status.getLong("id"))) {
                if (!((Boolean)statusSet.get(status.getLong("id"))).booleanValue()) {
                    existID.add(status.getLong("id"));
                }
            } else if (!entity.getBoolean("jobscmhrswitch1")) {
                existID.add(status.getLong("id"));
            }
            statusSet.put(status.getLong("id"), entity.getBoolean("jobscmhrswitch1"));
        }));
        QFilter qFilterList = RewardRuleQFilterHelper.queryRecruStatNewByRecrustgNew((Object)id);
        QFilter removeIDList = RewardRuleQFilterHelper.queryNotInIDs(existID);
        formShowParameter.getListFilterParameter().getQFilters().add(qFilterList);
        formShowParameter.getListFilterParameter().getQFilters().add(removeIDList);
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        int rowIndex;
        String property = pca.getProperty().getName();
        ChangeData changeData = pca.getChangeSet()[0];
        if (!KEYS.contains(property)) {
            return;
        }
        DynamicObject[] dataEntitys = this.getEntityDynamicObjects("entryentity1");
        DynamicObject dy = dataEntitys[rowIndex = pca.getChangeSet()[0].getRowIndex()];
        if (dy.getDynamicObject("recrustatnew1") == null) {
            return;
        }
        long id = dy.getDynamicObject("recrustatnew1").getLong("id");
        HashMap statusSet = new HashMap(dataEntitys.length);
        if (HRStringUtils.equals((String)property, (String)"recrustatnew1")) {
            Arrays.stream(dataEntitys).forEach(entity -> Optional.ofNullable(entity.getDynamicObject("recrustatnew1")).ifPresent(status -> {
                if (statusSet.containsKey(status.getLong("id")) && ((Boolean)statusSet.get(status.getLong("id"))).booleanValue() && status.getLong("id") == id) {
                    this.getModel().setValue("jobscmhrswitch1", (Object)Boolean.TRUE, rowIndex);
                    return;
                }
                statusSet.put(status.getLong("id"), entity.getBoolean("jobscmhrswitch1"));
            }));
        } else if (HRStringUtils.equals((String)property, (String)"jobscmhrswitch1")) {
            if (changeData.getOldValue() != null && ((Boolean)changeData.getOldValue()).booleanValue()) {
                AtomicBoolean flag = new AtomicBoolean(false);
                Arrays.stream(dataEntitys).forEach(entity -> {
                    if (flag.get()) {
                        return;
                    }
                    Optional.ofNullable(entity.getDynamicObject("recrustatnew1")).ifPresent(status -> {
                        if (statusSet.containsKey(status.getLong("id")) && status.getLong("id") == id) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u5b58\u5728\u76f8\u540c\u73af\u8282\u548c\u72b6\u6001\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5173\u95ed\uff0c\u53ea\u80fd\u5220\u9664\u3002", (String)"RewardOnboardEditPlugin_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                            this.getModel().setValue("jobscmhrswitch1", (Object)Boolean.TRUE, rowIndex);
                            flag.set(true);
                            return;
                        }
                        statusSet.put(status.getLong("id"), entity.getBoolean("jobscmhrswitch1"));
                    });
                });
                if (!flag.get()) {
                    this.getModel().setValue("jobscmhr1", null);
                }
            }
        } else if (HRStringUtils.equals((String)property, (String)"recrustgnew1")) {
            this.getModel().setValue("recrustatnew1", null, rowIndex);
        } else if (HRStringUtils.equals((String)property, (String)"jobscmhr1")) {
            this.getModel().setValue("jobfamilyhr1", null, rowIndex);
        } else if (HRStringUtils.equals((String)property, (String)"jobfamilyhr1")) {
            this.getModel().setValue("classgraderange1", null, rowIndex);
            this.getModel().setValue("classlevelrange1", null, rowIndex);
        }
    }

    private void openLevelORGradeRange(String formId) {
        int focusRow = this.getEntryFocusRow("entryentity1");
        DynamicObject[] entityDynamicObjects = this.getEntityDynamicObjects("entryentity1");
        DynamicObject selectDy = entityDynamicObjects[focusRow];
        DynamicObject dynamicObject = selectDy.getDynamicObject("jobfamilyhr1");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u65cf\u201d\u518d\u8bbe\u7f6e\u201c\u804c\u7b49\u3001\u804c\u7ea7\u8303\u56f4\u201d\u3002", (String)"RewardOnboardEditPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (HRStringUtils.equals((String)formId, (String)"tsrbd_jobgraderange") && HRStringUtils.isEmpty((String)selectDy.getString("classlevelrange1"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u9009\u62e9\u804c\u7ea7\u8303\u56f4\u3002", (String)"RewardOnboardEditPlugin_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        long jobScm = selectDy.getDynamicObject("jobscmhr1").getLong("id");
        long jobFamily = dynamicObject.getLong("id");
        DynamicObject jobFamilyScm = RewardRuleDataHelper.getInstance().queryJobFamilyScm(jobScm, jobFamily);
        if (jobFamilyScm.getDynamicObject("jobgradescm") == null || jobFamilyScm.getDynamicObject("joblevelscm") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u672a\u8bbe\u7f6e\u804c\u7ea7\u65b9\u6848\u6216\u804c\u7b49\u65b9\u6848\u3002", (String)"RewardOnboardEditPlugin_7", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("index", focusRow);
        map.put("grade", jobFamilyScm.getDynamicObject("jobgradescm").getLong("id"));
        map.put("level", jobFamilyScm.getDynamicObject("joblevelscm").getLong("id"));
        Optional.ofNullable(selectDy.getDynamicObject("classlevellow1")).ifPresent(lowLevel -> map.put("lowLevel", lowLevel.getLong("id")));
        Optional.ofNullable(selectDy.getDynamicObject("classlevelhigh1")).ifPresent(highLevel -> map.put("highLevel", highLevel.getLong("id")));
        Optional.ofNullable(selectDy.getDynamicObject("lowjobgrade1")).ifPresent(lowGrade -> map.put("lowGrade", lowGrade.getLong("id")));
        Optional.ofNullable(selectDy.getDynamicObject("highjobgrade1")).ifPresent(highGrade -> map.put("highGrade", highGrade.getLong("id")));
        this.showFormLevelAndGrade(formId, map);
    }

    static {
        KEYS.add("jobscmhrswitch1");
        KEYS.add("recrustatnew1");
        KEYS.add("recrustgnew1");
        KEYS.add("jobscmhr1");
        KEYS.add("jobfamilyhr1");
    }
}

