/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.rewardrule;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.common.constants.rewardrule.RewardResultDto;
import kd.tsc.tsrbd.common.constants.rewardrule.RewardTypeEnum;

public abstract class RewardRuleAbstractPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public DynamicObject[] getEntityDynamicObjects(String entity) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entity);
        EntryData entryData = entryGrid.getEntryData();
        return entryData.getDataEntitys();
    }

    public int getEntryFocusRow(String entryEntityName) {
        EntryGrid grid = (EntryGrid)this.getControl(entryEntityName);
        return grid.getEntryState().getFocusRow();
    }

    public void calculationResults() {
        DynamicObject[] processArray = this.getEntityDynamicObjects("entryentity");
        DynamicObject[] onboardArray = this.getEntityDynamicObjects("entryentity1");
        DynamicObjectCollection resultArray = this.getModel().getEntryEntity("entryentity2");
        if (processArray.length == 0 && onboardArray.length == 0) {
            resultArray.stream().forEach(entity -> Optional.ofNullable(entity.getDynamicObject("rqmtproc")).ifPresent(value -> {
                entity.set("remark", (Object)ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u73af\u8282\u5956\u52b1\uff0c\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"RewardResultEditPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                entity.set("rewardmax", null);
                entity.set("pointmax", null);
                entity.set("currency2", null);
            }));
            this.getView().updateView("entryentity2");
            return;
        }
        for (DynamicObject entity2 : resultArray) {
            Optional.ofNullable(entity2.getDynamicObject("rqmtproc")).ifPresent(rqmtproc -> {
                int seq = 1;
                RewardResultDto resultDto = new RewardResultDto();
                DynamicObjectCollection parentCollection = rqmtproc.getDynamicObjectCollection("entryentity");
                for (DynamicObject rqmtstg : parentCollection) {
                    resultDto.setRecrustgID(rqmtstg.getDynamicObject("rqmtstg").getLong("id"));
                    resultDto.setRecrustg(rqmtstg);
                    seq = this.calculationProcessResults(processArray, seq, resultDto);
                    seq = this.calculationOnboardResults(onboardArray, seq, resultDto);
                }
                entity2.set("rewardmax", (Object)resultDto.getRewardMax());
                entity2.set("pointmax", (Object)resultDto.getPointMax());
                if (resultDto.getRemark().length() == 0) {
                    resultDto.getRemark().append(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u73af\u8282\u5956\u52b1\uff0c\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"RewardResultEditPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                }
                entity2.set("remark", (Object)resultDto.getRemark());
                entity2.set("currency2", (Object)resultDto.getCurrency());
            });
        }
        this.getView().updateView("entryentity2");
    }

    private int calculationOnboardResults(DynamicObject[] onboardArray, int seq, RewardResultDto resultDto) {
        for (DynamicObject onboard : onboardArray) {
            if (onboard.getDynamicObject("recrustgnew1") == null || resultDto.getRecrustgID() != onboard.getDynamicObject("recrustgnew1").getLong("id")) continue;
            DynamicObjectCollection subCollection = resultDto.getRecrustg().getDynamicObjectCollection("subentryentity");
            for (DynamicObject jobstatus : subCollection) {
                long jobstatusID = jobstatus.getDynamicObject("jobstatus").getLong("id");
                if (onboard.getDynamicObject("recrustatnew1") == null || jobstatusID != onboard.getDynamicObject("recrustatnew1").getLong("id")) continue;
                resultDto.getRemark().append(seq);
                resultDto.getRemark().append('.');
                resultDto.getRemark().append(onboard.getDynamicObject("recrustgnew1").getString("name"));
                resultDto.getRemark().append(':');
                resultDto.getRemark().append(onboard.getDynamicObject("recrustatnew1").getString("name"));
                resultDto.getRemark().append(',');
                String rewardItem = onboard.getString("rewarditem1");
                resultDto.getRemark().append(RewardTypeEnum.getValueByCode((String)rewardItem));
                resultDto.getRemark().append(':');
                resultDto.getRemark().append(onboard.getLong("rewardval1"));
                Optional.ofNullable(onboard.getDynamicObject("currency1")).ifPresent(currency -> this.assemblyReturnCurrency(resultDto, (DynamicObject)currency));
                if (HRStringUtils.isNotEmpty((String)onboard.getString("classlevelrange1"))) {
                    resultDto.getRemark().append(',');
                    resultDto.getRemark().append(ResManager.loadKDString((String)"\u804c\u7ea7", (String)"RewardResultEditPlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                    resultDto.getRemark().append(':');
                    resultDto.getRemark().append(onboard.getString("classlevelrange1"));
                }
                if (HRStringUtils.isNotEmpty((String)onboard.getString("classgraderange1"))) {
                    resultDto.getRemark().append(',');
                    resultDto.getRemark().append(ResManager.loadKDString((String)"\u804c\u7b49", (String)"RewardResultEditPlugin_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                    resultDto.getRemark().append(':');
                    resultDto.getRemark().append(onboard.getString("classgraderange1"));
                }
                resultDto.getRemark().append(';');
                resultDto.getRemark().append("\r\n");
                ++seq;
                if (HRStringUtils.equals((String)RewardTypeEnum.REWARD.getCode(), (String)rewardItem)) {
                    resultDto.setRewardMax(resultDto.getRewardMax() + onboard.getLong("rewardval1"));
                } else if (HRStringUtils.equals((String)RewardTypeEnum.POINT.getCode(), (String)rewardItem)) {
                    resultDto.setPointMax(resultDto.getPointMax() + onboard.getLong("rewardval1"));
                }
                if (resultDto.getCurrency() != null) continue;
                resultDto.setCurrency(onboard.getDynamicObject("currency1"));
            }
        }
        return seq;
    }

    private int calculationProcessResults(DynamicObject[] processArray, int seq, RewardResultDto resultDto) {
        for (DynamicObject process : processArray) {
            if (process.getDynamicObject("recrustgnew") == null || resultDto.getRecrustgID() != process.getDynamicObject("recrustgnew").getLong("id")) continue;
            DynamicObjectCollection subCollection = resultDto.getRecrustg().getDynamicObjectCollection("subentryentity");
            for (DynamicObject jobstatus : subCollection) {
                long jobstatusID = jobstatus.getDynamicObject("jobstatus").getLong("id");
                if (process.getDynamicObject("recrustatnew") == null || jobstatusID != process.getDynamicObject("recrustatnew").getLong("id")) continue;
                resultDto.getRemark().append(seq);
                resultDto.getRemark().append('.');
                resultDto.getRemark().append(process.getDynamicObject("recrustgnew").getString("name"));
                resultDto.getRemark().append(':');
                resultDto.getRemark().append(process.getDynamicObject("recrustatnew").getString("name"));
                resultDto.getRemark().append(',');
                String rewardItem = process.getString("rewarditem");
                resultDto.getRemark().append(RewardTypeEnum.getValueByCode((String)rewardItem));
                resultDto.getRemark().append(':');
                resultDto.getRemark().append(process.getLong("rewardval"));
                Optional.ofNullable(process.getDynamicObject("currency")).ifPresent(currency -> this.assemblyReturnCurrency(resultDto, (DynamicObject)currency));
                resultDto.getRemark().append(';');
                resultDto.getRemark().append("\r\n");
                ++seq;
                if (HRStringUtils.equals((String)RewardTypeEnum.REWARD.getCode(), (String)rewardItem)) {
                    resultDto.setRewardMax(resultDto.getRewardMax() + process.getLong("rewardval"));
                } else if (HRStringUtils.equals((String)RewardTypeEnum.POINT.getCode(), (String)rewardItem)) {
                    resultDto.setPointMax(resultDto.getPointMax() + process.getLong("rewardval"));
                }
                if (resultDto.getCurrency() != null) continue;
                resultDto.setCurrency(process.getDynamicObject("currency"));
            }
        }
        return seq;
    }

    private void assemblyReturnCurrency(RewardResultDto resultDto, DynamicObject currency) {
        resultDto.getRemark().append(',');
        resultDto.getRemark().append(currency.getDataEntityType().getDisplayName());
        resultDto.getRemark().append(':');
        resultDto.getRemark().append(currency.getString("name"));
        resultDto.getRemark().append('(');
        resultDto.getRemark().append(currency.getString("number"));
        resultDto.getRemark().append(')');
    }
}

