/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.ruleengine;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.ResultControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleBizHelper;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleConfigHelper;
import kd.tsc.tsrbd.business.domain.rule.util.RuleTextParUtil;
import kd.tsc.tsrbd.common.utils.DynamicObjectSerializeUtil;

public class AutomaticRulesEdit
extends HRDataBaseEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AutomaticRulesEdit.class);

    public void preOpenForm(PreOpenFormEventArgs eventArgs) {
        String status = eventArgs.getFormShowParameter().getStatus().name();
        if ("EDIT".equals(status)) {
            BillShowParameter formShowParameter = (BillShowParameter)eventArgs.getFormShowParameter();
            DynamicObject automaticRules = RuleBizHelper.getAutomaticRulesById((Long)((Long)formShowParameter.getPkId()));
            formShowParameter.setCaption(automaticRules.getString("name"));
        }
    }

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getView().getControl("ruletoolbar");
        toolbar.addItemClickListener((ItemClickListener)this);
        Toolbar butoolbar = (Toolbar)this.getView().getControl("butoolbar");
        butoolbar.addItemClickListener((ItemClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryrulelist");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl("createbu");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit group = (BasedataEdit)this.getView().getControl("group");
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        Object value = this.getModel().getValue("group");
        if (null == value) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrybulist", "entryrulelist", "entryoperate", "ruletoolbar", "butoolbar"});
        }
        String status = this.getView().getFormShowParameter().getStatus().name();
        IDataModel model = this.getModel();
        if (!"ADDNEW".equals(status)) {
            DynamicObjectCollection entrybulist;
            int buSize;
            DynamicObject poDy = (DynamicObject)this.getModel().getValue("policy");
            if (null == poDy) {
                return;
            }
            DynamicObject policy = RuleBizHelper.queryRulePolicyNumber((String)poDy.getString("number"));
            if (null == policy) {
                return;
            }
            ResultControl defaultresultap = (ResultControl)this.getControl("defaultresultap");
            Boolean retrundefault = (Boolean)policy.get("retrundefault");
            this.getModel().setValue("retrundefault", (Object)retrundefault);
            if (retrundefault.booleanValue()) {
                DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("group");
                DynamicObject appDy = sceneDy.getDynamicObject("bizappid");
                defaultresultap.setBizApp(appDy.getString("id"));
                defaultresultap.setScene(sceneDy.getString("id"));
            }
            if ((buSize = (entrybulist = policy.getDynamicObjectCollection("entrybulist")).size()) != 0) {
                model.deleteEntryData("entrybulist");
                model.batchCreateNewEntryRow("entrybulist", buSize);
                for (int i = 0; i < buSize; ++i) {
                    this.getModel().setValue("entitybu", (Object)((DynamicObject)entrybulist.get(i)).getDynamicObject("entitybu"), i);
                    this.getModel().setValue("containssub", ((DynamicObject)entrybulist.get(i)).get("containssub"), i);
                }
            }
            defaultresultap.setValue(policy.getString("results"));
            DynamicObjectCollection entryrulelist = policy.getDynamicObjectCollection("entryrulelist");
            int ruleSize = entryrulelist.size();
            if (ruleSize != 0) {
                model.deleteEntryData("entryrulelist");
                model.batchCreateNewEntryRow("entryrulelist", ruleSize);
                for (int i = 0; i < ruleSize; ++i) {
                    this.getModel().setValue("rulenumber", (Object)((DynamicObject)entryrulelist.get(i)).getString("rulenumber"), i);
                    this.getModel().setValue("rulename", (Object)((DynamicObject)entryrulelist.get(i)).getString("rulename"), i);
                    this.getModel().setValue("conditionpreview", (Object)RuleTextParUtil.getConditionPreviewStr((String)((DynamicObject)entryrulelist.get(i)).getString("filtercondition")), i);
                    this.getModel().setValue("resultpreview", (Object)RuleTextParUtil.getResultPreviewStr((String)((DynamicObject)entryrulelist.get(i)).getString("filterresult")), i);
                    this.getModel().setValue("ruleenable", ((DynamicObject)entryrulelist.get(i)).get("ruleenable"), i);
                    this.getModel().setValue("filtercondition", (Object)((DynamicObject)entryrulelist.get(i)).getString("filtercondition"), i);
                    this.getModel().setValue("filterresult", (Object)((DynamicObject)entryrulelist.get(i)).getString("filterresult"), i);
                }
            }
            String policyName = policy.getString("name");
            String[] split = policyName.split("_");
            this.getModel().setValue("policytext", (Object)split[split.length - 1]);
            this.getModel().setDataChanged(false);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject sceneDy;
        String status = this.getView().getFormShowParameter().getStatus().name();
        if ("ADDNEW".equals(status)) {
            DynamicObject save;
            DynamicObject group = this.getView().getModel().getDataEntity(true).getDynamicObject("group");
            IPageCache pageCache = this.getView().getPageCache();
            String groupStr = pageCache.get(this.getView().getPageId() + "INIT");
            if (null == group && HRStringUtils.isBlank((CharSequence)groupStr)) {
                return;
            }
            if (null == group) {
                group = DynamicObjectSerializeUtil.parseDynamicObjectJson((String)groupStr, (String)"brm_scene");
                this.getModel().setValue("group", (Object)group);
            } else {
                pageCache.put(this.getView().getPageId() + "INIT", DynamicObjectSerializeUtil.convertDynamicObjectToJson((DynamicObject)group));
            }
            String number = group.getString("number");
            if (number.equals("TSC_1010")) {
                this.getView().getModel().setValue("policytext", (Object)"\u5728\u804c\u4eba\u624d\u5e93\u5165\u5e93");
                save = RuleConfigHelper.getRuleOpByNumber((String)"saveOnJobPool");
                this.getModel().setValue("operate", (Object)save, 0);
            }
            if (number.equals("TSC_1020")) {
                this.getView().getModel().setValue("policytext", (Object)"\u79bb\u804c\u4eba\u624d\u5e93\u5165\u5e93");
                save = RuleConfigHelper.getRuleOpByNumber((String)"saveDimiPool");
                this.getModel().setValue("operate", (Object)save, 0);
            }
        }
        if (null != (sceneDy = (DynamicObject)this.getModel().getValue("group"))) {
            ResultControl defaultresultap = (ResultControl)this.getControl("defaultresultap");
            DynamicObject appDy = sceneDy.getDynamicObject("bizappid");
            defaultresultap.setBizApp(appDy.getString("id"));
            defaultresultap.setScene(sceneDy.getString("id"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"returndefaultflax"});
        if (HRStringUtils.isBlank((CharSequence)this.getPageCache().get(this.getView().getPageId() + "CHANGE"))) {
            this.getModel().setValue("createbu", (Object)RequestContext.get().getOrgId());
            this.getPageCache().put(this.getView().getPageId() + "CHANGE", "1");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        BillShowParameter fsp;
        String name = evt.getItemKey();
        if ("newrulebtn".equals(name)) {
            this.getPageCache().put("isOpenSubPage", "true");
            fsp = new BillShowParameter();
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("group");
            if (null == sceneDy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6240\u5c5e\u573a\u666f\u201d\u3002", (String)"AutomaticRulesEdit_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject appDy = sceneDy.getDynamicObject("bizappid");
            params.put("bizappid", appDy.getString("id"));
            params.put("scene", sceneDy.getLong("id"));
            params.put("rule_design_edit", Boolean.FALSE);
            Set<String> ruleNumberSet = this.getAllRuleNumberSet();
            params.put("ruleNumberSet", ruleNumberSet.isEmpty() ? "" : SerializationUtils.toJsonString(ruleNumberSet));
            Set<String> ruleNameSet = this.getAllRuleNameSet();
            params.put("ruleNameSet", ruleNameSet.isEmpty() ? "" : SerializationUtils.toJsonString(ruleNameSet));
            fsp.setCustomParams((Map)params);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callBack_rule_page_new"));
            fsp.setFormId("tsrbd_ruleconfig");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)fsp);
        }
        if ("newbubtn".equals(name)) {
            fsp = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)0, (boolean)true);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_org"));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setMultiSelect(true);
            fsp.setShowTitle(false);
            fsp.setHasRight(true);
            fsp.getCustomParams().put("orgFuncId", "24");
            Set buIds = this.getModel().getEntryEntity("entrybulist").stream().map(dy -> dy.getLong("entitybu.id")).collect(Collectors.toSet());
            ListFilterParameter filterParameter = new ListFilterParameter();
            String number = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)this.getModel().getDataEntityType(), (String)"createbu");
            QFilter bizOrgFilter = OrgUnitServiceHelper.getBizOrgFilter((String)number);
            filterParameter.setFilter(bizOrgFilter);
            if (!buIds.isEmpty()) {
                filterParameter.setFilter(new QFilter("id", "not in", buIds));
            }
            fsp.setListFilterParameter(filterParameter);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private Set<String> getAllRuleNumberSet() {
        return this.getModel().getEntryEntity("entryrulelist").stream().map(rule -> rule.getString("rulenumber")).collect(Collectors.toSet());
    }

    private Set<String> getAllRuleNameSet() {
        return this.getModel().getEntryEntity("entryrulelist").stream().map(rule -> rule.getString("rulename")).collect(Collectors.toSet());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int row = evt.getRowIndex();
        if (HRStringUtils.equals((String)fieldName, (String)"rulenumber")) {
            this.showRuleDesignEditPage(row);
        }
    }

    private void showRuleDesignEditPage(int row) {
        this.getPageCache().put("rule_design_edit", "true");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("tsrbd_ruleconfig");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(this.getRuleDesignEditParams(row));
        if (this.getView().getFormShowParameter().getStatus().name().equals("VIEW")) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        String pageId = this.getView().getPageId() + "_" + this.getModel().getValue("rulenumber", row);
        parameter.setPageId(pageId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callBack_rule_page_edit#" + this.getModel().getValue("rulenumber", row));
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Map<String, Object> getRuleDesignEditParams(int row) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("id", ((DynamicObject)this.getModel().getEntryEntity("entryrulelist").get(row)).get("id"));
        String number = (String)this.getModel().getValue("rulenumber", row);
        params.put("number", number);
        Set<String> ruleNumberSet = this.getAllRuleNumberSet();
        ruleNumberSet.remove(number);
        params.put("ruleNumberSet", ruleNumberSet.isEmpty() ? "" : SerializationUtils.toJsonString(ruleNumberSet));
        Set<String> ruleNameSet = this.getAllRuleNameSet();
        ruleNameSet.remove(this.getModel().getValue("rulename").toString());
        params.put("ruleNameSet", ruleNameSet.isEmpty() ? "" : SerializationUtils.toJsonString(ruleNameSet));
        params.put("rule_design_edit", Boolean.TRUE);
        params.put("name", this.getModel().getValue("rulename", row));
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("group");
        DynamicObject appDy = sceneDy.getDynamicObject("bizappid");
        params.put("bizApp", appDy.getString("id"));
        params.put("scene", sceneDy.getLong("id"));
        params.put("enable", this.getModel().getValue("ruleenable", row));
        params.put("filtercondition", this.getModel().getValue("filtercondition", row));
        params.put("filterresult", this.getModel().getValue("filterresult", row));
        return params;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String qName;
        FieldTip newTip;
        DeleteRule deleteRule;
        String number;
        QFilter qFilter;
        DynamicObject[] results;
        String name = args.getProperty().getName();
        ResultControl defaultresultap = (ResultControl)this.getControl("defaultresultap");
        if ("retrundefault".equals(name)) {
            Boolean retrundefault = (Boolean)this.getModel().getValue("retrundefault");
            this.getView().setVisible(retrundefault, new String[]{"returndefaultflax"});
            if (null != this.getModel().getValue("group")) {
                DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("group");
                DynamicObject appDy = sceneDy.getDynamicObject("bizappid");
                defaultresultap.setBizApp(appDy.getString("id"));
                defaultresultap.setScene(sceneDy.getString("id"));
            }
        }
        if ("group".equals(name)) {
            if (null == this.getModel().getValue("group")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entrybulist", "entryrulelist", "entryoperate", "ruletoolbar", "butoolbar"});
                this.getModel().setValue("retrundefault", (Object)Boolean.FALSE);
                this.getModel().setValue("policytext", null);
            } else {
                DynamicObject save;
                this.getView().setVisible(Boolean.TRUE, new String[]{"entrybulist", "entryrulelist", "entryoperate", "ruletoolbar", "butoolbar"});
                DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("group");
                DynamicObject appDy = sceneDy.getDynamicObject("bizappid");
                defaultresultap.setBizApp(appDy.getString("id"));
                defaultresultap.setScene(sceneDy.getString("id"));
                String number2 = sceneDy.getString("number");
                if (number2.equals("TSC_1010")) {
                    this.getView().getModel().setValue("policytext", (Object)"\u5728\u804c\u4eba\u624d\u5e93\u5165\u5e93");
                    save = RuleConfigHelper.getRuleOpByNumber((String)"saveOnJobPool");
                    this.getModel().setValue("operate", (Object)save, 0);
                } else if (number2.equals("TSC_1020")) {
                    this.getView().getModel().setValue("policytext", (Object)"\u79bb\u804c\u4eba\u624d\u5e93\u5165\u5e93");
                    save = RuleConfigHelper.getRuleOpByNumber((String)"saveDimiPool");
                    this.getModel().setValue("operate", (Object)save, 0);
                } else {
                    this.getModel().setValue("policytext", null);
                    this.getModel().setValue("operate", null, 0);
                }
            }
        }
        if ("number".equals(name) && (results = RuleBizHelper.getAutomaticRules((QFilter)(qFilter = new QFilter("number", "=", (Object)(number = this.getModel().getValue("number").toString()))))).length != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"AutomaticRulesEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            deleteRule = new DeleteRule();
            deleteRule.setAction("isChange");
            deleteRule.setFields(Collections.singletonList("number"));
            newTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, "number", ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"AutomaticRulesEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            newTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(newTip);
        }
        if ("name".equals(name) && (results = RuleBizHelper.getAutomaticRules((QFilter)(qFilter = new QFilter("name", "=", (Object)(qName = this.getModel().getValue("name").toString()))))).length != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728", (String)"AutomaticRulesEdit_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            deleteRule = new DeleteRule();
            deleteRule.setAction("isChange");
            deleteRule.setFields(Collections.singletonList("name"));
            newTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, "name", ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728", (String)"AutomaticRulesEdit_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            newTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(newTip);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"callBack_rule_page_new") || HRStringUtils.startsWithIgnoreCase((String)actionId, (String)"callBack_rule_page_edit")) {
            String currentRuleNumber;
            this.getPageCache().remove("isOpenSubPage");
            if (HRStringUtils.equals((String)actionId, (String)"callBack_rule_page_new")) {
                currentRuleNumber = this.getPageCache().get("ruleConfigDy");
                String ruleDesignKey = this.getPageCache().get("conditionJson");
                String conditionKey = this.getPageCache().get("resultJson");
                if (!HRStringUtils.isEmpty((String)currentRuleNumber)) {
                    this.fillRuleDesignEntryForNew(currentRuleNumber, ruleDesignKey, conditionKey);
                    this.getPageCache().remove("ruleConfigDy");
                    this.getPageCache().remove("conditionJson");
                    this.getPageCache().remove("resultJson");
                }
            } else if (HRStringUtils.startsWithIgnoreCase((String)actionId, (String)"callBack_rule_page_edit")) {
                currentRuleNumber = actionId.substring(actionId.indexOf(35) + 1);
                String ruleDesignKey = "ruleConfigDy_" + currentRuleNumber;
                String conditionKey = "conditionJson_" + currentRuleNumber;
                String resultKey = "resultJson_" + currentRuleNumber;
                String ruleDesignStr = this.getPageCache().get(ruleDesignKey);
                String filterCondition = this.getPageCache().get(conditionKey);
                String filterResult = this.getPageCache().get(resultKey);
                if (!HRStringUtils.isEmpty((String)ruleDesignStr)) {
                    this.fillRuleDesignEntryForEdit(currentRuleNumber, ruleDesignStr, filterCondition, filterResult);
                    this.getPageCache().remove(ruleDesignKey);
                    this.getPageCache().remove(conditionKey);
                    this.getPageCache().remove(resultKey);
                }
            }
            this.getPageCache().remove("rule_design_edit");
        }
        if (HRStringUtils.equals((String)actionId, (String)"bos_org") && evt.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)evt.getReturnData();
            this.fillBuEntry(selectedCol);
        }
    }

    private void fillBuEntry(ListSelectedRowCollection selectedCol) {
        int colSize = selectedCol.size();
        if (colSize == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("entrybulist");
        this.getModel().batchCreateNewEntryRow("entrybulist", colSize);
        for (int i = 0; i < colSize; ++i) {
            ListSelectedRow row = selectedCol.get(i);
            long ruleId = (Long)row.getPrimaryKeyValue();
            this.getModel().setValue("entitybu", (Object)ruleId, rowCount + i);
        }
    }

    private void fillRuleDesignEntryForNew(String ruleDesignStr, String filterCondition, String filterResult) {
        DynamicObject ruleDesignDy = DynamicObjectSerializeUtil.parseDynamicObjectJson((String)ruleDesignStr, (String)"tsrbd_ruleconfig");
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("entryrulelist");
        model.batchCreateNewEntryRow("entryrulelist", 1);
        this.setRuleEntryRow(ruleDesignDy, filterCondition, filterResult, count);
    }

    private void fillRuleDesignEntryForEdit(String currentRuleNumber, String ruleDesignStr, String filterCondition, String filterResult) {
        DynamicObject ruleDesignDy = DynamicObjectSerializeUtil.parseDynamicObjectJson((String)ruleDesignStr, (String)"tsrbd_ruleconfig");
        IDataModel model = this.getModel();
        int count = model.getEntryEntity("entryrulelist").stream().filter(dy -> HRStringUtils.equals((String)currentRuleNumber, (String)dy.getString("rulenumber"))).findFirst().get().getInt("seq");
        this.setRuleEntryRow(ruleDesignDy, filterCondition, filterResult, count - 1);
    }

    private void setRuleEntryRow(DynamicObject ruleDesignDy, String filterCondition, String filterResult, int count) {
        this.getModel().setValue("rulenumber", ruleDesignDy.get("number"), count);
        this.getModel().setValue("rulename", ruleDesignDy.get("name"), count);
        this.getModel().setValue("ruleenable", ruleDesignDy.get("enable"), count);
        this.getModel().setValue("filtercondition", (Object)filterCondition, count);
        this.getModel().setValue("filterresult", (Object)filterResult, count);
        this.getModel().setValue("conditionpreview", (Object)RuleTextParUtil.getConditionPreviewStr((String)filterCondition), count);
        this.getModel().setValue("resultpreview", (Object)RuleTextParUtil.getResultPreviewStr((String)filterResult), count);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey())) {
            int rowCount = this.getModel().getEntryRowCount("entrybulist");
            if (0 == rowCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9002\u7528\u7ec4\u7ec7\u201d\u3002", (String)"AutomaticRulesEdit_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean returnDefault = (Boolean)this.getModel().getValue("retrundefault");
            String defaultResult = null;
            if (returnDefault) {
                ResultControl defaultresultap = (ResultControl)this.getControl("defaultresultap");
                defaultResult = defaultresultap.getValue();
            }
            String status = this.getView().getFormShowParameter().getStatus().name();
            formOperate.getOption().setVariableValue("status", status);
            formOperate.getOption().setVariableValue("defaultresultap", defaultResult);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject group;
        String name = event.getProperty().getName();
        if (name.equals("createbu")) {
            event.getFormShowParameter().setCustomParam("range", (Object)RuleBizHelper.getOrgByUserId());
        }
        if (name.equals("group") && null != (group = this.getView().getModel().getDataEntity(true).getDynamicObject("group"))) {
            event.addCustomQFilter(new QFilter("id", "!=", (Object)group.getLong("id")));
        }
    }
}

