/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.ruleengine;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.controls.RuleResult;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleConfigHelper;
import kd.tsc.tsrbd.business.domain.rule.util.RuleEngineControlUtil;
import kd.tsc.tsrbd.common.utils.DynamicObjectSerializeUtil;

public class RuleConfigEdit
extends HRBaseDataCommonEdit {
    private RuleCondition getRuleCondition() {
        return (RuleCondition)this.getControl("ruleconditionap");
    }

    private RuleResult getRuleResult() {
        return (RuleResult)this.getControl("ruleresultap");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)"ruledate", (String)key)) {
            Date newData = (Date)e.getChangeSet()[0].getNewValue();
            if (null == newData) {
                return;
            }
            String dateFormat = this.getView().getPageCache().get("dateFormat");
            String data = HRDateTimeUtils.format((Date)newData, (String)dateFormat);
            this.getRuleCondition().setDate(data);
            this.getRuleResult().setDate(data);
            this.getModel().setValue("ruledate", null);
        }
        String status = this.getView().getFormShowParameter().getStatus().name();
        if (HRStringUtils.equals((String)"number", (String)key) && status.equals("ADDNEW")) {
            this.getModel().setValue("name", (Object)this.getModel().getValue("number").toString());
        }
        if (HRStringUtils.equals((String)"number", (String)key) && !status.equals("ADDNEW")) {
            this.getModel().setValue("number", this.getView().getFormShowParameter().getCustomParam("number"));
        }
    }

    public void beforeBindData(EventObject e) {
        boolean isEdit;
        super.beforeBindData(e);
        String numberConfig = RuleConfigHelper.getNumberConfig();
        this.getView().getModel().setValue("number", (Object)numberConfig);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getView().setVisible(Boolean.valueOf(parameter.getStatus().name().equals("VIEW")), new String[]{"close"});
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean bl = isEdit = params.get("rule_design_edit") != null && (Boolean)params.get("rule_design_edit") != false;
        if (isEdit) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getPageCache().put("rule_design_edit", "true");
            this.fillFieldsForEdit(params);
        }
        RuleCondition ruleCondition = this.getRuleCondition();
        RuleResult ruleResult = this.getRuleResult();
        String ruleId = this.getModel().getValue("id").toString();
        if (IDStringUtils.idNotEmpty((String)ruleId)) {
            ruleCondition.setRule(ruleId);
            ruleResult.setRule(ruleId);
        } else if (params.containsKey("policyid")) {
            String policyId = params.get("policyid").toString();
            ruleCondition.setPolicy(policyId);
            ruleResult.setPolicy(policyId);
        }
        this.initControl((RuleControl)ruleCondition, (String)params.get("filtercondition"));
        this.initControl((RuleControl)ruleResult, (String)params.get("filterresult"));
        this.getModel().setDataChanged(false);
    }

    private void fillFieldsForEdit(Map<String, Object> params) {
        IDataModel model = this.getModel();
        model.setValue("id", params.get("id"));
        model.setValue("name", params.get("name"));
        model.setValue("number", params.get("number"));
        if (((Boolean)params.get("enable")).booleanValue()) {
            model.setValue("ruleenable", (Object)1);
        } else {
            model.setValue("ruleenable", (Object)0);
        }
        String conditionStr = String.valueOf(params.get("filtercondition"));
        model.setValue("conditions", (Object)conditionStr);
        String resultStr = String.valueOf(params.get("filterresult"));
        model.setValue("results", (Object)resultStr);
    }

    private void initControl(RuleControl ruleControl, String value) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = "";
        if (StringUtils.isEmpty((CharSequence)bizAppId) && params.get("bizappid") != null) {
            bizAppId = params.get("bizappid").toString();
        }
        if (StringUtils.isEmpty((CharSequence)bizAppId) && params.get("bizApp") != null) {
            bizAppId = params.get("bizApp").toString();
        }
        ruleControl.setBizApp(bizAppId);
        if (params.get("scene") != null) {
            ruleControl.setScene(params.get("scene").toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ruleControl.setValue(value);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)args.getSource();
            String operateKey = op.getOperateKey();
            if ("saverule".equals(operateKey)) {
                String ruleName = this.getModel().getValue("name").toString();
                if (null != ruleName && !RuleConfigHelper.checkTextFormat((String)ruleName).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u540d\u79f0\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RuleConfigEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.validSave(args);
                this.getModel().setDataChanged(false);
            } else if ("closepage".equals(operateKey)) {
                this.validClose();
            }
        }
    }

    private void validSave(BeforeDoOperationEventArgs args) {
        String conditionJson = this.getRuleCondition().getValue();
        String resultJson = this.getRuleResult().getValue();
        this.getModel().setValue("conditions", (Object)conditionJson);
        this.getModel().setValue("results", (Object)resultJson);
        RuleEngineControlUtil.validCondition((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)conditionJson);
        RuleEngineControlUtil.validRuleResult((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)resultJson);
    }

    private void validClose() {
        String old;
        String originRuleCondition = this.getPageCache().get("origin_rule_conditions");
        String originRuleResult = this.getPageCache().get("origin_rule_results");
        String conditionJson = this.getRuleCondition().getValue();
        String resultJson = this.getRuleResult().getValue();
        if (!HRStringUtils.equals((String)originRuleCondition, (String)conditionJson)) {
            old = (String)this.getModel().getValue("conditions");
            this.getModel().setValue("conditions", (Object)conditionJson);
            this.getModel().setValue("conditions", (Object)old);
        }
        if (!HRStringUtils.equals((String)originRuleResult, (String)resultJson)) {
            old = (String)this.getModel().getValue("results");
            this.getModel().setValue("results", (Object)resultJson);
            this.getModel().setValue("results", (Object)old);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"saverule")) {
            boolean isEdit = (Boolean)this.getView().getFormShowParameter().getCustomParam("rule_design_edit");
            this.getPageCache().put("needcallback", "true");
            IFormView parentView = this.getView().getParentView();
            parentView.getPageCache().put(this.getParentViewRuleDyKey(isEdit), DynamicObjectSerializeUtil.convertDynamicObjectToJson((DynamicObject)this.getModel().getDataEntity()));
            parentView.getPageCache().put(this.getParentViewConditionKey(isEdit), (String)this.getModel().getValue("conditions"));
            parentView.getPageCache().put(this.getParentViewResultKey(isEdit), (String)this.getModel().getValue("results"));
        }
    }

    private String getParentViewRuleDyKey(boolean isEdit) {
        return isEdit ? "ruleConfigDy_" + this.getModel().getValue("number") : "ruleConfigDy";
    }

    private String getParentViewConditionKey(boolean isEdit) {
        return isEdit ? "conditionJson_" + this.getModel().getValue("number") : "conditionJson";
    }

    private String getParentViewResultKey(boolean isEdit) {
        return isEdit ? "resultJson_" + this.getModel().getValue("number") : "resultJson";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("needcallback");
        this.getPageCache().remove("rule_design_edit");
    }
}

