/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.seclevel.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.enums.SecConfPageEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class SecLevelPlugin
extends HRDataBaseEdit {
    private static final String SECLEVEL = "seclevel";
    private static final String SECSELECT = "secselect";
    private static final String PUB_SECLEVEL = "1070_S";
    private static final Long SUP_SECLEVEL = 1020L;
    private static final Long POSITION = 1010L;
    private static final Long TALENT = 1020L;

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        String entityId = this.getView().getEntityId();
        this.setSeclevel(entityId, true);
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        String entityId = this.getView().getEntityId();
        this.setSeclevel(entityId, true);
    }

    public void afterCopyData(EventObject eventObject) {
        super.afterCopyData(eventObject);
        String entityId = this.getView().getEntityId();
        this.setSeclevel(entityId, false);
    }

    public void propertyChanged(PropertyChangedArgs eventObject) {
        ChangeData changeData;
        String newValue;
        String fieldName = eventObject.getProperty().getName();
        if (HRStringUtils.equals((String)SECSELECT, (String)fieldName) && HRStringUtils.isNotEmpty((String)(newValue = (String)(changeData = eventObject.getChangeSet()[0]).getNewValue()))) {
            BasedataEdit secLevel = (BasedataEdit)this.getView().getControl(SECLEVEL);
            secLevel.setItemByNumber(newValue);
        }
    }

    private void setSeclevel(String entityId, boolean type) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SECSELECT});
        Long pkIdByName = SecConfPageEnum.getPkIdByName((String)entityId);
        boolean flag = SecConfHelper.querySecurityConf((Long)pkIdByName);
        if (!flag) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(SECSELECT);
        comboEdit.setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{SECSELECT});
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(SECLEVEL);
        if (dynamicObject != null) {
            this.getModel().setValue(SECSELECT, (Object)dynamicObject.getString("number"));
        }
        if (POSITION.equals(pkIdByName)) {
            this.setPositionSec(comboEdit, dynamicObject, type);
        }
        if (TALENT.equals(pkIdByName)) {
            this.setTalentSec(comboEdit, dynamicObject, type);
        }
    }

    private void setPositionSec(ComboEdit comboEdit, DynamicObject dynamicObject, boolean type) {
        DynamicObjectCollection resultColl = SecConfHelper.listSecurityConf((Long)POSITION);
        List<ComboItem> data = new ArrayList<ComboItem>();
        boolean flag = true;
        for (DynamicObject rescoll : resultColl) {
            String showSec = rescoll.getString("codelevel") + "\uff08" + rescoll.getString("name") + "\uff09";
            data.add(new ComboItem(new LocaleString(showSec), rescoll.getString("number")));
            if (!HRDynamicObjectUtils.equals((DynamicObject)rescoll, (DynamicObject)dynamicObject)) continue;
            flag = false;
        }
        if (flag) {
            data = this.setSecByType(dynamicObject, type, data);
        }
        comboEdit.setComboItems(data);
    }

    private void setTalentSec(ComboEdit comboEdit, DynamicObject dynamicObject, boolean type) {
        List<ComboItem> data = new ArrayList<ComboItem>();
        boolean flag = true;
        BasedataEdit secLevel = (BasedataEdit)this.getView().getControl(SECLEVEL);
        DynamicObject userLevel = PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId()) ? SecuserHelper.getSecurityLevel((Long)SUP_SECLEVEL) : SecuserHelper.queryUserSecurityLevel((Long)TSCRequestContext.getUserId(), (Long)TALENT);
        if (userLevel == null) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LN\uff08\u516c\u5f00\uff09", (String)"SecLevelPlugin_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0])), PUB_SECLEVEL));
            secLevel.setItemByNumber(PUB_SECLEVEL);
        } else {
            DynamicObjectCollection resultColl = SecConfHelper.listSecurityConf((Long)TALENT);
            int idx = userLevel.getInt("index");
            for (DynamicObject rescoll : resultColl) {
                if (rescoll.getInt("index") >= idx) {
                    String showSec = rescoll.getString("codelevel") + "\uff08" + rescoll.getString("name") + "\uff09";
                    data.add(new ComboItem(new LocaleString(showSec), rescoll.getString("number")));
                }
                if (!HRDynamicObjectUtils.equals((DynamicObject)rescoll, (DynamicObject)dynamicObject)) continue;
                flag = false;
            }
            if (flag) {
                data = this.setSecByType(dynamicObject, type, data);
            }
        }
        comboEdit.setComboItems(data);
    }

    private List<ComboItem> setSecByType(DynamicObject dynamicObject, boolean type, List<ComboItem> data) {
        if (!type) {
            this.getModel().setValue(SECLEVEL, null);
            this.getModel().setValue(SECSELECT, null);
        }
        if (dynamicObject != null && type) {
            String showSec = dynamicObject.getString("codelevel") + "\uff08" + dynamicObject.getString("name") + "\uff09";
            data.add(new ComboItem(null, new LocaleString(showSec), dynamicObject.getString("number"), false));
        }
        return data;
    }
}

