/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.seclevel.edit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;

public class SecuserLevelEdit
extends HRDataBaseEdit {
    private static final String ADD_NEW = "ADDNEW";
    private static final String COMBO = "combofield";

    public void afterCreateNewData(EventObject event) {
        DynamicObject[] dynamicObjects = SecuserHelper.queryOpenFunction();
        int size = dynamicObjects.length;
        if (size == 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("tsrbd_levelentry", size);
        for (int i = 0; i < size; ++i) {
            model.setValue("functionlevel", (Object)dynamicObjects[i], i);
        }
        this.changeExpirationDate();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject user;
        Object pkValue;
        DynamicObject object;
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)COMBO, (String)name)) {
            ChangeData changeData = args.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            String newValue = (String)changeData.getNewValue();
            BasedataEdit secLevel = (BasedataEdit)this.getView().getControl("userlevel");
            secLevel.setItemByNumber(newValue, rowIndex);
        }
        if (name.equals("effectivedate")) {
            this.getModel().setValue("expirationdate", null);
            this.changeExpirationDate();
        } else if (name.equals("userid") && (object = SecuserHelper.queryOneSecUserInfo((Object)(pkValue = (user = (DynamicObject)this.getModel().getValue("userid")).getPkValue()))) != null) {
            IFormView view = this.getView();
            BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setPkId(object.get("id"));
            view.invokeOperation("refresh");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u521b\u5efa\uff0c\u5df2\u6253\u5f00\u5bf9\u5e94\u7528\u6237\u5206\u7ea7\u4fe1\u606f", (String)"SecuserLevelEdit_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeExpirationDate() {
        Date date = (Date)this.getModel().getValue("effectivedate");
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, 1);
            DateEdit dateEdit = (DateEdit)this.getView().getControl("expirationdate");
            dateEdit.setMinDate(calendar.getTime());
        }
    }

    public void afterBindData(EventObject event) {
        EntryGrid control = (EntryGrid)this.getControl("tsrbd_levelentry");
        control.selectRows(0);
    }

    public void beforeBindData(EventObject event) {
        DynamicObject[] securityLevels;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String statusName = formShowParameter.getStatus().name();
        ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO);
        ArrayList data = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject securityLevel : securityLevels = SecuserHelper.getSecurityLevels()) {
            String showSec = securityLevel.getString("codelevel") + "\uff08" + securityLevel.getString("name") + "\uff09";
            data.add(new ComboItem(new LocaleString(showSec), securityLevel.getString("number")));
        }
        comboEdit.setComboItems((List)data);
        if (HRStringUtils.equals((String)statusName, (String)ADD_NEW)) {
            this.getModel().setDataChanged(false);
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject[] dynamicObjects = SecuserHelper.queryOpenFunction();
        int size = dynamicObjects.length;
        if (size == 0) {
            model.deleteEntryData("tsrbd_levelentry");
            this.getModel().setDataChanged(false);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("tsrbd_levelentry");
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : entryEntity) {
            long fId = dynamicObject.getDynamicObject("functionlevel").getLong("id");
            DynamicObject dyU = dynamicObject.getDynamicObject("userlevel");
            map.put(fId, dyU);
        }
        model.deleteEntryData("tsrbd_levelentry");
        model.batchCreateNewEntryRow("tsrbd_levelentry", size);
        for (int i = 0; i < size; ++i) {
            model.setValue("functionlevel", (Object)dynamicObjects[i], i);
            long dyFId = dynamicObjects[i].getLong("id");
            DynamicObject dynamicObject = (DynamicObject)map.get(dyFId);
            if (dynamicObject != null) {
                model.setValue("userlevel", (Object)dynamicObject, i);
                this.getModel().setValue(COMBO, (Object)dynamicObject.getString("number"), i);
                continue;
            }
            model.setValue("userlevel", null, i);
            this.getModel().setValue(COMBO, null, i);
        }
        this.getModel().setDataChanged(false);
    }
}

