/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.seclevel.list;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ComboListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SecFuncConfList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(SecFuncConfList.class);
    private static List<String> dyColl = new ArrayList<String>(10);
    private static Map<String, String> dyMap = new HashMap<String, String>(16);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"tblenable"});
        this.addItemClickListeners(new String[]{"tbldisable"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tblenable".equals(itemKey) || "tbldisable".equals(itemKey)) {
            DynamicObject[] dyObjs;
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection rows = listView.getSelectedRows();
            if (rows == null || rows.size() == 0) {
                return;
            }
            ArrayList<Long> list = new ArrayList<Long>();
            for (ListSelectedRow row : rows) {
                list.add((Long)row.getPrimaryKeyValue());
            }
            for (DynamicObject dy : dyObjs = SecConfHelper.queryEnable(list)) {
                String enable = this.getView().getPageCache().get(dy.getString("number"));
                if (HRStringUtils.equals((String)enable, (String)dy.getString("enable"))) continue;
                SecConfHelper.publishMsg((String)String.valueOf(dy.get("id")), (String)dy.getString("enable"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"enable", (String)operateKey) || HRStringUtils.equals((String)"disable", (String)operateKey)) {
            DynamicObject[] dynamicObjects;
            ListSelectedRowCollection rows = args.getListSelectedData();
            ArrayList<Long> list = new ArrayList<Long>();
            for (ListSelectedRow row : rows) {
                list.add((Long)row.getPrimaryKeyValue());
            }
            for (DynamicObject dyObj : dynamicObjects = SecConfHelper.queryEnable(list)) {
                this.getPageCache().put(dyObj.getString("number"), dyObj.getString("enable"));
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        DynamicObject[] ds = SecConfHelper.querySecLevel();
        dyColl.clear();
        dyMap.clear();
        ComboListColumn enableColumn = (ComboListColumn)columns.remove(3);
        for (int i = 0; i < ds.length; ++i) {
            ListColumn col = this.createListColumn("presetfield" + i, ds[i].get("codelevel") + ResManager.loadKDString((String)"\u53ef\u89c1\u6570\u636e", (String)"SecFuncConfList_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), i + 1);
            columns.add(col);
            dyColl.add((String)ds[i].get("codelevel"));
            dyMap.put(String.valueOf(ds[i].get("codelevel")), "presetfield" + i);
        }
        columns.add(enableColumn);
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        int colVisible = 11;
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setVisible(colVisible);
        return col;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BillListDataProvider());
        super.beforeCreateListDataProvider(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExportFile(ExportFileEvent exportFileEvent) {
        File file = exportFileEvent.getFile();
        if (file == null) {
            return;
        }
        FileOutputStream out = null;
        try (FileInputStream fis = new FileInputStream(file);
             XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);){
            Sheet sheet = wb.getSheetAt(0);
            ListView listView = (ListView)exportFileEvent.getSource();
            List showListColumns = listView.getShowListColumns();
            IListModel listModel = listView.getListModel();
            BillList billList = this.getBillList();
            int selectRows = billList.getSelectedRows().size();
            HashMap<String, String> colMap = new HashMap<String, String>(showListColumns.size());
            if (selectRows > 0) {
                for (IListColumn listColumn : showListColumns) {
                    colMap.put(String.valueOf(listColumn.getCaption()), listColumn.getFieldName());
                }
                QueryResult queryResult = listModel.getQueryResult();
                DynamicObjectCollection exportDataList = queryResult.getCollection();
                this.writeSheetContent(exportDataList, sheet, colMap);
            }
            out = new FileOutputStream(file);
            wb.write((OutputStream)out);
        }
        catch (IOException ex) {
            logger.info("SecFuncConfList.afterExportFile:{}", (Object)ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                logger.info("SecFuncConfList.afterExportFile:{}", (Object)ex);
            }
        }
    }

    private void writeSheetContent(DynamicObjectCollection exportDataList, Sheet sheet, Map<String, String> colMap) {
        Row titleRow = sheet.getRow(0);
        int len = titleRow.getPhysicalNumberOfCells();
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            XSSFRow row = (XSSFRow)sheet.getRow(i + 1);
            for (int k = 0; k < len; ++k) {
                String col = String.valueOf(titleRow.getCell(k));
                XSSFCell ncell = row.createCell(k);
                String res = exportData.getString(colMap.get(col));
                if (HRStringUtils.equals((String)ResManager.loadKDString((String)"\u72b6\u6001", (String)"SecFuncConfList_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]), (String)col)) {
                    res = HRStringUtils.equals((String)"1", (String)res) ? ResManager.loadKDString((String)"\u53ef\u7528", (String)"SecFuncConfList_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"SecFuncConfList_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                }
                ncell.setCellValue(res);
            }
        }
    }

    private BillList getBillList() {
        return (BillList)this.getView().getControl("billlistap");
    }

    static class BillListDataProvider
    extends ListDataProvider {
        BillListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection coll = super.getData(start, limit);
            for (DynamicObject dynamicObject : coll) {
                for (int i = 0; i < dyColl.size(); ++i) {
                    this.addDyProperty("presetfield" + i, dynamicObject);
                }
            }
            if (coll.size() < 1) {
                return coll;
            }
            this.setCodeLevel(coll);
            return coll;
        }

        private void addDyProperty(String name, DynamicObject dy) {
            DynamicSimpleProperty property = new DynamicSimpleProperty(name, String.class, null);
            property.setName(name);
            dy.getDynamicObjectType().addProperty((DynamicProperty)property);
        }

        private void setCodeLevel(DynamicObjectCollection coll) {
            DynamicObject[] ds = SecConfHelper.querySecSwitch();
            HashMap codeleveList = new HashMap(16);
            for (DynamicObject dynamicObject : ds) {
                DynamicObjectCollection dyCollection = (DynamicObjectCollection)dynamicObject.get("secfunconfentity");
                HashMap<String, String> valMap = new HashMap<String, String>(dyCollection.size());
                for (DynamicObject aDyCollection : dyCollection) {
                    DynamicObject lcode = (DynamicObject)aDyCollection.get("code");
                    valMap.put((String)lcode.get("codelevel"), String.valueOf(aDyCollection.get("levelswitch")));
                }
                codeleveList.put(String.valueOf(dynamicObject.get("id")), valMap);
            }
            for (DynamicObject aColl : coll) {
                HashMap tmp;
                if (!codeleveList.containsKey(String.valueOf(aColl.get("id"))) || (tmp = (HashMap)codeleveList.get(String.valueOf(aColl.get("id")))) == null) continue;
                for (String aDyColl : dyColl) {
                    aColl.set((String)dyMap.get(aDyColl), (Object)this.judgeSwitch(aDyColl, (String)tmp.get(aDyColl)));
                }
            }
        }

        private String judgeSwitch(String codeLevel, String judge) {
            if (HRStringUtils.isEmpty((String)judge)) {
                return "-";
            }
            if (HRStringUtils.equals((String)codeLevel, (String)"LP")) {
                if (HRStringUtils.equals((String)judge, (String)"true")) {
                    return ResManager.loadKDString((String)"\u6307\u5b9a\u4eba\u5458", (String)"SecFuncConfList_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                }
                return "-";
            }
            if (HRStringUtils.equals((String)codeLevel, (String)"LN")) {
                if (HRStringUtils.equals((String)judge, (String)"true")) {
                    return ResManager.loadKDString((String)"\u5168\u90e8\u4eba\u5458", (String)"SecFuncConfList_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
                }
                return "-";
            }
            if (HRStringUtils.equals((String)judge, (String)"true")) {
                return ResManager.loadKDString((String)"\u540c\u7ea7\u53ca\u4e0b\u7ea7", (String)"SecFuncConfList_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
            }
            return "-";
        }
    }
}

