/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.seclevel.list;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.common.enums.SecConfPageEnum;

public class SecLevelListPlugin
extends AbstractListPlugin {
    private static final String SECLEVELFILTER = "seclevel.codelevel";
    private static final Long TALENT = 1020L;

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        CommonFilterColumn secLevelColumn = (CommonFilterColumn)args.getFilterColumn(SECLEVELFILTER);
        Long pkIdByName = SecConfPageEnum.getPkIdByName((String)listShowParameter.getBillFormId());
        if (SecConfHelper.querySecurityConf((Long)pkIdByName)) {
            if (TALENT.equals(pkIdByName)) {
                this.commonSecLevelColumnInit(secLevelColumn);
            }
        } else {
            args.getCommonFilterColumns().remove(secLevelColumn);
            args.getSchemeFilterColumns().remove(secLevelColumn);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Long pkIdByName = SecConfPageEnum.getPkIdByName((String)listShowParameter.getBillFormId());
        if (TALENT.equals(pkIdByName) && SECLEVELFILTER.equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("id", "!=", (Object)1010L));
        }
    }

    private void commonSecLevelColumnInit(CommonFilterColumn secLevelColumn) {
        secLevelColumn.setDefaultValue("");
        DynamicObject[] col = SecConfHelper.queryNoPriSec();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(col.length);
        for (DynamicObject dynamicObject : col) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dynamicObject.getPkValue()));
            item.setCaption(new LocaleString(dynamicObject.getString("codelevel")));
            item.setValue(String.valueOf(dynamicObject.getPkValue()));
            combos.add(item);
        }
        secLevelColumn.setComboItems(combos);
    }
}

