/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.seclevel.list;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListColumn;
import kd.bos.list.events.ChatEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.formplugin.web.seclevel.list.SecListDataProvider;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SecuserLevelList
extends HRDataBaseList {
    public static Map<String, String> map = new HashMap<String, String>(16);
    private static final String PERM_ITEM_ID = "4715a0df000000ac";
    private static final String CURRUSERID = "currUserId";
    private static final Log logger = LogFactory.getLog(SecuserLevelList.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        Long currUserId = RequestContext.get().getCurrUserId();
        FormShowParameter pa = (FormShowParameter)args.getSource();
        logger.info("currUserId:{}", (Object)currUserId);
        pa.setCustomParam(CURRUSERID, (Object)currUserId);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new SecListDataProvider());
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setSeq(colIndex);
        col.setVisible(1);
        return col;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        DynamicObject[] dynamicObjects = SecuserHelper.queryOpenFunction();
        int colIndex = 6;
        List columns = args.getListColumns();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String key = "textfield" + i;
            String caption = dynamicObjects[i].getString("name");
            ListColumn column = this.createListColumn(key, caption, colIndex + i);
            columns.add(colIndex + i, column);
            map.put(key, caption);
        }
    }

    public void chat(ChatEvent event) {
        event.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (HRStringUtils.equals((String)"userid_name", (String)args.getHyperLinkClickEvent().getFieldName())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appId = formShowParameter.getAppId();
            String customParam = formShowParameter.getCustomParam(CURRUSERID).toString();
            boolean check = PermissionServiceHelper.checkPermission((Long)Long.valueOf(customParam), (String)appId, (String)"tsrbd_secuserlevel", (String)PERM_ITEM_ID);
            if (!check) {
                args.setCancel(true);
                BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
                ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
                Object id = currentRow.getPrimaryKeyValue();
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("tsrbd_secuserlevel");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setPkId(id);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExportFile(ExportFileEvent exportFileEvent) {
        File file = exportFileEvent.getFile();
        FileOutputStream out = null;
        try (FileInputStream fis = new FileInputStream(file);
             XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);){
            int i;
            int zeroa = 0;
            int zerob = 0;
            Sheet sheet = wb.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            logger.info("lastRowNum:{}", (Object)lastRowNum);
            XSSFRow row1 = (XSSFRow)sheet.getRow(0);
            int physicalNumberOfCells = row1.getPhysicalNumberOfCells();
            logger.info("physicalNumberOfCells:{}", (Object)physicalNumberOfCells);
            for (i = 0; i < physicalNumberOfCells; ++i) {
                XSSFCell cell = row1.getCell(i);
                String captionName = cell.toString();
                logger.info("captionName:{}", (Object)captionName);
                if (HRStringUtils.equals((String)captionName, (String)"\u624b\u673a")) {
                    zeroa = i;
                }
                if (!HRStringUtils.equals((String)captionName, (String)"\u90ae\u7bb1")) continue;
                zerob = i;
            }
            for (i = 1; i < lastRowNum + 1; ++i) {
                XSSFCell cell;
                XSSFRow row = (XSSFRow)sheet.getRow(i);
                if (zeroa != 0 && (cell = row.getCell(zeroa)) != null) {
                    row.removeCell((Cell)cell);
                }
                if (zerob == 0 || (cell = row.getCell(zerob)) == null) continue;
                row.removeCell((Cell)cell);
            }
            out = new FileOutputStream(file);
            wb.write((OutputStream)out);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

