/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.workaddress;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.ext.form.dto.MapSelectPointOption;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.workaddress.service.WorkAddressDataHelper;
import org.apache.commons.lang3.ObjectUtils;

public class WorkAddressEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
MapSelectListener {
    private final Log logger = LogFactory.getLog(WorkAddressEdit.class);
    public static final String BTN_CLOSE = "btnclose1";
    public static final String FIELD_COUNTRY = "country";
    private static String PAGE_CACHE = "pageCache";
    public static final String[] UN_CHANGED_PROPS = new String[]{"number", "name", "status", "creator", "modifier", "enable", "createtime", "modifytime", "masterid", "initdatasource", "ismarked", "longitude", "latitude", "initstatus", "initbatch"};

    public void beforeClosed(BeforeClosedEvent closedEvent) {
        super.beforeClosed(closedEvent);
        closedEvent.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String unChangedProp : UN_CHANGED_PROPS) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit workAddressCountry = (BasedataEdit)this.getControl(FIELD_COUNTRY);
        BasedataEdit workAddressCity = (BasedataEdit)this.getControl("city");
        workAddressCountry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        workAddressCity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MapControl mapCtl = (MapControl)this.getView().getControl("mapcontrolap");
        mapCtl.addSelectListener((MapSelectListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW == status) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave", "btncancel"});
        } else if (OperationStatus.EDIT == status) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE});
            Object pkId = this.getModel().getValue("id");
            StringBuilder sb = new StringBuilder();
            boolean result = MutexHelper.require((IFormView)this.getView(), (String)"tsrbd_workaddr", (Object)pkId, (String)"modify", (boolean)true, (StringBuilder)sb);
            if (!result) {
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete", (IFormPlugin)this));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
        } else {
            this.getView().close();
        }
    }

    public void afterBindData(EventObject event) {
        super.beforeBindData(event);
        MapControl mapCtl = (MapControl)this.getView().getControl("mapcontrolap");
        if (BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("longitude")) != 0 || BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("latitude")) != 0) {
            MapSelectPointOption mapSelectPointOption = new MapSelectPointOption();
            mapSelectPointOption.setLng(Double.parseDouble(this.getModel().getValue("longitude").toString()));
            mapSelectPointOption.setLat(Double.parseDouble(this.getModel().getValue("latitude").toString()));
            mapSelectPointOption.setAddress(this.getModel().getValue("markedaddr").toString());
            mapSelectPointOption.setTitle(this.getModel().getValue("workaddrname").toString());
            mapSelectPointOption.setCity(this.getModel().getDataEntity().getDynamicObject("city").getString("name"));
            if (this.getModel().getDataEntity().getDynamicObject("city").getDynamicObject("parent") != null) {
                mapSelectPointOption.setProvince(this.getModel().getDataEntity().getDynamicObject("city").getString("parent.name"));
            } else {
                mapSelectPointOption.setProvince(this.getModel().getDataEntity().getDynamicObject("city").getString("name"));
            }
            mapCtl.selectPoint(mapSelectPointOption);
            this.getView().getPageCache().put(PAGE_CACHE, "1");
        }
    }

    public void initialize() {
        super.initialize();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("canMarkerDraggble", Boolean.TRUE);
        dataMap.put("k", "mapcontrolap");
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", dataMap);
    }

    public void select(MapSelectEvent evt) {
        Map map = evt.getPoint();
        IDataModel iDataModel = this.getView().getModel();
        Map point = (Map)map.get("point");
        BigDecimal longitude = (BigDecimal)point.get("lng");
        BigDecimal latitude = (BigDecimal)point.get("lat");
        iDataModel.setValue("longitude", (Object)longitude);
        iDataModel.setValue("latitude", (Object)latitude);
        String addressName = (String)map.get("title");
        if (!StringUtils.isBlank((String)addressName)) {
            String detailAddress = (String)map.get("address");
            String cityName = (String)map.get("city");
            DynamicObject cityDym = WorkAddressDataHelper.getCityDymByName((String)cityName);
            this.logger.info("\u3010WorkAddressEdit\u3011print cityName : {} and cityDym {}", (Object)cityName, (Object)cityDym);
            if (cityDym != null) {
                iDataModel.setValue(FIELD_COUNTRY, cityDym.get(FIELD_COUNTRY));
                iDataModel.setValue("city", cityDym.get("id"));
            }
            iDataModel.setValue("detailedaddr", (Object)detailAddress);
            iDataModel.setValue("markedaddr", (Object)detailAddress);
            iDataModel.setValue("workaddrname", (Object)addressName);
            iDataModel.setValue("ismarked", (Object)"1");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (property) {
            case "country": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"WorkAddressEdit_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "city": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u57ce\u5e02", (String)"WorkAddressEdit_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                QFilter qFilter = this.generateCityF7QFilter();
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    private QFilter generateCityF7QFilter() {
        QFilter qFilter = new QFilter("iscity", "=", (Object)"1");
        qFilter.and(FIELD_COUNTRY, "=", (Object)1000001);
        QFilter qOutSideChinaFileter = new QFilter("level", "=", (Object)1);
        qOutSideChinaFileter.and(FIELD_COUNTRY, "!=", (Object)1000001);
        qFilter.or(qOutSideChinaFileter);
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(FIELD_COUNTRY);
        if (dynamicObject != null) {
            qFilter.and(FIELD_COUNTRY, "=", (Object)dynamicObject.getLong("id"));
        }
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.billSavePreProcess();
                break;
            }
        }
    }

    private void billSavePreProcess() {
        this.getModel().setValue("status", (Object)"C");
        if (this.getModel().getDataEntity().getDynamicObject(FIELD_COUNTRY) == null) {
            return;
        }
        ILocaleString workCountryName = this.getModel().getDataEntity().getDynamicObject(FIELD_COUNTRY).getLocaleString("name");
        ILocaleString workCityName = this.getModel().getDataEntity().getDynamicObject("city").getLocaleString("name");
        ILocaleString workAddrName = this.getModel().getDataEntity().getLocaleString("workaddrname");
        String name = workAddrName.getLocaleValue() + "(" + workCountryName.getLocaleValue() + "-" + workCityName.getLocaleValue() + ")";
        this.getModel().setValue("name", (Object)new LocaleString(name));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "close": {
                MutexHelper.release((IFormView)this.getView());
                break;
            }
        }
        if (!args.getOperationResult().isSuccess()) {
            this.showErrorForm(args);
        }
    }

    private void showErrorForm(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        operationResult.setShowMessage(false);
        List errorInfoList = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        FormShowParameter bosOperationResultFormShowParam = new FormShowParameter();
        bosOperationResultFormShowParam.setFormId("bos_operationresult");
        bosOperationResultFormShowParam.setShowTitle(false);
        bosOperationResultFormShowParam.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"HireSalaryExptBillEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        bosOperationResultFormShowParam.setCustomParam("errorMsg", errorInfoList);
        bosOperationResultFormShowParam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(bosOperationResultFormShowParam);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String propertyName = event.getProperty().getName();
        if ("workplace".equals(propertyName)) {
            DynamicObject workplace = this.getModel().getDataEntity().getDynamicObject("workplace");
            if (ObjectUtils.isNotEmpty((Object)workplace)) {
                this.getModel().setValue(FIELD_COUNTRY, (Object)workplace.getDynamicObject(FIELD_COUNTRY).getLong("id"));
                this.getModel().setValue("city", (Object)workplace.getDynamicObject("city").getLong("id"));
            } else {
                this.getModel().setValue(FIELD_COUNTRY, null);
                this.getModel().setValue("city", null);
            }
            System.out.println("");
        }
    }
}

