/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.workaddress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.domain.workaddress.service.WorkAddressDataHelper;

public class WorkAddressList
extends HRDataBaseList {
    private static final String FIELD_COUNTRY = "country.name";
    private static final String FIELD_COUNTRY_ID = "country.id";
    private static final String FIELD_CITY = "city.name";
    private static final String COUNTRY_ID_CACHE = "countryIdCache";
    private final Map<String, List<Object>> filterDataMap = new HashMap<String, List<Object>>(16);

    private void handleFilterValues(FilterKeyValueCollections otherFilterValues) {
        if (otherFilterValues != null) {
            for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                String fieldName = (String)((FilterKeyValue)filterKeyValues.get(0)).getValue().get(0);
                List value = ((FilterKeyValue)filterKeyValues.get(1)).getValue();
                this.filterDataMap.put(fieldName, value);
            }
        }
        this.clearFilterData();
        this.getPageCache().put(COUNTRY_ID_CACHE, SerializationUtils.toJsonString(this.filterDataMap));
    }

    private void clearFilterData() {
        Map lastFilterDataMap;
        String lastFilterDataJsonStr = this.getPageCache().get(COUNTRY_ID_CACHE);
        if (HRStringUtils.isNotEmpty((String)lastFilterDataJsonStr) && (lastFilterDataMap = (Map)SerializationUtils.fromJsonString((String)lastFilterDataJsonStr, Map.class)) != null && !lastFilterDataMap.isEmpty() && !HRObjectUtils.equals(lastFilterDataMap.get(FIELD_COUNTRY_ID), this.filterDataMap.get(FIELD_COUNTRY_ID))) {
            List<Object> stgFilters = this.filterDataMap.get("city.id");
            this.clearList(stgFilters);
        }
    }

    private void clearList(List<Object> list) {
        if (list != null) {
            list.clear();
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("enable desc,modifytime desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        args.getCommonFilterColumns();
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null && this.filterDataMap.isEmpty()) {
            FilterKeyValueCollections otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues();
            this.handleFilterValues(otherFilterValues);
        }
        switch (fieldName = args.getFieldName()) {
            case "country.name": {
                List allCountryId = WorkAddressDataHelper.getAllCountryId();
                args.getQFilters().add(new QFilter("id", "in", (Object)allCountryId));
                break;
            }
            case "city.name": {
                List<QFilter> cityFilters = this.generateCityF7QFilter();
                args.getQFilters().addAll(cityFilters);
                break;
            }
        }
    }

    private List<QFilter> generateCityF7QFilter() {
        ArrayList<QFilter> cityFilters = new ArrayList<QFilter>();
        List allCityIds = WorkAddressDataHelper.getAllCityId();
        cityFilters.add(new QFilter("id", "in", (Object)allCityIds));
        List<Object> countryList = this.filterDataMap.get(FIELD_COUNTRY_ID);
        long countryId = 0L;
        if (countryList != null && !countryList.isEmpty() && !"".equals(countryList.get(0))) {
            countryId = Long.parseLong((String)countryList.get(0));
        }
        if (countryId != 0L) {
            cityFilters.add(new QFilter("country", "=", (Object)countryId));
        }
        return cityFilters;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "refresh": {
                FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
                fc.commonSearch(fc.getCachedFilterValues().getFastFilterValues().createFilterValuesList(), fc.getCachedFilterValues().getOtherFilterValues().createFilterValuesList(), fc.getEntityId());
                break;
            }
        }
    }
}

