/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.opplugin.web.autorule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.OperationException;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleBizHelper;

public class AutoRuleSaveOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(AutoRuleSaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.createBrmRule(e, e.getDataEntities());
    }

    private void createBrmRule(BeginOperationTransactionArgs args, DynamicObject[] dynamicObjects) {
        Map resultMap;
        DynamicObject dynamicObject = dynamicObjects[0];
        ArrayList entryRuleList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection ruleList = dynamicObject.getDynamicObjectCollection("entryrulelist");
        AtomicInteger order = new AtomicInteger(0);
        ruleList.forEach(ruleRow -> {
            HashMap<String, Object> ruleMap = new HashMap<String, Object>(1);
            ruleMap.put("rulename", ruleRow.getString("rulename"));
            ruleMap.put("rulenumber", ruleRow.getString("rulenumber"));
            ruleMap.put("ruleorder", order.get());
            ruleMap.put("filtercondition", ruleRow.getString("filtercondition"));
            ruleMap.put("filterresult", ruleRow.getString("filterresult"));
            ruleMap.put("ruleenable", ruleRow.get("ruleenable"));
            ruleMap.put("modifystatus", "new");
            entryRuleList.add(ruleMap);
            order.addAndGet(1);
        });
        ArrayList entryBuList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection buList = dynamicObject.getDynamicObjectCollection("entrybulist");
        buList.forEach(buRow -> {
            HashMap<String, Object> buMap = new HashMap<String, Object>(16);
            DynamicObject entitybu = buRow.getDynamicObject("entitybu");
            buMap.put("entitybu", entitybu.getLong("id"));
            buMap.put("containssub", buRow.get("containssub"));
            buMap.put("modifystatus", "new");
            entryBuList.add(buMap);
        });
        boolean retrundefault = dynamicObject.getBoolean("retrundefault");
        String defaultResult = null;
        if (retrundefault) {
            defaultResult = this.getOption().getVariableValue("defaultresultap");
        }
        String status = this.getOption().getVariableValue("status");
        try (TXHandle txhandle = TX.required();){
            if ("EDIT".equals(status)) {
                Long policyId = dynamicObject.getLong("policy.id");
                entryBuList.addAll(RuleBizHelper.getOldOrgById((Long)policyId));
                entryRuleList.addAll(RuleBizHelper.getOldRulesById((Long)policyId));
                resultMap = RuleBizHelper.modifyPolicy((DynamicObject)dynamicObject, (String)defaultResult, (List)entryRuleList, (List)entryBuList);
            } else {
                resultMap = RuleBizHelper.addRulePolicy((DynamicObject)dynamicObject, (String)defaultResult, (List)entryRuleList, (List)entryBuList);
            }
        }
        String resultCode = resultMap.get("resultCode").toString();
        if ("500".equals(resultCode)) {
            String errorMsg = resultMap.get("errorMsg").toString();
            throw this.createException(args, dynamicObject, errorMsg);
        }
        Long policyId = (Long)resultMap.get("policyId");
        dynamicObject.set("policy", (Object)policyId);
    }

    private OperationException createException(BeginOperationTransactionArgs args, DynamicObject dynamicObject, String message) {
        args.setCancelOperation(true);
        args.setDataEntities(new DynamicObject[0]);
        this.getOperationResult().setSuccess(false);
        this.getOperationResult().setMessage(message);
        OperationException operationException = new OperationException(dynamicObject.getPkValue().toString(), "", "");
        operationException.setTitle(args.getOperationKey());
        operationException.setMessage(message);
        return operationException;
    }
}

